/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.osc;

import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCTransmitter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import net.mkonrad.synes.util.ErrTools;

public class OSCMsgSender {
    private SocketAddress _oscPeer;
    private OSCTransmitter _oscTrans;

    public OSCMsgSender(int peerPort, int sendingPort) {
        this._oscPeer = new InetSocketAddress("127.0.0.1", peerPort);
        try {
            DatagramChannel udpChannelSend = DatagramChannel.open();
            udpChannelSend.socket().bind(new InetSocketAddress("127.0.0.1", sendingPort));
            this._oscTrans = OSCTransmitter.newUsing(udpChannelSend);
        }
        catch (Exception e) {
            ErrTools.print(e);
        }
    }

    public void send(OSCPacket msg) {
        try {
            this._oscTrans.send(msg, this._oscPeer);
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
    }

    public void sendOSCData(String msgName) {
        OSCMessage msg = new OSCMessage(msgName, OSCMessage.NO_ARGS);
        this.send(msg);
    }

    public void sendOSCData(String msgName, Object data) {
        if (data == null) {
            return;
        }
        OSCMessage msg = new OSCMessage(msgName, new Object[]{data});
        this.send(msg);
    }

    public void sendOSCData(String msgName, Object[] data) {
        if (data == null) {
            return;
        }
        OSCMessage msg = new OSCMessage(msgName, data);
        this.send(msg);
    }

    public void sendOSCDataOneByOne(String msgName, Object[] data) {
        int i = 0;
        while (i < data.length) {
            this.sendOSCData(msgName, data[i]);
            ++i;
        }
    }
}

