/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.synth;

import de.sciss.jcollider.Bus;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;

public class Fader {
    public static final int FADE_IN = 1;
    public static final int FADE_OUT = 2;
    private Bus _fadeOutBus;
    private Bus _fadeInBus;
    private Group _group;
    private Synth _fadeOutSynth;
    private Synth _fadeInSynth;
    private String[] _argNames;
    private float[] _fadeOutValues;
    private float[] _fadeInValues;
    private String _synthName = "fadeCtrl";

    public Fader(Server server, Group group) {
        this._group = group;
        this._fadeOutBus = Bus.control(server);
        this._fadeInBus = Bus.control(server);
        this._argNames = new String[]{"ctrlBusIndex", "startAmp", "endAmp", "dur"};
        this._fadeOutValues = new float[]{this._fadeOutBus.getIndex(), 0.1f, 0.0f, 0.1f};
        this._fadeInValues = new float[]{this._fadeInBus.getIndex(), 0.0f, 0.1f, 0.1f};
        this._fadeOutSynth = Synth.basicNew(this._synthName, server);
        this._fadeInSynth = Synth.basicNew(this._synthName, server);
    }

    public void addFadeMsgToBundle(int type, OSCBundle bndl, Synth synth) {
        Bus fadeBus;
        float[] fadeValues;
        Synth fadeSynth;
        if (type == 2) {
            fadeSynth = this._fadeOutSynth;
            fadeValues = this._fadeOutValues;
            fadeBus = this._fadeOutBus;
        } else {
            fadeSynth = this._fadeInSynth;
            fadeValues = this._fadeInValues;
            fadeBus = this._fadeInBus;
        }
        OSCMessage fadeNewMsg = fadeSynth.addToHeadMsg(this._group, this._argNames, fadeValues);
        bndl.addPacket(fadeNewMsg);
        bndl.addPacket(synth.mapnMsg(new String[]{"amp"}, new Bus[]{fadeBus}));
    }

    public void addCrossfadeMsgToBundle(OSCBundle bndl, Synth synth1, Synth synth2) {
        this.addFadeMsgToBundle(2, bndl, synth1);
        this.addFadeMsgToBundle(1, bndl, synth2);
    }
}

