/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.synth;

import de.sciss.jcollider.Group;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;
import java.io.IOException;
import javax.vecmath.Point3f;
import net.mkonrad.synes.data.IdCounter;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SeqInstrument;
import net.mkonrad.synes.data.SynthInstrument;
import net.mkonrad.synes.data.SynthObj;

public class SynthExt
extends Synth {
    private SynthObj _synthObj;
    private Group _group;

    public SynthExt(Server server, Group group, SynthObj synthObj) throws IOException {
        super(synthObj.getInstrumentSymbol(), server, IdCounter.NODE_IDS++);
        this._group = group;
        this._synthObj = synthObj;
    }

    public static SynthExt basicNew(Server server, Group group, SynthObj synthObj) throws IOException {
        return new SynthExt(server, group, synthObj);
    }

    public SynthObj getSynthObj() {
        return this._synthObj;
    }

    public void play() throws IOException {
        this.play(0, new String[0], new float[0]);
    }

    public void play(String[] inputParams, float[] inputValues) throws IOException {
        this.play(0, inputParams, inputValues);
    }

    public void play(int ms, String[] inputParams, float[] inputValues) throws IOException {
        OSCMessage newMsg = this.addToTailMsg(this._group, inputParams, inputValues);
        this.getServer().sendBundle(this.createBundle(ms, newMsg));
    }

    public void releaseWithin(int ms) throws IOException {
        OSCMessage releaseMsg = this.releaseMsg();
        this.getServer().sendBundle(this.createBundle(ms, releaseMsg));
    }

    private OSCBundle createBundle(long ms, OSCMessage msg) {
        OSCBundle bndl = new OSCBundle(System.currentTimeMillis() + ms + 50L);
        bndl.addPacket(msg);
        return bndl;
    }

    public void modSeqSynth(Point3f intercept) throws IOException {
        this.set(this._synthObj.getInstrument().getModArgs(), ((SeqInstrument)this._synthObj.getInstrument()).getAllModValues(intercept));
    }

    public void modSynthSynth(Modulator mod) throws IOException {
        this.set(this._synthObj.getInstrument().getModArgs(), ((SynthInstrument)this._synthObj.getInstrument()).getAllModValues(this._synthObj, mod));
    }
}

