/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.util;

import com.sun.j3d.utils.geometry.Text2D;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.gui.style.Colors;

public class Common3DTools {
    public static float distance2D(Point3f p1, Point3f p2) {
        float dX = p1.x - p2.x;
        float dY = p1.y - p2.y;
        return (float)Math.sqrt(dX * dX + dY * dY);
    }

    public static float rising2D(Point3f p1, Point3f p2) {
        float dX = p1.x - p2.x;
        float dY = p1.y - p2.y;
        return dY / dX;
    }

    public static TransformGroup writeText(Vector3d p, String text) {
        return Common3DTools.writeText(p, text, 36, Colors.white, "SansSerif", 0);
    }

    public static TransformGroup writeText(Vector3d p, String text, Color3f color) {
        return Common3DTools.writeText(p, text, 36, color, "SansSerif", 0);
    }

    public static TransformGroup writeText(Vector3d p, String text, int fontSize) {
        return Common3DTools.writeText(p, text, fontSize, Colors.white, "SansSerif", 0);
    }

    public static TransformGroup writeText(Vector3d p, String text, int fontSize, Color3f color, String font, int fontSpecial) {
        TransformGroup tg = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(p);
        tg.setTransform(t3d);
        Common3DTools.writeText(tg, text, fontSize, color, font, fontSpecial);
        return tg;
    }

    public static void writeText(TransformGroup tg, String text, int fontSize, Color3f color, String font, int fontSpecial) {
        Text2D message = new Text2D(text, color, font, fontSize, fontSpecial);
        message.setPickable(false);
        tg.addChild((Node)Common3DTools.wrapInBG((Node)message, new int[]{17}));
    }

    public static BranchGroup wrapInBG(Node n) {
        return Common3DTools.wrapInBG(n, new int[0]);
    }

    public static BranchGroup wrapInBG(Node n, int[] capabilityBits) {
        BranchGroup bg = new BranchGroup();
        int i = 0;
        while (i < capabilityBits.length) {
            bg.setCapability(capabilityBits[i]);
            ++i;
        }
        bg.addChild(n);
        return bg;
    }

    public static Point3f v2p(Vector3f v) {
        return new Point3f(v.x, v.y, v.z);
    }
}

