/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.util;

import net.mkonrad.synes.gui.SceneCore;

public class MusicTools {
    public static long beats2ms(float beats) {
        return (long)(Math.ceil(beats * SceneCore.getBpm() / 60.0f * 100.0f) / 100.0 * 1000.0);
    }

    public static float getPanFromXCoord(float x) {
        return 2.0f * x / 10.0f;
    }

    public static float getPitchFromYCoord(float y) {
        return 2.0f * y / 6.0f;
    }

    public static float getMidiFromYCoord(float y, boolean roundDown) {
        return MusicTools.getMidiFromYCoord(y, 1, roundDown);
    }

    public static float getMidiFromYCoord(float y, int startOctave, boolean roundDown) {
        float yMax = 6.0f;
        float midi = (float)(12 * startOctave) + (y + yMax / 2.0f) / yMax * 5.0f * 12.0f;
        if (roundDown) {
            return (float)Math.floor(midi);
        }
        return midi;
    }
}

