/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.BasicEvent;
import java.awt.EventQueue;
import java.util.ArrayList;

public class EventManager
implements Runnable {
    public static final boolean DEBUG_EVENTS = false;
    private final ArrayList collListeners = new ArrayList();
    private final ArrayList collQueue = new ArrayList();
    private boolean paused = false;
    private volatile boolean invoked = false;
    protected Processor eventProcessor;
    private Object[] events = new Object[2];

    public EventManager(Processor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    protected EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.collListeners.clear();
            this.collQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object listener) {
        if (listener != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(listener, true));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        if (listener != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(listener, false));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int numEvents;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.invoked = false;
            if (this.paused) {
                return;
            }
            numEvents = this.collQueue.size();
            this.events = this.collQueue.toArray(this.events);
            this.collQueue.clear();
        }
        for (int i = 0; i < numEvents; ++i) {
            if (this.events[i] instanceof BasicEvent) {
                try {
                    this.eventProcessor.processEvent((BasicEvent)this.events[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PostponedAction pa = (PostponedAction)this.events[i];
                if (pa.state) {
                    if (!this.collListeners.contains(pa.listener)) {
                        this.collListeners.add(pa.listener);
                    }
                } else {
                    this.collListeners.remove(pa.listener);
                }
            }
            this.events[i] = null;
        }
    }

    public Object getListener(int index) {
        return this.collListeners.get(index);
    }

    public int countListeners() {
        return this.collListeners.size();
    }

    public void debugDump() {
        for (int i = 0; i < this.collListeners.size(); ++i) {
            System.err.println("listen " + i + " = " + this.collListeners.get(i).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(BasicEvent e) {
        boolean invoke;
        EventManager eventManager = this;
        synchronized (eventManager) {
            Object o;
            invoke = !this.paused && !this.invoked;
            int i = this.collQueue.size() - 1;
            if (i >= 0 && (o = this.collQueue.get(i)) instanceof BasicEvent && e.incorporate((BasicEvent)o)) {
                this.collQueue.set(i, e);
            } else {
                this.collQueue.add(e);
            }
        }
        if (invoke) {
            this.invoked = true;
            EventQueue.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean invoke;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = false;
            invoke = !this.collQueue.isEmpty();
        }
        if (invoke) {
            EventQueue.invokeLater(this);
        }
    }

    private class PostponedAction {
        protected final Object listener;
        protected final boolean state;

        protected PostponedAction(Object listener, boolean state) {
            this.listener = listener;
            this.state = state;
        }
    }

    public static interface Processor {
        public void processEvent(BasicEvent var1);
    }
}

