/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.BlockAllocator;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Control;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.OSCResponderNode;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.SynthDef;
import de.sciss.jcollider.UGen;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.List;

public class Buffer
implements Constants {
    private final Server server;
    private final int bufNum;
    private int numFrames;
    private int numChannels;
    private double sampleRate;
    private String path = null;
    private CompletionAction doOnInfo = null;

    public Buffer(Server server, int numFrames, int numChannels) {
        this(server, numFrames, numChannels, server.getBufferAllocator().alloc(1));
    }

    public Buffer(Server server, int numFrames, int numChannels, int bufNum) {
        this.server = server;
        this.bufNum = bufNum;
        this.numFrames = numFrames;
        this.numChannels = numChannels;
        this.sampleRate = server.getSampleRate();
    }

    private Buffer(Server server, int bufNum) {
        this.server = server;
        this.bufNum = bufNum;
    }

    public Server getServer() {
        return this.server;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    protected void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getBufNum() {
        return this.bufNum;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected void setNumFrames(int numFrames) {
        this.numFrames = numFrames;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    protected void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public String getPath() {
        return this.path;
    }

    private void setPath(String path) {
        this.path = path;
    }

    public double getDuration() {
        return (double)this.getNumFrames() / this.getSampleRate();
    }

    public String toString() {
        return "Buffer(" + this.getBufNum() + ", " + this.getNumFrames() + ", " + this.getNumChannels() + ", " + this.getSampleRate() + ", " + this.getPath() + ")";
    }

    public static Buffer alloc(Server server, int numFrames) throws IOException {
        return Buffer.alloc(server, numFrames, 1);
    }

    public static Buffer alloc(Server server, int numFrames, int numChannels) throws IOException {
        return Buffer.alloc(server, numFrames, numChannels, null);
    }

    public static Buffer alloc(Server server, int numFrames, int numChannels, CompletionFunction completionFunc) throws IOException {
        int bufNum = server.getBufferAllocator().alloc(1);
        if (bufNum == -1) {
            Server.getPrintStream().println("Buffer.alloc: failed to get a buffer allocated. ; server: " + server.getName());
            return null;
        }
        return Buffer.alloc(server, numFrames, numChannels, completionFunc, bufNum);
    }

    public static Buffer alloc(Server server, int numFrames, int numChannels, CompletionFunction completionFunc, int bufNum) throws IOException {
        Buffer buf = new Buffer(server, numFrames, numChannels, bufNum);
        buf.alloc(completionFunc == null ? null : completionFunc.completion(buf));
        return buf;
    }

    public static Buffer[] allocConsecutive(int numBufs, Server server, int numFrames) throws IOException {
        return Buffer.allocConsecutive(numBufs, server, numFrames, 1);
    }

    public static Buffer[] allocConsecutive(int numBufs, Server server, int numFrames, int numChannels) throws IOException {
        return Buffer.allocConsecutive(numBufs, server, numFrames, numChannels, null);
    }

    public static Buffer[] allocConsecutive(int numBufs, Server server, int numFrames, int numChannels, CompletionFunction completionFunc) throws IOException {
        int bufNum = server.getBufferAllocator().alloc(numBufs);
        if (bufNum == -1) {
            Server.getPrintStream().println("Buffer.alloc: failed to get " + numBufs + " buffers allocated. " + "; server: " + server.getName());
            return null;
        }
        return Buffer.allocConsecutive(numBufs, server, numFrames, numChannels, completionFunc, bufNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer[] allocConsecutive(int numBufs, Server server, int numFrames, int numChannels, CompletionFunction completionFunc, int bufNum) throws IOException {
        Buffer[] bufs = new Buffer[numBufs];
        boolean success = false;
        try {
            for (int i = 0; i < numBufs; ++i) {
                Buffer buf = new Buffer(server, numFrames, numChannels, bufNum + i);
                buf.alloc(completionFunc == null ? null : completionFunc.completion(buf));
                bufs[i] = buf;
            }
            success = true;
            Buffer[] bufferArray = bufs;
            return bufferArray;
        }
        finally {
            if (!success) {
                for (int i = 0; i < numBufs; ++i) {
                    if (bufs[i] == null) continue;
                    try {
                        bufs[i].free();
                        continue;
                    }
                    catch (IOException e1) {}
                }
            }
        }
    }

    public void alloc() throws IOException {
        this.alloc(null);
    }

    public void alloc(OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.allocMsg(completionMsg));
    }

    public OSCMessage allocMsg() throws IOException {
        return this.allocMsg(null);
    }

    public OSCMessage allocMsg(OSCMessage completionMsg) throws IOException {
        Object[] objectArray;
        this.addToServerArray();
        if (completionMsg == null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = new Integer(this.getBufNum());
            objectArray2[1] = new Integer(this.getNumFrames());
            objectArray = objectArray2;
            objectArray2[2] = new Integer(this.getNumChannels());
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = new Integer(this.getBufNum());
            objectArray3[1] = new Integer(this.getNumFrames());
            objectArray3[2] = new Integer(this.getNumChannels());
            objectArray = objectArray3;
            objectArray3[3] = completionMsg;
        }
        Object[] args = objectArray;
        return new OSCMessage("/b_alloc", args);
    }

    public void allocRead(String path) throws IOException {
        this.allocRead(path, 0L);
    }

    public void allocRead(String path, long startFrame) throws IOException {
        this.allocRead(path, startFrame, -1);
    }

    public void allocRead(String path, long startFrame, int numFrames) throws IOException {
        this.allocRead(path, startFrame, numFrames, null);
    }

    public void allocRead(String path, long startFrame, int numFrames, OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.allocReadMsg(path, startFrame, numFrames, completionMsg));
    }

    public void allocReadChannel(String path, long startFrame, int numFrames, int[] channels) throws IOException {
        this.allocReadChannel(path, startFrame, numFrames, channels, null);
    }

    public void allocReadChannel(String path, long startFrame, int numFrames, int[] channels, OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.allocReadChannelMsg(path, startFrame, numFrames, channels, completionMsg));
    }

    public OSCMessage allocReadMsg(String path) throws IOException {
        return this.allocReadMsg(path, 0L);
    }

    public OSCMessage allocReadMsg(String path, long startFrame) throws IOException {
        return this.allocReadMsg(path, startFrame, -1);
    }

    public OSCMessage allocReadMsg(String path, long startFrame, int numFrames) throws IOException {
        return this.allocReadMsg(path, startFrame, numFrames, null);
    }

    public OSCMessage allocReadMsg(String path, long startFrame, int numFrames, OSCMessage completionMsg) throws IOException {
        Object[] objectArray;
        this.addToServerArray();
        if (startFrame > Integer.MAX_VALUE) {
            Server.getPrintStream().println("Buffer.allocReadMsg : startFrame (" + startFrame + ") exceeds 32bit int");
        }
        this.setPath(path);
        if (completionMsg == null) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = new Integer(this.getBufNum());
            objectArray2[1] = path;
            objectArray2[2] = new Long(startFrame);
            objectArray = objectArray2;
            objectArray2[3] = new Integer(numFrames);
        } else {
            Object[] objectArray3 = new Object[5];
            objectArray3[0] = new Integer(this.getBufNum());
            objectArray3[1] = path;
            objectArray3[2] = new Long(startFrame);
            objectArray3[3] = new Integer(numFrames);
            objectArray = objectArray3;
            objectArray3[4] = completionMsg;
        }
        Object[] args = objectArray;
        return new OSCMessage("/b_allocRead", args);
    }

    public OSCMessage allocReadChannelMsg(String path, long startFrame, int numFrames, int[] channels) throws IOException {
        return this.allocReadChannelMsg(path, startFrame, numFrames, channels, null);
    }

    public OSCMessage allocReadChannelMsg(String path, long startFrame, int numFrames, int[] channels, OSCMessage completionMsg) throws IOException {
        this.addToServerArray();
        if (startFrame > Integer.MAX_VALUE) {
            Server.getPrintStream().println("Buffer.allocReadChannelMsg : startFrame (" + startFrame + ") exceeds 32bit int");
        }
        this.setPath(path);
        Object[] args = new Object[4 + channels.length + (completionMsg == null ? 0 : 1)];
        args[0] = new Integer(this.getBufNum());
        args[1] = path;
        args[2] = new Long(startFrame);
        args[3] = new Integer(numFrames);
        int i = 4;
        int j = 0;
        while (j < channels.length) {
            args[i++] = new Integer(channels[j++]);
        }
        if (completionMsg != null) {
            args[args.length - 1] = completionMsg;
        }
        return new OSCMessage("/b_allocReadChannel", args);
    }

    public static Buffer read(Server server, String path) throws IOException {
        return Buffer.read(server, path, 0L);
    }

    public static Buffer read(Server server, String path, long startFrame) throws IOException {
        return Buffer.read(server, path, startFrame, -1);
    }

    public static Buffer read(Server server, String path, long startFrame, int numFrames) throws IOException {
        return Buffer.read(server, path, startFrame, numFrames, null);
    }

    public static Buffer read(Server server, String path, long startFrame, int numFrames, CompletionAction action) throws IOException {
        int bufNum = server.getBufferAllocator().alloc(1);
        if (bufNum == -1) {
            Server.getPrintStream().println("Buffer.read: failed to get a buffer allocated. ; server: " + server.getName());
            return null;
        }
        return Buffer.read(server, path, startFrame, numFrames, action, bufNum);
    }

    public static Buffer read(Server server, String path, long startFrame, int numFrames, CompletionAction action, int bufNum) throws IOException {
        Buffer buf = new Buffer(server, bufNum);
        buf.setDoOnInfo(action);
        buf.waitForBufInfo();
        buf.allocRead(path, startFrame, numFrames, buf.queryMsg());
        return buf;
    }

    public static Buffer readChannel(Server server, String path, long startFrame, int numFrames, int[] channels) throws IOException {
        return Buffer.readChannel(server, path, startFrame, numFrames, channels, null);
    }

    public static Buffer readChannel(Server server, String path, long startFrame, int numFrames, int[] channels, CompletionAction action) throws IOException {
        int bufNum = server.getBufferAllocator().alloc(1);
        if (bufNum == -1) {
            Server.getPrintStream().println("Buffer.readChannel: failed to get a buffer allocated. ; server: " + server.getName());
            return null;
        }
        return Buffer.readChannel(server, path, startFrame, numFrames, channels, action, bufNum);
    }

    public static Buffer readChannel(Server server, String path, long startFrame, int numFrames, int[] channels, CompletionAction action, int bufNum) throws IOException {
        Buffer buf = new Buffer(server, bufNum);
        buf.setDoOnInfo(action);
        buf.waitForBufInfo();
        buf.allocReadChannel(path, startFrame, numFrames, channels, buf.queryMsg());
        return buf;
    }

    public void read(String path) throws IOException {
        this.read(path, 0L);
    }

    public void read(String path, long fileStartFrame) throws IOException {
        this.read(path, fileStartFrame, -1);
    }

    public void read(String path, long fileStartFrame, int numFrames) throws IOException {
        this.read(path, fileStartFrame, numFrames, 0);
    }

    public void read(String path, long fileStartFrame, int numFrames, int bufStartFrame) throws IOException {
        this.read(path, fileStartFrame, numFrames, bufStartFrame, false);
    }

    public void read(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen) throws IOException {
        this.read(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, null);
    }

    public void read(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, CompletionAction action) throws IOException {
        this.addToServerArray();
        this.setDoOnInfo(action);
        this.waitForBufInfo();
        this.getServer().sendMsg(this.readMsg(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, this.queryMsg()));
    }

    public void readChannel(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, int[] channels, CompletionAction action) throws IOException {
        this.addToServerArray();
        this.setDoOnInfo(action);
        this.waitForBufInfo();
        this.getServer().sendMsg(this.readChannelMsg(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, channels, this.queryMsg()));
    }

    public OSCMessage readMsg(String path) {
        return this.readMsg(path, 0L);
    }

    public OSCMessage readMsg(String path, long fileStartFrame) {
        return this.readMsg(path, fileStartFrame, -1);
    }

    public OSCMessage readMsg(String path, long fileStartFrame, int numFrames) {
        return this.readMsg(path, fileStartFrame, numFrames, 0);
    }

    public OSCMessage readMsg(String path, long fileStartFrame, int numFrames, int bufStartFrame) {
        return this.readMsg(path, fileStartFrame, numFrames, bufStartFrame, false);
    }

    public OSCMessage readMsg(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen) {
        return this.readMsg(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, null);
    }

    public OSCMessage readMsg(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, OSCMessage completionMsg) {
        Object[] objectArray;
        if (fileStartFrame > Integer.MAX_VALUE) {
            Server.getPrintStream().println("Buffer.readMsg : fileStartFrame (" + fileStartFrame + ") exceeds 32bit int");
        }
        this.setPath(path);
        if (completionMsg == null) {
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = new Integer(this.getBufNum());
            objectArray2[1] = path;
            objectArray2[2] = new Long(fileStartFrame);
            objectArray2[3] = new Integer(numFrames);
            objectArray2[4] = new Integer(bufStartFrame);
            objectArray = objectArray2;
            objectArray2[5] = new Integer(leaveOpen ? 1 : 0);
        } else {
            Object[] objectArray3 = new Object[7];
            objectArray3[0] = new Integer(this.getBufNum());
            objectArray3[1] = path;
            objectArray3[2] = new Long(fileStartFrame);
            objectArray3[3] = new Integer(numFrames);
            objectArray3[4] = new Integer(bufStartFrame);
            objectArray3[5] = new Integer(leaveOpen ? 1 : 0);
            objectArray = objectArray3;
            objectArray3[6] = completionMsg;
        }
        Object[] args = objectArray;
        return new OSCMessage("/b_read", args);
    }

    public OSCMessage readChannelMsg(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, int[] channels) {
        return this.readChannelMsg(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, channels, null);
    }

    public OSCMessage readChannelMsg(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, int[] channels, OSCMessage completionMsg) {
        if (fileStartFrame > Integer.MAX_VALUE) {
            Server.getPrintStream().println("Buffer.readChannelMsg : fileStartFrame (" + fileStartFrame + ") exceeds 32bit int");
        }
        this.setPath(path);
        Object[] args = new Object[6 + channels.length + (completionMsg == null ? 0 : 1)];
        args[0] = new Integer(this.getBufNum());
        args[1] = path;
        args[2] = new Long(fileStartFrame);
        args[3] = new Integer(numFrames);
        args[4] = new Integer(bufStartFrame);
        args[5] = new Integer(leaveOpen ? 1 : 0);
        int i = 6;
        int j = 0;
        while (j < channels.length) {
            args[i++] = new Integer(channels[j++]);
        }
        if (completionMsg != null) {
            args[args.length - 1] = completionMsg;
        }
        return new OSCMessage("/b_readChannel", args);
    }

    public void write(String path) throws IOException {
        this.write(path, "aiff", "int24");
    }

    public void write(String path, String headerFormat, String sampleFormat) throws IOException {
        this.write(path, headerFormat, sampleFormat, -1);
    }

    public void write(String path, String headerFormat, String sampleFormat, int numFrames) throws IOException {
        this.write(path, headerFormat, sampleFormat, numFrames, 0);
    }

    public void write(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame) throws IOException {
        this.write(path, headerFormat, sampleFormat, numFrames, bufStartFrame, false);
    }

    public void write(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame, boolean leaveOpen) throws IOException {
        this.write(path, headerFormat, sampleFormat, numFrames, bufStartFrame, leaveOpen, null);
    }

    public void write(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame, boolean leaveOpen, OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.writeMsg(path, headerFormat, sampleFormat, numFrames, bufStartFrame, leaveOpen, completionMsg));
    }

    public OSCMessage writeMsg(String path) {
        return this.writeMsg(path, "aiff", "int24");
    }

    public OSCMessage writeMsg(String path, String headerFormat, String sampleFormat) {
        return this.writeMsg(path, headerFormat, sampleFormat, -1);
    }

    public OSCMessage writeMsg(String path, String headerFormat, String sampleFormat, int numFrames) {
        return this.writeMsg(path, headerFormat, sampleFormat, numFrames, 0);
    }

    public OSCMessage writeMsg(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame) {
        return this.writeMsg(path, headerFormat, sampleFormat, numFrames, bufStartFrame, false);
    }

    public OSCMessage writeMsg(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame, boolean leaveOpen) {
        return this.writeMsg(path, headerFormat, sampleFormat, numFrames, bufStartFrame, leaveOpen, null);
    }

    public OSCMessage writeMsg(String path, String headerFormat, String sampleFormat, int numFrames, int bufStartFrame, boolean leaveOpen, OSCMessage completionMsg) {
        Object[] objectArray;
        if (completionMsg == null) {
            Object[] objectArray2 = new Object[7];
            objectArray2[0] = new Integer(this.getBufNum());
            objectArray2[1] = path;
            objectArray2[2] = headerFormat;
            objectArray2[3] = sampleFormat;
            objectArray2[4] = new Integer(numFrames);
            objectArray2[5] = new Integer(bufStartFrame);
            objectArray = objectArray2;
            objectArray2[6] = new Integer(leaveOpen ? 1 : 0);
        } else {
            Object[] objectArray3 = new Object[8];
            objectArray3[0] = new Integer(this.getBufNum());
            objectArray3[1] = path;
            objectArray3[2] = headerFormat;
            objectArray3[3] = sampleFormat;
            objectArray3[4] = new Integer(numFrames);
            objectArray3[5] = new Integer(bufStartFrame);
            objectArray3[6] = new Integer(leaveOpen ? 1 : 0);
            objectArray = objectArray3;
            objectArray3[7] = completionMsg;
        }
        Object[] args = objectArray;
        return new OSCMessage("/b_write", args);
    }

    private void setDoOnInfo(CompletionAction action) {
        this.doOnInfo = action;
    }

    private CompletionAction getDoOnInfo() {
        return this.doOnInfo;
    }

    public static Buffer readNoUpdate(Server server, String path) throws IOException {
        return Buffer.readNoUpdate(server, path, 0L);
    }

    public static Buffer readNoUpdate(Server server, String path, long startFrame) throws IOException {
        return Buffer.readNoUpdate(server, path, startFrame, -1);
    }

    public static Buffer readNoUpdate(Server server, String path, long startFrame, int numFrames) throws IOException {
        return Buffer.readNoUpdate(server, path, startFrame, numFrames, null);
    }

    public static Buffer readNoUpdate(Server server, String path, long startFrame, int numFrames, CompletionFunction completionFunc) throws IOException {
        int bufNum = server.getBufferAllocator().alloc(1);
        if (bufNum == -1) {
            Server.getPrintStream().println("Buffer.readNoUpdate: failed to get a buffer allocated. ; server: " + server.getName());
            return null;
        }
        return Buffer.readNoUpdate(server, path, startFrame, numFrames, completionFunc, bufNum);
    }

    public static Buffer readNoUpdate(Server server, String path, long startFrame, int numFrames, CompletionFunction completionFunc, int bufNum) throws IOException {
        Buffer buf = new Buffer(server, bufNum);
        buf.allocRead(path, startFrame, numFrames, completionFunc == null ? null : completionFunc.completion(buf));
        return buf;
    }

    public void readNoUpdate(String path) throws IOException {
        this.readNoUpdate(path, 0L);
    }

    public void readNoUpdate(String path, long fileStartFrame) throws IOException {
        this.readNoUpdate(path, fileStartFrame, -1);
    }

    public void readNoUpdate(String path, long fileStartFrame, int numFrames) throws IOException {
        this.readNoUpdate(path, fileStartFrame, numFrames, 0);
    }

    public void readNoUpdate(String path, long fileStartFrame, int numFrames, int bufStartFrame) throws IOException {
        this.readNoUpdate(path, fileStartFrame, numFrames, bufStartFrame, false);
    }

    public void readNoUpdate(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen) throws IOException {
        this.readNoUpdate(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, null);
    }

    public void readNoUpdate(String path, long fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.readMsg(path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, completionMsg));
    }

    public static Buffer cueSoundFile(Server server, String path) throws IOException {
        return Buffer.cueSoundFile(server, path, 0L);
    }

    public static Buffer cueSoundFile(Server server, String path, long startFrame) throws IOException {
        return Buffer.cueSoundFile(server, path, startFrame, 1);
    }

    public static Buffer cueSoundFile(Server server, String path, long startFrame, int numChannels) throws IOException {
        return Buffer.cueSoundFile(server, path, startFrame, numChannels, 32768);
    }

    public static Buffer cueSoundFile(Server server, String path, long startFrame, int numChannels, int bufferSize) throws IOException {
        return Buffer.cueSoundFile(server, path, startFrame, numChannels, bufferSize, null);
    }

    public static Buffer cueSoundFile(Server server, final String path, final long startFrame, int numChannels, final int bufferSize, final CompletionFunction completionFunc) throws IOException {
        Buffer buf = Buffer.alloc(server, bufferSize, numChannels, new CompletionFunction(){

            public OSCMessage completion(Buffer buf) {
                return buf.readMsg(path, startFrame, bufferSize, 0, true, completionFunc == null ? null : completionFunc.completion(buf));
            }
        });
        buf.addToServerArray();
        return buf;
    }

    public void cueSoundFile(String path) throws IOException {
        this.cueSoundFile(path, 0L);
    }

    public void cueSoundFile(String path, long startFrame) throws IOException {
        this.cueSoundFile(path, startFrame, null);
    }

    public void cueSoundFile(String path, long startFrame, OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.cueSoundFileMsg(path, startFrame, completionMsg));
    }

    public OSCMessage cueSoundFileMsg(String path, long startFrame, OSCMessage completionMsg) {
        return this.readMsg(path, startFrame, this.getNumFrames(), 0, true, completionMsg);
    }

    private void addToServerArray() throws IOException {
        this.getServer().addBuf(this);
    }

    private void waitForBufInfo() throws IOException {
        this.getServer().waitForBufInfo();
    }

    protected void queryDone() {
        if (this.getDoOnInfo() != null) {
            this.getDoOnInfo().completion(this);
            this.setDoOnInfo(null);
        }
    }

    public void fill(int startAt, int numSamples, float value) throws IOException {
        this.getServer().sendMsg(this.fillMsg(startAt, numSamples, value));
    }

    public OSCMessage fillMsg(int startAt, int numSamples, float value) {
        return new OSCMessage("/b_fill", new Object[]{new Integer(this.getBufNum()), new Integer(startAt), new Integer(numSamples), new Float(value)});
    }

    public void fill(int[] startAt, int[] numSamples, float[] value) throws IOException {
        this.getServer().sendMsg(this.fillMsg(startAt, numSamples, value));
    }

    public OSCMessage fillMsg(int[] startAt, int[] numSamples, float[] value) {
        Object[] args = new Object[startAt.length * 3 + 1];
        args[0] = new Integer(this.getBufNum());
        int j = 1;
        for (int i = 0; i < startAt.length; ++i) {
            args[j++] = new Integer(startAt[i]);
            args[j++] = new Integer(numSamples[i]);
            args[j++] = new Float(value[i]);
        }
        return new OSCMessage("/b_fill", args);
    }

    public void close() throws IOException {
        this.close(null);
    }

    public void close(OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.closeMsg(completionMsg));
    }

    public OSCMessage closeMsg() {
        return this.closeMsg(null);
    }

    public OSCMessage closeMsg(OSCMessage completionMsg) {
        return this.simpleMsg("/b_close", completionMsg);
    }

    private OSCMessage simpleMsg(String cmdName, OSCMessage completionMsg) {
        Object[] objectArray;
        if (completionMsg == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new Integer(this.getBufNum());
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = new Integer(this.getBufNum());
            objectArray = objectArray3;
            objectArray3[1] = completionMsg;
        }
        Object[] args = objectArray;
        return new OSCMessage(cmdName, args);
    }

    public void free() throws IOException {
        this.free(null);
    }

    public void free(OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.freeMsg(completionMsg));
    }

    public OSCMessage freeMsg() {
        return this.freeMsg(null);
    }

    public OSCMessage freeMsg(OSCMessage completionMsg) {
        this.getServer().freeBuf(this.getBufNum());
        this.getServer().getBufferAllocator().free(this.getBufNum());
        return this.simpleMsg("/b_free", completionMsg);
    }

    public void zero() throws IOException {
        this.zero(null);
    }

    public void zero(OSCMessage completionMsg) throws IOException {
        this.getServer().sendMsg(this.zeroMsg(completionMsg));
    }

    public OSCMessage zeroMsg() {
        return this.zeroMsg(null);
    }

    public OSCMessage zeroMsg(OSCMessage completionMsg) {
        return this.simpleMsg("/b_zero", completionMsg);
    }

    public static void freeAll(Server server) throws IOException {
        BlockAllocator bufferAllocator = server.getBufferAllocator();
        List blocks = bufferAllocator.getAllocatedBlocks();
        OSCBundle bndl = new OSCBundle(0.0);
        for (int i = 0; i < blocks.size(); ++i) {
            BlockAllocator.Block block = (BlockAllocator.Block)blocks.get(i);
            bndl.addPacket((OSCPacket)new OSCMessage("/b_free", new Object[]{new Integer(block.getAddress())}));
            bufferAllocator.free(block.getAddress());
            server.freeBuf(block.getAddress());
        }
        if (bndl.getPacketCount() > 0) {
            server.sendBundle(bndl);
        }
    }

    public void query() throws IOException {
        new OSCResponderNode(this.getServer(), "/b_info", new OSCListener(){

            public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
                Server.getPrintStream().println("bufNum      : " + msg.getArg(0) + "\nnumFrames   : " + msg.getArg(1) + "\nnumChannels : " + msg.getArg(2) + "\nsampleRate  : " + msg.getArg(3) + "\n");
            }
        }).removeWhenDone().add();
        this.getServer().sendMsg(this.queryMsg());
    }

    public OSCMessage queryMsg() {
        return this.simpleMsg("/b_query", null);
    }

    public void updateInfo(CompletionAction action) throws IOException {
        this.addToServerArray();
        this.setDoOnInfo(action);
        this.waitForBufInfo();
        this.getServer().sendMsg(this.queryMsg());
    }

    public void printOn(PrintStream stream) {
        stream.print(this.getClass().getName() + "(" + this.getBufNum() + "," + this.getNumFrames() + "," + this.getNumChannels() + "," + this.getSampleRate() + "," + this.getPath() + ")");
    }

    public Synth play() throws IOException {
        return this.play(false);
    }

    public Synth play(boolean loop) throws IOException {
        return this.play(loop, 1.0f);
    }

    public Synth play(boolean loop, float amp) throws IOException {
        return this.play(loop, amp, 0);
    }

    public Synth play(boolean loop, float amp, int outBus) throws IOException {
        return this.play(loop, amp, outBus, 0.02f);
    }

    public Synth play(boolean loop, float amp, int outBus, float fadeTime) throws IOException {
        return this.play(loop, amp, outBus, fadeTime, null, 0);
    }

    public Synth play(boolean loop, float amp, int outBus, float fadeTime, Node target, int addAction) throws IOException {
        Control out = Control.ir("i_out", 0.0f);
        GraphElem bufNum = UGen.ir(this.getBufNum());
        GraphElem player = UGen.ar("PlayBuf", this.getNumChannels(), bufNum, UGen.kr("BufRateScale", bufNum), UGen.ir(1.0f), UGen.ir(0.0f), UGen.ir(loop ? 1.0f : 0.0f));
        if (fadeTime > 0.0f) {
            Control ctrl = Control.kr(new String[]{"fadeTime", "gate"}, new float[]{fadeTime, 1.0f});
            GraphElem dt = ctrl.getOutput(0);
            GraphElem gate = ctrl.getOutput(1);
            player = UGen.ar("*", player, UGen.kr("Linen", gate, dt, UGen.ir(1.0f), dt, UGen.ir(2.0f)));
        }
        GraphElem graph = UGen.ar("Out", out, UGen.ar("*", player, UGen.ir(amp)));
        if (!loop) {
            graph = UGen.array(graph, UGen.kr("Line", UGen.ir(0.0f), UGen.ir(1.0f), UGen.kr("BufDur", bufNum), UGen.ir(2.0f)));
        }
        String name = "temp_" + String.valueOf(Math.abs(this.hashCode()));
        SynthDef def = new SynthDef(name, graph);
        Synth synth = Synth.basicNew(name, this.getServer());
        OSCMessage newMsg = synth.newMsg(target, new String[]{"i_out"}, new float[]{outBus}, addAction);
        def.send(this.getServer(), newMsg);
        return synth;
    }

    public static interface CompletionFunction {
        public OSCMessage completion(Buffer var1);
    }

    public static interface CompletionAction {
        public void completion(Buffer var1);
    }
}

