/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Server;
import java.io.PrintStream;

public class Bus
implements Constants {
    private final Server server;
    private Object rate;
    private int index;
    private int numChannels;

    public Bus(Server server) {
        this(server, kAudioRate);
    }

    public Bus(Server server, Object rate) {
        this(server, rate, 0);
    }

    public Bus(Server server, Object rate, int index) {
        this(server, rate, index, 1);
    }

    public Bus(Server server, Object rate, int index, int numChannels) {
        this.rate = rate;
        this.index = index;
        this.numChannels = numChannels;
        this.server = server;
    }

    public static Bus control(Server server) {
        return Bus.control(server, 1);
    }

    public static Bus control(Server server, int numChannels) {
        int alloc = server.getControlBusAllocator().alloc(numChannels);
        if (alloc == -1) {
            Server.getPrintStream().println("Bus.control: failed to get a control bus allocated. numChannels: " + numChannels + "; server: " + server.getName());
            return null;
        }
        return new Bus(server, kControlRate, alloc, numChannels);
    }

    public static Bus audio(Server server) {
        return Bus.audio(server, 1);
    }

    public static Bus audio(Server server, int numChannels) {
        int alloc = server.getAudioBusAllocator().alloc(numChannels);
        if (alloc == -1) {
            Server.getPrintStream().println("Bus.audio: failed to get a audio bus allocated. numChannels: " + numChannels + "; server: " + server.getName());
            return null;
        }
        return new Bus(server, kAudioRate, alloc, numChannels);
    }

    public static Bus alloc(Server server, Object rate) {
        return Bus.alloc(server, rate, 1);
    }

    public static Bus alloc(Server server, Object rate, int numChannels) {
        if (rate == kAudioRate) {
            return Bus.audio(server, numChannels);
        }
        if (rate == kControlRate) {
            return Bus.control(server, numChannels);
        }
        throw new IllegalArgumentException(rate.toString());
    }

    public String toString() {
        return "Bus(" + this.server.getName() + ", " + this.getRate() + ", " + this.getIndex() + ", " + this.getNumChannels() + ")";
    }

    public Object getRate() {
        return this.rate;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getIndex() {
        return this.index;
    }

    public Server getServer() {
        return this.server;
    }

    private void setRate(Object rate) {
        this.rate = rate;
    }

    private void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public void free() {
        if (this.getIndex() == -1) {
            this.printOn(Server.getPrintStream());
            Server.getPrintStream().println(" has already been freed");
            return;
        }
        if (this.getRate() == kAudioRate) {
            this.getServer().getAudioBusAllocator().free(this.index);
        } else if (this.getRate() == kControlRate) {
            this.getServer().getControlBusAllocator().free(this.index);
        } else {
            throw new IllegalStateException(this.getRate().toString());
        }
        this.setIndex(-1);
        this.setNumChannels(-1);
    }

    public void alloc() {
        if (this.getRate() == kAudioRate) {
            this.setIndex(this.getServer().getAudioBusAllocator().alloc(this.getNumChannels()));
        } else if (this.getRate() == kControlRate) {
            this.setIndex(this.getServer().getControlBusAllocator().alloc(this.getNumChannels()));
        } else {
            throw new IllegalStateException(this.getRate().toString());
        }
    }

    public void realloc() {
        if (this.getIndex() == -1) {
            return;
        }
        Object oldRate = this.getRate();
        int oldCh = this.getNumChannels();
        this.free();
        this.setRate(oldRate);
        this.setNumChannels(oldCh);
        this.alloc();
    }

    public void printOn(PrintStream stream) {
        stream.print(this.getClass().getName() + "(" + this.getServer().getName() + "," + this.getRate() + "," + this.getIndex() + "," + this.getNumChannels() + ")");
    }

    public boolean equals(Object o) {
        if (o instanceof Bus) {
            Bus aBus = (Bus)o;
            return this.getIndex() == aBus.getIndex() && this.getNumChannels() == aBus.getNumChannels() && this.getRate() == aBus.getRate() && this.getServer() == aBus.getServer();
        }
        return false;
    }

    public int hashCode() {
        return this.getIndex() ^ -this.getNumChannels() ^ this.getRate().hashCode() ^ this.getServer().hashCode();
    }

    public boolean isAudioOut() {
        return this.rate == kAudioRate && this.getIndex() < this.getServer().getOptions().getFirstPrivateBus();
    }
}

