/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.BlockAllocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContiguousBlockAllocator
implements BlockAllocator {
    private final int size;
    private final Block[] array;
    private final Map freed;
    private final int pos;
    private int top;

    public ContiguousBlockAllocator(int size) {
        this(size, 0);
    }

    public ContiguousBlockAllocator(int size, int pos) {
        this.size = size;
        this.pos = pos;
        this.array = new Block[size];
        this.array[pos] = new Block(pos, size - pos);
        this.freed = new HashMap();
        this.top = pos;
    }

    public int alloc() {
        return this.alloc(1);
    }

    public int alloc(int n) {
        Block b = this.findAvailable(n);
        if (b == null) {
            return -1;
        }
        return this.reserve((int)b.start, (int)n, (Block)b, null).start;
    }

    public Block reserve(int address) {
        return this.reserve(address, 1);
    }

    public Block reserve(int address, int size) {
        Block b = this.array[address] != null ? this.array[address] : this.findNext(address);
        if (b != null && b.used && address + size > b.start) {
            throw new IllegalStateException("The block at (" + address + ", " + size + ") is already in use and cannot be reserved.");
        }
        if (b.start == address) {
            return this.reserve(address, size, b, null);
        }
        b = this.findPrevious(address);
        if (b != null && b.used && b.start + b.size > address) {
            throw new IllegalStateException("The block at (" + address + ", " + size + ") is already in use and cannot be reserved.");
        }
        return this.reserve(address, size, null, b);
    }

    public void free(int address) {
        Block b = this.array[address];
        if (b != null && b.used) {
            Block next;
            Block temp;
            b.used = false;
            this.addToFreed(b);
            Block prev = this.findPrevious(address);
            if (prev != null && !prev.used && (temp = prev.join(b)) != null) {
                if (b.start == this.top) {
                    this.top = temp.start;
                }
                this.array[temp.start] = temp;
                this.array[b.start] = null;
                this.removeFromFreed(prev);
                this.removeFromFreed(b);
                if (this.top > temp.start) {
                    this.addToFreed(temp);
                }
                b = temp;
            }
            if ((next = this.findNext(b.start)) != null && !next.used) {
                temp = next.join(b);
                if (temp != null) {
                    if (next.start == this.top) {
                        this.top = temp.start;
                    }
                    this.array[temp.start] = temp;
                    this.array[next.start] = null;
                    this.removeFromFreed(next);
                    this.removeFromFreed(b);
                }
                if (this.top > temp.start) {
                    this.addToFreed(temp);
                }
            }
        }
    }

    public List getAllocatedBlocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (int i = 0; i < this.array.length; ++i) {
            Block b = this.array[i];
            if (b == null || !b.used) continue;
            result.add(b);
        }
        return result;
    }

    private Block findAvailable(int n) {
        Set set = (Set)this.freed.get(new Integer(n));
        if (set != null) {
            return (Block)set.iterator().next();
        }
        Iterator iter = this.freed.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if ((Integer)entry.getKey() < n || (set = (Set)entry.getValue()) == null) continue;
            return (Block)set.iterator().next();
        }
        if (this.top + n > this.size || this.array[this.top].used) {
            return null;
        }
        return this.array[this.top];
    }

    private void addToFreed(Block b) {
        Integer key = new Integer(b.size);
        HashSet<Block> set = (HashSet<Block>)this.freed.get(key);
        if (set == null) {
            set = new HashSet<Block>();
            this.freed.put(key, set);
        }
        set.add(b);
    }

    private void removeFromFreed(Block b) {
        Integer key = new Integer(b.size);
        Set set = (Set)this.freed.get(key);
        if (set != null) {
            set.remove(b);
            if (set.isEmpty()) {
                this.freed.remove(key);
            }
        }
    }

    private Block findPrevious(int address) {
        for (int i = address - 1; i >= this.pos; --i) {
            if (this.array[i] == null) continue;
            return this.array[i];
        }
        return null;
    }

    private Block findNext(int address) {
        Block temp = this.array[address];
        if (temp != null) {
            return this.array[temp.start + temp.size];
        }
        for (int i = address + 1; i <= this.top; ++i) {
            if (this.array[i] == null) continue;
            return this.array[i];
        }
        return null;
    }

    private Block reserve(int address, int size, Block availBlock, Block prevBlock) {
        if (availBlock == null) {
            Block block = availBlock = prevBlock == null ? this.findPrevious(address) : prevBlock;
        }
        if (availBlock.start < address) {
            availBlock = this.split(availBlock, address - availBlock.start, false)[1];
        }
        return this.split(availBlock, size, true)[0];
    }

    private Block[] split(Block availBlock, int n, boolean used) {
        Block[] result = availBlock.split(n);
        Block newB = result[0];
        Block leftOver = result[1];
        newB.used = used;
        this.removeFromFreed(availBlock);
        if (!used) {
            this.addToFreed(newB);
        }
        this.array[newB.start] = newB;
        if (leftOver != null) {
            this.array[leftOver.start] = leftOver;
            if (this.top > leftOver.start) {
                this.addToFreed(leftOver);
            } else {
                this.top = leftOver.start;
            }
        }
        return result;
    }

    public void debug() {
        System.err.println(this.getClass().getName() + ":\n\nArray:");
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != null) {
                System.err.println(String.valueOf(i) + ": " + this.array[i]);
            }
            System.err.println("\nFree sets:");
            Iterator iter = this.freed.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                System.err.print(entry.getKey().toString() + ": [ ");
                Iterator iter2 = ((Set)entry.getValue()).iterator();
                while (iter2.hasNext()) {
                    System.err.print(iter2.next().toString() + ", ");
                }
                System.err.println("]");
            }
        }
    }

    private static class Block
    implements BlockAllocator.Block {
        protected final int start;
        protected final int size;
        protected boolean used = false;

        public Block(int start, int size) {
            this.start = start;
            this.size = size;
        }

        public int getAddress() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }

        public boolean adjoins(Block b) {
            return this.start < b.start && this.start + this.size >= b.start || this.start > b.start && b.start + b.size >= this.start;
        }

        public Block join(Block b) {
            if (this.adjoins(b)) {
                int newStart = Math.min(this.start, b.start);
                int newSize = Math.max(this.start + this.size, b.start + b.size) - newStart;
                return new Block(newStart, newSize);
            }
            return null;
        }

        public Block[] split(int len) {
            Block[] result = new Block[2];
            if (len < this.size) {
                result[0] = new Block(this.start, len);
                result[1] = new Block(this.start + len, this.size - len);
            } else if (len == this.size) {
                result[0] = this;
            }
            return result;
        }

        public String toString() {
            return "Block( start = " + this.start + "; size = " + this.size + "; used = " + this.used + " )";
        }
    }

    public static class Factory
    implements BlockAllocator.Factory {
        public BlockAllocator create(int size) {
            return new ContiguousBlockAllocator(size);
        }

        public BlockAllocator create(int size, int pos) {
            return new ContiguousBlockAllocator(size, pos);
        }
    }
}

