/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.ControlDesc;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.UGen;
import de.sciss.jcollider.UGenChannel;
import de.sciss.jcollider.UGenInput;

public class Control
extends UGen {
    protected final ControlDesc[] descs;

    private Control(String[] names, Object rate, float[] values) {
        this("Control", rate, values.length, new UGenInput[0], 0);
        for (int i = 0; i < values.length; ++i) {
            this.descs[i] = new ControlDesc(names[i], rate, values[i], 0.0f);
        }
    }

    private Control(String name, Object rate, float[] values) {
        this("Control", rate, values.length, new UGenInput[0], 0);
        this.descs[0] = new ControlDesc(name, rate, values[0], 0.0f);
        for (int i = 1; i < values.length; ++i) {
            this.descs[i] = new ControlDesc(null, rate, values[i], 0.0f);
        }
    }

    protected Control(String name, Object rate, int numOutputs, UGenInput[] inputs, int specialIndex) {
        super(name, rate, Control.createOutputRates(numOutputs, rate), inputs, specialIndex);
        this.descs = new ControlDesc[numOutputs];
    }

    public UGenChannel getChannel(String name) {
        for (int i = 0; i < this.descs.length; ++i) {
            if (!this.descs[i].getName().equals(name)) continue;
            return this.getChannel(i);
        }
        return null;
    }

    public ControlDesc getDesc(int idx) {
        return this.descs[idx];
    }

    public int getNumDescs() {
        return this.getNumOutputs();
    }

    private static Object[] createOutputRates(int numOutputs, Object rate) {
        Object[] rates = new Object[numOutputs];
        for (int i = 0; i < numOutputs; ++i) {
            rates[i] = rate;
        }
        return rates;
    }

    public static GraphElem ir(String name) {
        return Control.ir(name, 0.0f);
    }

    public static Control ir(String name, float defaultValue) {
        return new Control(name, kScalarRate, new float[]{defaultValue});
    }

    public static Control ir(String[] names, float[] values) {
        return new Control(names, kScalarRate, values);
    }

    public static Control ir(String name, float[] values) {
        return new Control(name, kScalarRate, values);
    }

    public static GraphElem kr(String name) {
        return Control.kr(name, 0.0f);
    }

    public static Control kr(String name, float defaultValue) {
        return new Control(name, kControlRate, new float[]{defaultValue});
    }

    public static Control kr(String[] names, float[] values) {
        return new Control(names, kControlRate, values);
    }

    public static Control kr(String name, float[] values) {
        return new Control(name, kControlRate, values);
    }
}

