/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.BasicEvent;
import java.awt.EventQueue;
import java.util.ArrayList;

public class EventManager
implements Runnable {
    public static final boolean DEBUG_EVENTS = false;
    private final ArrayList collListeners = new ArrayList();
    private final ArrayList collQueue = new ArrayList();
    private boolean paused = false;
    protected Processor eventProcessor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EventManager(Processor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    protected EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.collListeners.clear();
            this.collQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object listener) {
        if (listener != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(listener, true));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        if (listener != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(listener, false));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.paused) {
                return;
            }
        }
        for (int eventsInCycle = this.collQueue.size(); eventsInCycle > 0; --eventsInCycle) {
            Object o;
            eventManager = this;
            synchronized (eventManager) {
                o = this.collQueue.remove(0);
            }
            if (o instanceof BasicEvent) {
                this.eventProcessor.processEvent((BasicEvent)o);
                continue;
            }
            if (o instanceof PostponedAction) {
                if (((PostponedAction)o).state) {
                    if (this.collListeners.contains(((PostponedAction)o).listener)) continue;
                    this.collListeners.add(((PostponedAction)o).listener);
                    continue;
                }
                this.collListeners.remove(((PostponedAction)o).listener);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)o.getClass().getName());
            }
        }
    }

    public Object getListener(int index) {
        return this.collListeners.get(index);
    }

    public int countListeners() {
        return this.collListeners.size();
    }

    public void debugDump() {
        for (int i = 0; i < this.collListeners.size(); ++i) {
            System.err.println("listen " + i + " = " + this.collListeners.get(i).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(BasicEvent e) {
        boolean invoke;
        EventManager eventManager = this;
        synchronized (eventManager) {
            Object o;
            invoke = !this.paused;
            int i = this.collQueue.size() - 1;
            if (i >= 0 && (o = this.collQueue.get(i)) instanceof BasicEvent && e.incorporate((BasicEvent)o)) {
                this.collQueue.set(i, e);
            } else {
                this.collQueue.add(e);
            }
        }
        if (invoke) {
            EventQueue.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean invoke;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = false;
            invoke = !this.collQueue.isEmpty();
        }
        if (invoke) {
            EventQueue.invokeLater(this);
        }
    }

    static {
        $assertionsDisabled = !EventManager.class.desiredAssertionStatus();
    }

    private class PostponedAction {
        private final Object listener;
        private final boolean state;

        private PostponedAction(Object listener, boolean state) {
            this.listener = listener;
            this.state = state;
        }
    }

    public static interface Processor {
        public void processEvent(BasicEvent var1);
    }
}

