/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.UGenInput;

public class GraphElemArray
implements GraphElem {
    private final GraphElem[] elements;

    public GraphElemArray(GraphElem[] elements) {
        this.elements = elements;
    }

    public static GraphElemArray asArray(GraphElem g) {
        if (g instanceof GraphElemArray) {
            return (GraphElemArray)g;
        }
        return new GraphElemArray(new GraphElem[]{g});
    }

    public GraphElem getElement(int idx) {
        return this.elements[idx];
    }

    public int getNumElements() {
        return this.elements.length;
    }

    public int getNumOutputs() {
        return this.elements.length;
    }

    public GraphElem getOutput(int idx) {
        return this.elements[idx];
    }

    public UGenInput[] asUGenInputs() {
        switch (this.getNumOutputs()) {
            case 0: {
                return new UGenInput[0];
            }
            case 1: {
                return this.getOutput(0).asUGenInputs();
            }
        }
        UGenInput[][] result = new UGenInput[this.getNumOutputs()][];
        for (int i = 0; i < this.getNumOutputs(); ++i) {
            result[i] = this.getOutput(i).asUGenInputs();
        }
        return GraphElemArray.flatten(result);
    }

    public static UGenInput[] flatten(UGenInput[][] ins) {
        int numCh = 0;
        for (int i = 0; i < ins.length; ++i) {
            numCh += ins[i].length;
        }
        UGenInput[] flat = new UGenInput[numCh];
        int j = 0;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i], 0, flat, j, ins[i].length);
            j += ins[i].length;
        }
        return flat;
    }
}

