/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Node;
import de.sciss.jcollider.Server;
import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;

public class Group
extends Node {
    private Node headNode = null;
    private Node tailNode = null;

    public Group(Group target) throws IOException {
        this(target, 0);
    }

    public Group(Node target, int addAction) throws IOException {
        super(target.getServer());
        this.getServer().sendMsg(this.newMsg(target, addAction));
    }

    private Group(Server server, int nodeID) {
        super(server, nodeID);
    }

    public Node getHeadNode() {
        return this.headNode;
    }

    public Node getTailNode() {
        return this.tailNode;
    }

    protected void setHeadNode(Node headNode) {
        this.headNode = headNode;
    }

    protected void setTailNode(Node tailNode) {
        this.tailNode = tailNode;
    }

    public OSCMessage newMsg() {
        return this.newMsg(null);
    }

    public OSCMessage newMsg(Group target) {
        return this.newMsg(target, 0);
    }

    public OSCMessage newMsg(Node target, int addAction) {
        if (target == null) {
            target = this.getServer().getDefaultGroup();
        }
        return new OSCMessage("/g_new", new Object[]{new Integer(this.getNodeID()), new Integer(addAction), new Integer(target.getNodeID())});
    }

    public static Group basicNew(Server server) {
        return Group.basicNew(server, server.nextNodeID());
    }

    public static Group basicNew(Server server, int nodeID) {
        return new Group(server, nodeID);
    }

    public static Group after(Node aNode) throws IOException {
        return new Group(aNode, 3);
    }

    public static Group before(Node aNode) throws IOException {
        return new Group(aNode, 2);
    }

    public static Group head(Group aGroup) throws IOException {
        return new Group(aGroup, 0);
    }

    public static Group tail(Group aGroup) throws IOException {
        return new Group(aGroup, 1);
    }

    public static Group replace(Node nodeToReplace) throws IOException {
        return new Group(nodeToReplace, 4);
    }

    public OSCMessage addToHeadMsg(Group aGroup) {
        return this.newMsg(aGroup, 0);
    }

    public OSCMessage addToTailMsg(Group aGroup) {
        return this.newMsg(aGroup, 1);
    }

    public OSCMessage addAfterMsg(Node aNode) {
        return this.newMsg(aNode, 3);
    }

    public OSCMessage addBeforeMsg(Node aNode) {
        return this.newMsg(aNode, 2);
    }

    public OSCMessage addReplaceMsg(Node aNode) {
        return this.newMsg(aNode, 4);
    }

    public void moveNodeToHead(Node aNode) throws IOException {
        this.getServer().sendMsg(this.moveNodeToHeadMsg(aNode));
    }

    public void moveNodeToTail(Node aNode) throws IOException {
        this.getServer().sendMsg(this.moveNodeToTailMsg(aNode));
    }

    public OSCMessage moveNodeToHeadMsg(Node aNode) {
        return new OSCMessage("/g_head", new Object[]{new Integer(this.getNodeID()), new Integer(aNode.getNodeID())});
    }

    public OSCMessage moveNodeToTailMsg(Node aNode) {
        return new OSCMessage("/g_tail", new Object[]{new Integer(this.getNodeID()), new Integer(aNode.getNodeID())});
    }

    public void freeAll() throws IOException {
        this.getServer().sendMsg(this.freeAllMsg());
    }

    public OSCMessage freeAllMsg() {
        return new OSCMessage("/g_freeAll", new Object[]{new Integer(this.getNodeID())});
    }

    public void deepFree() throws IOException {
        this.getServer().sendMsg(this.deepFreeMsg());
    }

    public OSCMessage deepFreeMsg() {
        return new OSCMessage("/g_deepFree", new Object[]{new Integer(this.getNodeID())});
    }

    public String toString() {
        if (this.getName() == null) {
            return "Group(" + this.getNodeID() + ")";
        }
        return "Group::" + this.getName() + "(" + this.getNodeID() + ")";
    }

    public TreeNode getChildAt(int childIndex) {
        Enumeration children = this.children();
        for (int idx = 0; idx < childIndex; ++idx) {
            children.nextElement();
        }
        return (TreeNode)children.nextElement();
    }

    public int getChildCount() {
        int idx = 0;
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            ++idx;
            children.nextElement();
        }
        return idx;
    }

    public int getIndex(TreeNode node) {
        Enumeration children = this.children();
        int idx = 0;
        while (children.hasMoreElements()) {
            if (children.nextElement().equals(node)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new ChildEnumeration(this);
    }

    private static class ChildEnumeration
    implements Enumeration {
        private Node nextElement;

        protected ChildEnumeration(Group g) {
            this.nextElement = g.getHeadNode();
        }

        public boolean hasMoreElements() {
            return this.nextElement != null;
        }

        public Object nextElement() {
            Node result = this.nextElement;
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.nextElement.getSuccNode();
            return result;
        }
    }
}

