/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.UGenInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class JCollider {
    private static final double VERSION = 0.35;
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("JColliderStrings");
    public static final boolean isMacOS = System.getProperty("os.name").indexOf("Mac OS") >= 0;
    public static final boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;

    public static void main(String[] args) {
        String demoClass;
        if (args.length == 1) {
            if (args[0].equals("--test1")) {
                demoClass = "de.sciss.jcollider.test.Demo";
            } else if (args[0].equals("--test2")) {
                demoClass = "de.sciss.jcollider.test.MotoRevCtrl";
            } else if (args[0].equals("--bindefs")) {
                try {
                    UGenInfo.readDefinitions();
                    UGenInfo.writeBinaryDefinitions(new File("ugendefs.bin"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                demoClass = null;
                System.exit(0);
            } else {
                demoClass = null;
            }
        } else {
            demoClass = null;
        }
        if (demoClass != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Class<?> c = Class.forName(demoClass);
                        c.newInstance();
                    }
                    catch (Exception e1) {
                        System.err.println(e1);
                        System.exit(1);
                    }
                }
            });
        } else {
            System.err.println("\nJCollider v0.35\n" + JCollider.getCopyrightString() + "\n\n" + JCollider.getCreditsString() + "\n\n  " + JCollider.getResourceString("errIsALibrary"));
            System.out.println("\nThe following options are available:\n--test1    SynthDef demo\n--test2    MotoRev Control Demo\n--bindefs  Create Binary UGen Definitions\n");
            System.exit(1);
        }
    }

    public static final double getVersion() {
        return 0.35;
    }

    public static final String getCopyrightString() {
        return JCollider.getResourceString("copyright");
    }

    public static final String getCreditsString() {
        return JCollider.getResourceString("credits");
    }

    public static final String getResourceString(String key) {
        try {
            return resBundle.getString(key);
        }
        catch (MissingResourceException e1) {
            return "[Missing Resource: " + key + "]";
        }
    }

    public static void setDeepFont(Container c, Font fnt) {
        Component[] comp = c.getComponents();
        c.setFont(fnt);
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i] instanceof Container) {
                JCollider.setDeepFont((Container)comp[i], fnt);
                continue;
            }
            comp[i].setFont(fnt);
        }
    }

    public static void displayError(Component component, Exception exception, String title) {
        String message = exception.getLocalizedMessage();
        StringBuffer strBuf = new StringBuffer(JCollider.getResourceString("errException"));
        int lineLen = 0;
        Object[] options = new String[]{JCollider.getResourceString("buttonOk"), JCollider.getResourceString("optionDlgStack")};
        if (message == null) {
            message = exception.getClass().getName();
        }
        StringTokenizer tok = new StringTokenizer(message);
        strBuf.append(":\n");
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (lineLen > 0 && lineLen + word.length() > 40) {
                strBuf.append("\n");
                lineLen = 0;
            }
            strBuf.append(word);
            strBuf.append(' ');
            lineLen += word.length() + 1;
        }
        if (JOptionPane.showOptionDialog(component, strBuf.toString(), title, 0, 0, null, options, options[0]) == 1) {
            exception.printStackTrace();
        }
    }
}

