/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Constant;
import de.sciss.jcollider.Control;
import de.sciss.jcollider.ControlDesc;
import de.sciss.jcollider.UGenInput;

public class LagControl
extends Control {
    private LagControl(String[] names, Object rate, float[] values, Constant[] lags) {
        super("LagControl", rate, names.length, (UGenInput[])lags, 0);
        if (names.length != values.length || values.length != lags.length) {
            throw new IllegalArgumentException("LagControl: # of names / values / lags must be equal");
        }
        for (int i = 0; i < names.length; ++i) {
            this.descs[i] = new ControlDesc(names[i], rate, values[i], lags[i].getValue());
        }
    }

    private static Constant[] createLagInputs(float[] lags) {
        Constant[] ins = new Constant[lags.length];
        for (int i = 0; i < ins.length; ++i) {
            ins[i] = new Constant(lags[i]);
        }
        return ins;
    }

    public static Control kr(String name, float defaultValue, float lag) {
        return new LagControl(new String[]{name}, kControlRate, new float[]{defaultValue}, new Constant[]{new Constant(lag)});
    }

    public static Control kr(String[] names, float[] values, float[] lags) {
        return new LagControl(names, kControlRate, values, LagControl.createLagInputs(lags));
    }
}

