/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Bus;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.NodeWatcher;
import de.sciss.jcollider.Server;
import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.tree.TreeNode;

public abstract class Node
implements Constants,
TreeNode {
    private final Server server;
    private final int nodeID;
    private String name = null;
    private Group group = null;
    private Node predNode = null;
    private Node succNode = null;
    private boolean isPlaying = false;
    private boolean isRunning = false;

    protected Node(Server server, int nodeID) {
        this.server = server;
        this.nodeID = nodeID;
    }

    protected Node(Server server) {
        this(server, server.nextNodeID());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Group getGroup() {
        return this.group;
    }

    public Node getPredNode() {
        return this.predNode;
    }

    public Node getSuccNode() {
        return this.succNode;
    }

    public Server getServer() {
        return this.server;
    }

    protected void setGroup(Group group) {
        this.group = group;
    }

    protected void setPredNode(Node predNode) {
        this.predNode = predNode;
    }

    protected void setSuccNode(Node succNode) {
        this.succNode = succNode;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    protected void setPlaying(boolean isPlaying) {
        this.isPlaying = isPlaying;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            return node.getNodeID() == this.getNodeID() && node.getServer() == this.getServer();
        }
        return false;
    }

    public int hashCode() {
        return this.getServer().hashCode() ^ this.getNodeID();
    }

    public void free() throws IOException {
        this.getServer().sendMsg(this.freeMsg());
    }

    public OSCMessage freeMsg() {
        return new OSCMessage("/n_free", new Object[]{new Integer(this.getNodeID())});
    }

    public void run() throws IOException {
        this.run(true);
    }

    public void run(boolean flag) throws IOException {
        this.getServer().sendMsg(this.runMsg(flag));
    }

    public OSCMessage runMsg() {
        return this.runMsg(true);
    }

    public OSCMessage runMsg(boolean flag) {
        return new OSCMessage("/n_run", new Object[]{new Integer(this.getNodeID()), new Integer(flag ? 1 : 0)});
    }

    public void set(String ctrlName, float value) throws IOException {
        this.getServer().sendMsg(this.setMsg(ctrlName, value));
    }

    public OSCMessage setMsg(String ctrlName, float value) {
        return new OSCMessage("/n_set", new Object[]{new Integer(this.getNodeID()), ctrlName, new Float(value)});
    }

    public void set(int ctrlIdx, float value) throws IOException {
        this.getServer().sendMsg(this.setMsg(ctrlIdx, value));
    }

    public OSCMessage setMsg(int ctrlIdx, float value) {
        return new OSCMessage("/n_set", new Object[]{new Integer(this.getNodeID()), new Integer(ctrlIdx), new Float(value)});
    }

    public void set(String[] ctrlNames, float[] values) throws IOException {
        this.getServer().sendMsg(this.setMsg(ctrlNames, values));
    }

    public OSCMessage setMsg(String[] ctrlNames, float[] values) {
        Object[] args = new Object[(ctrlNames.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Float(values[i]);
        }
        return new OSCMessage("/n_set", args);
    }

    public void set(int[] ctrlIndices, float[] values) throws IOException {
        this.getServer().sendMsg(this.setMsg(ctrlIndices, values));
    }

    public OSCMessage setMsg(int[] ctrlIndices, float[] values) {
        Object[] args = new Object[(ctrlIndices.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Float(values[i]);
        }
        return new OSCMessage("/n_set", args);
    }

    public void fill(String[] ctrlNames, int[] numControls, float[] values) throws IOException {
        this.getServer().sendMsg(this.fillMsg(ctrlNames, numControls, values));
    }

    public OSCMessage fillMsg(String[] ctrlNames, int[] numControls, float[] values) {
        Object[] args = new Object[ctrlNames.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Integer(numControls[i]);
            args[j++] = new Float(values[i]);
        }
        return new OSCMessage("/n_fill", args);
    }

    public void fill(int[] ctrlIndices, int[] numControls, float[] values) throws IOException {
        this.getServer().sendMsg(this.fillMsg(ctrlIndices, numControls, values));
    }

    public OSCMessage fillMsg(int[] ctrlIndices, int[] numControls, float[] values) {
        Object[] args = new Object[ctrlIndices.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Integer(numControls[i]);
            args[j++] = new Float(values[i]);
        }
        return new OSCMessage("/n_fill", args);
    }

    public void setn(String[] ctrlNames, float[][] values) throws IOException {
        this.getServer().sendMsg(this.setnMsg(ctrlNames, values));
    }

    public OSCMessage setnMsg(String[] ctrlNames, float[][] values) {
        int i;
        int numArgs = 1;
        for (i = 0; i < ctrlNames.length; ++i) {
            numArgs += values[i].length + 2;
        }
        Object[] args = new Object[numArgs];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            float[] subV = values[i];
            args[j++] = new Integer(subV.length);
            for (int k = 0; k < subV.length; ++k) {
                args[j++] = new Float(subV[k]);
            }
        }
        return new OSCMessage("/n_setn", args);
    }

    public void setn(int[] ctrlIndices, float[][] values) throws IOException {
        this.getServer().sendMsg(this.setnMsg(ctrlIndices, values));
    }

    public OSCMessage setnMsg(int[] ctrlIndices, float[][] values) {
        int i;
        int numArgs = 1;
        for (i = 0; i < ctrlIndices.length; ++i) {
            numArgs += values[i].length + 2;
        }
        Object[] args = new Object[numArgs];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            float[] subV = values[i];
            args[j++] = new Integer(subV.length);
            for (int k = 0; k < subV.length; ++k) {
                args[j++] = new Float(subV[k]);
            }
        }
        return new OSCMessage("/n_setn", args);
    }

    public void map(int[] ctrlIndices, int[] busIndices) throws IOException {
        this.getServer().sendMsg(this.mapMsg(ctrlIndices, busIndices));
    }

    public OSCMessage mapMsg(int[] ctrlIndices, int[] busIndices) {
        Object[] args = new Object[(ctrlIndices.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Integer(busIndices[i]);
        }
        return new OSCMessage("/n_map", args);
    }

    public void map(String[] ctrlNames, int[] busIndices) throws IOException {
        this.getServer().sendMsg(this.mapMsg(ctrlNames, busIndices));
    }

    public OSCMessage mapMsg(String[] ctrlNames, int[] busIndices) {
        Object[] args = new Object[(ctrlNames.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Integer(busIndices[i]);
        }
        return new OSCMessage("/n_map", args);
    }

    public void map(int[] ctrlIndices, Bus[] busses) throws IOException {
        this.getServer().sendMsg(this.mapMsg(ctrlIndices, busses));
    }

    public OSCMessage mapMsg(int[] ctrlIndices, Bus[] busses) {
        Object[] args = new Object[(ctrlIndices.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Integer(busses[i] == null ? -1 : busses[i].getIndex());
        }
        return new OSCMessage("/n_map", args);
    }

    public void map(String[] ctrlNames, Bus[] busses) throws IOException {
        this.getServer().sendMsg(this.mapMsg(ctrlNames, busses));
    }

    public OSCMessage mapMsg(String[] ctrlNames, Bus[] busses) {
        Object[] args = new Object[(ctrlNames.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Integer(busses[i] == null ? -1 : busses[i].getIndex());
        }
        return new OSCMessage("/n_map", args);
    }

    public void mapn(int[] ctrlIndices, int[] busIndices, int[] numControls) throws IOException {
        this.getServer().sendMsg(this.mapnMsg(ctrlIndices, busIndices, numControls));
    }

    public OSCMessage mapnMsg(int[] ctrlIndices, int[] busIndices, int[] numControls) {
        Object[] args = new Object[ctrlIndices.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Integer(busIndices[i]);
            args[j++] = new Integer(numControls[i]);
        }
        return new OSCMessage("/n_mapn", args);
    }

    public void mapn(String[] ctrlNames, int[] busIndices, int[] numControls) throws IOException {
        this.getServer().sendMsg(this.mapnMsg(ctrlNames, busIndices, numControls));
    }

    public OSCMessage mapnMsg(String[] ctrlNames, int[] busIndices, int[] numControls) {
        Object[] args = new Object[ctrlNames.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Integer(busIndices[i]);
            args[j++] = new Integer(numControls[i]);
        }
        return new OSCMessage("/n_mapn", args);
    }

    public void mapn(int[] ctrlIndices, Bus[] busses) throws IOException {
        this.getServer().sendMsg(this.mapnMsg(ctrlIndices, busses));
    }

    public OSCMessage mapnMsg(int[] ctrlIndices, Bus[] busses) {
        Object[] args = new Object[ctrlIndices.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlIndices.length; ++i) {
            args[j++] = new Integer(ctrlIndices[i]);
            args[j++] = new Integer(busses[i].getIndex());
            args[j++] = new Integer(busses[i].getNumChannels());
        }
        return new OSCMessage("/n_mapn", args);
    }

    public void mapn(String[] ctrlNames, Bus[] busses) throws IOException {
        this.getServer().sendMsg(this.mapnMsg(ctrlNames, busses));
    }

    public OSCMessage mapnMsg(String[] ctrlNames, Bus[] busses) {
        Object[] args = new Object[ctrlNames.length * 3 + 1];
        args[0] = new Integer(this.getNodeID());
        int j = 1;
        for (int i = 0; i < ctrlNames.length; ++i) {
            args[j++] = ctrlNames[i];
            args[j++] = new Integer(busses[i].getIndex());
            args[j++] = new Integer(busses[i].getNumChannels());
        }
        return new OSCMessage("/n_mapn", args);
    }

    public void release() throws IOException {
        this.getServer().sendMsg(this.releaseMsg());
    }

    public void release(float releaseTime) throws IOException {
        this.getServer().sendMsg(this.releaseMsg(releaseTime));
    }

    public OSCMessage releaseMsg() {
        return this.releaseMsg(0.0f);
    }

    public OSCMessage releaseMsg(float releaseTime) {
        return new OSCMessage("/n_set", new Object[]{new Integer(this.getNodeID()), "gate", new Float(releaseTime == 0.0f ? releaseTime : -1.0f - releaseTime)});
    }

    public void trace() throws IOException {
        this.getServer().sendMsg(this.traceMsg());
    }

    public OSCMessage traceMsg() {
        return new OSCMessage("/n_trace", new Object[]{new Integer(this.getNodeID())});
    }

    public void query() throws IOException {
        this.query(Server.getPrintStream());
    }

    public void query(PrintStream out) throws IOException {
        Integer nodeIDArg = new Integer(this.getNodeID());
        OSCMessage reply = this.getServer().sendMsgSync(this.queryMsg(), "/n_info", null, 0, nodeIDArg, 4.0f);
        if (reply == null) {
            out.println("[ \"/n_query\", " + nodeIDArg + " ] -> timeout");
            return;
        }
        Object parent = reply.getArg(1);
        Object prev = reply.getArg(2);
        Object next = reply.getArg(3);
        boolean isGroup = ((Number)reply.getArg(4)).intValue() == 1;
        out.println((isGroup ? "Group   : " : "Synth   : ") + nodeIDArg + "\n  parent: " + parent + "\n  prev  : " + prev + "\n  next  : " + next);
        if (isGroup) {
            Object head = reply.getArg(5);
            Object tail = reply.getArg(6);
            out.println("  head  : " + head + "\n  tail  : " + tail);
        }
    }

    public OSCMessage queryMsg() {
        return new OSCMessage("/n_query", new Object[]{new Integer(this.getNodeID())});
    }

    public void register() throws IOException {
        this.register(false);
    }

    public void register(boolean assumePlaying) throws IOException {
        NodeWatcher watcher = NodeWatcher.newFrom(this.getServer());
        watcher.register(this, assumePlaying);
    }

    public void moveBefore(Node aNode) throws IOException {
        this.getServer().sendMsg(this.moveBeforeMsg(aNode));
    }

    public OSCMessage moveBeforeMsg(Node aNode) {
        return new OSCMessage("/n_before", new Object[]{new Integer(this.getNodeID()), new Integer(aNode.getNodeID())});
    }

    public void moveAfter(Node aNode) throws IOException {
        this.getServer().sendMsg(this.moveAfterMsg(aNode));
    }

    public OSCMessage moveAfterMsg(Node aNode) {
        return new OSCMessage("/n_after", new Object[]{new Integer(this.getNodeID()), new Integer(aNode.getNodeID())});
    }

    public void moveToHead(Group aGroup) throws IOException {
        (aGroup != null ? aGroup : this.getServer().getDefaultGroup()).moveNodeToHead(this);
    }

    public OSCMessage moveToHeadMsg(Group aGroup) {
        return (aGroup != null ? aGroup : this.getServer().getDefaultGroup()).moveNodeToHeadMsg(this);
    }

    public void moveToTail(Group aGroup) throws IOException {
        (aGroup != null ? aGroup : this.getServer().getDefaultGroup()).moveNodeToTail(this);
    }

    public OSCMessage moveToTailMsg(Group aGroup) {
        return (aGroup != null ? aGroup : this.getServer().getDefaultGroup()).moveNodeToTailMsg(this);
    }

    public void printOn(PrintStream stream) {
        stream.print(this.toString());
    }

    public TreeNode getParent() {
        return this.getGroup();
    }
}

