/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.app.BasicEvent;
import de.sciss.jcollider.Node;
import de.sciss.net.OSCMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeEvent
extends BasicEvent {
    public static final int GO = 0;
    public static final int END = 1;
    public static final int ON = 2;
    public static final int OFF = 3;
    public static final int MOVE = 4;
    public static final int INFO = 5;
    public static final int SYNTH = 0;
    public static final int GROUP = 1;
    public static final int UNKNOWN = -1;
    private final Node node;
    private final int nodeID;
    private final int nodeType;
    private final int parentID;
    private final int predID;
    private final int succID;
    private final int headID;
    private final int tailID;
    private final int oldParentID;
    private final int oldPredID;
    private final int oldSuccID;
    private static final List collValidCmds;

    protected NodeEvent(Object source, int ID, long when, Node node, int nodeID, int parentID, int predID, int succID, int nodeType, int headID, int tailID) {
        super(source, ID, when);
        this.node = node;
        this.nodeID = nodeID;
        this.nodeType = nodeType;
        this.parentID = parentID;
        this.predID = predID;
        this.succID = succID;
        this.headID = headID;
        this.tailID = tailID;
        if (node == null) {
            this.oldParentID = -1;
            this.oldPredID = -1;
            this.oldSuccID = -1;
        } else {
            this.oldParentID = node.getGroup() == null ? -1 : node.getGroup().getNodeID();
            this.oldPredID = node.getPredNode() == null ? -1 : node.getPredNode().getNodeID();
            this.oldSuccID = node.getSuccNode() == null ? -1 : node.getSuccNode().getNodeID();
        }
    }

    public static NodeEvent fromOSCMessage(OSCMessage msg, Object source, long when, Node node) {
        int eventID = collValidCmds.indexOf(msg.getName());
        if (eventID == -1) {
            throw new IllegalArgumentException("Not a valid node notification message : " + msg.getName());
        }
        int nodeID = ((Number)msg.getArg(0)).intValue();
        int parentID = ((Number)msg.getArg(1)).intValue();
        int predID = ((Number)msg.getArg(2)).intValue();
        int succID = ((Number)msg.getArg(3)).intValue();
        int nodeType = ((Number)msg.getArg(4)).intValue();
        int headID = nodeType == 1 ? ((Number)msg.getArg(5)).intValue() : -1;
        int tailID = nodeType == 1 ? ((Number)msg.getArg(6)).intValue() : -1;
        return new NodeEvent(source, eventID, when, node, nodeID, parentID, predID, succID, nodeType, headID, tailID);
    }

    public static NodeEvent fromOSCMessage(OSCMessage msg, Object source, long when) {
        return NodeEvent.fromOSCMessage(msg, source, when, null);
    }

    public static int getIDFromOSCMessage(OSCMessage msg) {
        return collValidCmds.indexOf(msg.getName());
    }

    public Node getNode() {
        return this.node;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getParentGroupID() {
        return this.parentID;
    }

    public int getOldParentGroupID() {
        return this.oldParentID;
    }

    public int getPredNodeID() {
        return this.predID;
    }

    public int getOldPredNodeID() {
        return this.oldPredID;
    }

    public int getOldSuccNodeID() {
        return this.oldSuccID;
    }

    public int getSuccNodeID() {
        return this.succID;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public int getHeadNodeID() {
        return this.headID;
    }

    public int getTailNodeID() {
        return this.tailID;
    }

    public static List getValidOSCCommands() {
        return collValidCmds;
    }

    public boolean incorporate(BasicEvent oldEvent) {
        return false;
    }

    static {
        ArrayList<String> coll = new ArrayList<String>(6);
        coll.add("/n_go");
        coll.add("/n_end");
        coll.add("/n_on");
        coll.add("/n_off");
        coll.add("/n_move");
        coll.add("/n_info");
        collValidCmds = Collections.unmodifiableList(coll);
    }
}

