/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

public class NodeIDAllocator {
    private final int user;
    private int mask;
    private int temp;
    private int perm;
    private static final int MASK_SHIFT = 26;
    private static final int USER_MAX = 63;
    private static final int TEMP_MIN = 1000;
    private static final int TEMP_MAX = 0x3FFFFFF;
    private static final int PERM_MIN = 2;
    private static final int PERM_MAX = 999;

    public NodeIDAllocator() {
        this(0);
    }

    public NodeIDAllocator(int user) {
        if (user > 63) {
            throw new IllegalArgumentException("NodeIDAllocator user ID > 63");
        }
        this.user = user;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NodeIDAllocator nodeIDAllocator = this;
        synchronized (nodeIDAllocator) {
            this.mask = this.user << 26;
            this.temp = 1000;
            this.perm = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int alloc() {
        NodeIDAllocator nodeIDAllocator = this;
        synchronized (nodeIDAllocator) {
            int result = this.temp | this.mask;
            if (++this.temp > 0x3FFFFFF) {
                this.temp = 1000;
                System.err.println("Warning: NodeIDAllocator exceeded maximum node ID!");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocPerm() {
        NodeIDAllocator nodeIDAllocator = this;
        synchronized (nodeIDAllocator) {
            int result = this.perm | this.mask;
            if (++this.perm > 999) {
                this.perm = 999;
                System.err.println("Warning: NodeIDAllocator exceeded maximum permanent node ID!\nAssigning temporary ID!");
                return this.alloc();
            }
            return result;
        }
    }

    public static int getUserMax() {
        return 63;
    }
}

