/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.NodeEvent;
import de.sciss.jcollider.NodeListener;
import de.sciss.jcollider.OSCResponderNode;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class NodeWatcher
implements EventManager.Processor,
OSCListener,
Constants,
Runnable {
    public boolean VERBOSE = false;
    private EventManager em = null;
    protected final Server server;
    private int dumpMode = 0;
    private boolean watching = false;
    private boolean fireAllNodes = false;
    private boolean autoRegister = false;
    private final Map mapNodes = new HashMap();
    private final OSCResponderNode[] resps;
    private final Object sync = new Object();
    private final List collQueue = new ArrayList();
    private static final Map allInstances;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NodeWatcher(Server s) {
        this.server = s;
        List collValidCmds = NodeEvent.getValidOSCCommands();
        this.resps = new OSCResponderNode[collValidCmds.size()];
        for (int i = 0; i < collValidCmds.size(); ++i) {
            this.resps[i] = new OSCResponderNode(this.server, (String)collValidCmds.get(i), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeWatcher newFrom(Server s) throws IOException {
        Map map = allInstances;
        synchronized (map) {
            NodeWatcher nw = (NodeWatcher)allInstances.get(s.getName());
            if (nw == null) {
                nw = new NodeWatcher(s);
                nw.start();
                allInstances.put(s.getName(), nw);
            }
            return nw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.server.isRunning() && !this.server.isNotified()) {
            Server.getPrintStream().println("NodeWatcher warning: server does not receive notifications");
        }
        Object object = this.sync;
        synchronized (object) {
            try {
                for (int i = 0; i < this.resps.length; ++i) {
                    this.resps[i].add();
                }
                this.watching = true;
                if (this.VERBOSE) {
                    System.err.println("NodeWatcher.start()");
                }
            }
            catch (IOException e1) {
                this.stop();
                throw e1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            this.watching = false;
            if (this.VERBOSE) {
                System.err.println("NodeWatcher.stop()");
            }
            for (int i = 0; i < this.resps.length; ++i) {
                this.resps[i].remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWatching() {
        Object object = this.sync;
        synchronized (object) {
            return this.watching;
        }
    }

    public void register(Node node) {
        this.register(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Node node, boolean assumePlaying) {
        Object object = this.sync;
        synchronized (object) {
            if (this.watching) {
                Integer key = new Integer(node.getNodeID());
                if (assumePlaying && this.mapNodes.containsKey(key)) {
                    node.setPlaying(true);
                }
                this.mapNodes.put(key, node);
                if (this.VERBOSE) {
                    System.err.println("NodeWatcher.register( " + node + " )");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Node node) {
        Object object = this.sync;
        synchronized (object) {
            this.mapNodes.remove(new Integer(node.getNodeID()));
            if (this.VERBOSE) {
                System.err.println("NodeWatcher.unregister( " + node + " )");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllNodes() {
        Object object = this.sync;
        synchronized (object) {
            return new ArrayList(this.mapNodes.values());
        }
    }

    public synchronized void addListener(NodeListener l) {
        if (this.em == null) {
            this.em = new EventManager(this);
        }
        this.em.addListener(l);
    }

    public void removeListener(NodeListener l) {
        if (this.em != null) {
            this.em.removeListener(l);
        }
    }

    public void queryAllNodes(float timeout, ActionListener doneAction) {
        this.setFireAllNodes(true);
        this.setAutoRegister(true);
        final HashSet setNodes = new HashSet();
        final Timer stopQueryTimer = new Timer((int)(timeout * 1000.0f), null);
        final NodeListener nl = new NodeListener(){

            public void nodeAction(NodeEvent e) {
                if (e.getID() != 5) {
                    return;
                }
                Node n = e.getNode();
                if (setNodes.add(n)) {
                    NodeWatcher.this.register(n);
                    ArrayList<Integer> nextNodes = new ArrayList<Integer>(2);
                    if (e.getHeadNodeID() != -1) {
                        nextNodes.add(new Integer(e.getHeadNodeID()));
                    }
                    if (e.getSuccNodeID() != -1) {
                        nextNodes.add(new Integer(e.getSuccNodeID()));
                    }
                    if (!nextNodes.isEmpty()) {
                        try {
                            NodeWatcher.this.server.sendMsg(new OSCMessage("/n_query", nextNodes.toArray()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                stopQueryTimer.restart();
            }
        };
        stopQueryTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeWatcher.this.removeListener(nl);
            }
        });
        if (doneAction != null) {
            stopQueryTimer.addActionListener(doneAction);
        }
        stopQueryTimer.setRepeats(false);
        stopQueryTimer.restart();
        this.addListener(nl);
        try {
            this.server.sendMsg(this.server.getDefaultGroup().queryMsg());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.mapNodes.clear();
            if (this.VERBOSE) {
                System.err.println("NodeWatcher.clear()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = allInstances;
        synchronized (map) {
            if (this.isWatching()) {
                try {
                    this.stop();
                }
                catch (IOException e1) {
                    System.err.println("NodeWatcher.dispose : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                }
            }
            if (this.em != null) {
                this.em.dispose();
            }
            this.clear();
            allInstances.remove(this.server.getName());
            if (this.VERBOSE) {
                System.err.println("NodeWatcher.dispose()");
            }
        }
    }

    public void dumpIncomingOSC(int dumpMode) {
        this.dumpMode = dumpMode;
    }

    public void setFireAllNodes(boolean allNodes) {
        this.fireAllNodes = allNodes;
    }

    public boolean getFireAllNodes() {
        return this.fireAllNodes;
    }

    public void setAutoRegister(boolean onOff) {
        this.autoRegister = onOff;
    }

    public boolean setAutoRegister() {
        return this.autoRegister;
    }

    private void nodeGo(Node node, NodeEvent e) {
        Group group = (Group)this.mapNodes.get(new Integer(e.getParentGroupID()));
        Node pred = (Node)this.mapNodes.get(new Integer(e.getPredNodeID()));
        Node succ = (Node)this.mapNodes.get(new Integer(e.getSuccNodeID()));
        node.setGroup(group);
        node.setPredNode(pred);
        node.setSuccNode(succ);
        if (pred != null) {
            pred.setSuccNode(node);
        }
        if (succ != null) {
            succ.setPredNode(node);
        }
        if (group != null) {
            if (e.getPredNodeID() == -1) {
                group.setHeadNode(node);
            }
            if (e.getSuccNodeID() == -1) {
                group.setTailNode(node);
            }
        }
        node.setRunning(true);
        node.setPlaying(true);
        if (this.VERBOSE) {
            System.err.println("NodeWatcher.nodeGo( " + node + " )");
        }
    }

    private void nodeEnd(Node node, NodeEvent e) {
        Group group = node.getGroup();
        Node pred = node.getPredNode();
        Node succ = node.getSuccNode();
        node.setGroup(null);
        node.setPredNode(null);
        node.setSuccNode(null);
        if (pred != null) {
            pred.setSuccNode(succ);
        }
        if (succ != null) {
            succ.setPredNode(pred);
        }
        if (group != null) {
            if (group.getHeadNode() != null && group.getHeadNode().getNodeID() == node.getNodeID()) {
                group.setHeadNode(succ);
            }
            if (group.getTailNode() != null && group.getTailNode().getNodeID() == node.getNodeID()) {
                group.setTailNode(pred);
            }
        }
        node.setPlaying(false);
        node.setRunning(false);
        this.mapNodes.remove(new Integer(node.getNodeID()));
        if (this.VERBOSE) {
            System.err.println("NodeWatcher.nodeEnd( " + node + " )");
        }
    }

    private void nodeMove(Node node, NodeEvent e) {
        Group oldGroup = node.getGroup();
        Node oldPred = node.getPredNode();
        Node oldSucc = node.getSuccNode();
        Group newGroup = (Group)this.mapNodes.get(new Integer(e.getParentGroupID()));
        Node newPred = (Node)this.mapNodes.get(new Integer(e.getPredNodeID()));
        Node newSucc = (Node)this.mapNodes.get(new Integer(e.getSuccNodeID()));
        node.setGroup(newGroup);
        node.setPredNode(newPred);
        node.setSuccNode(newSucc);
        if (oldPred != null) {
            oldPred.setSuccNode(oldSucc);
        }
        if (oldSucc != null) {
            oldSucc.setPredNode(oldPred);
        }
        if (newPred != null) {
            newPred.setSuccNode(node);
        }
        if (newSucc != null) {
            newSucc.setPredNode(node);
        }
        if (oldGroup != null) {
            if (oldGroup.getHeadNode() != null && oldGroup.getHeadNode().getNodeID() == node.getNodeID()) {
                oldGroup.setHeadNode(oldSucc);
            }
            if (oldGroup.getTailNode() != null && oldGroup.getTailNode().getNodeID() == node.getNodeID()) {
                oldGroup.setTailNode(oldPred);
            }
        }
        if (newGroup != null) {
            if (e.getPredNodeID() == -1) {
                newGroup.setHeadNode(node);
            }
            if (e.getSuccNodeID() == -1) {
                newGroup.setTailNode(node);
            }
        }
        if (this.VERBOSE) {
            System.err.println("NodeWatcher.nodeMove( " + node + " )");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(OSCMessage msg, SocketAddress addr, long time) {
        if (this.dumpMode == 1) {
            OSCPacket.printTextOn((PrintStream)Server.getPrintStream(), (OSCPacket)msg);
        }
        if (this.autoRegister) {
            Object object = this.sync;
            synchronized (object) {
                boolean invoke = this.collQueue.isEmpty();
                this.collQueue.add(msg);
                if (invoke) {
                    EventQueue.invokeLater(this);
                }
            }
            return;
        }
        Integer nodeIDObj = (Integer)msg.getArg(0);
        Object object = this.sync;
        synchronized (object) {
            if (this.mapNodes.containsKey(nodeIDObj)) {
                boolean invoke = this.collQueue.isEmpty();
                this.collQueue.add(msg);
                if (invoke) {
                    EventQueue.invokeLater(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.watching) {
                return;
            }
            long when = System.currentTimeMillis();
            Iterator iter = this.collQueue.iterator();
            while (iter.hasNext()) {
                OSCMessage msg = (OSCMessage)iter.next();
                Integer nodeIDObj = (Integer)msg.getArg(0);
                Node node = (Node)this.mapNodes.get(nodeIDObj);
                if (node == null) {
                    if (this.autoRegister) {
                        node = ((Number)msg.getArg(4)).intValue() == 1 ? Group.basicNew(this.server, nodeIDObj) : Synth.basicNew(null, this.server, nodeIDObj);
                        this.register(node);
                    } else if (!this.fireAllNodes) {
                        return;
                    }
                }
                NodeEvent nde = NodeEvent.fromOSCMessage(msg, this, when, node);
                if (node != null) {
                    switch (nde.getID()) {
                        case 0: {
                            this.nodeGo(node, nde);
                            break;
                        }
                        case 1: {
                            this.nodeEnd(node, nde);
                            break;
                        }
                        case 2: {
                            node.setPlaying(true);
                            break;
                        }
                        case 3: {
                            node.setPlaying(false);
                            break;
                        }
                        case 4: {
                            this.nodeMove(node, nde);
                            break;
                        }
                        case 5: {
                            this.nodeMove(node, nde);
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError(nde.getID());
                            }
                            break;
                        }
                    }
                }
                if (this.em == null) continue;
                for (int i = 0; i < this.em.countListeners(); ++i) {
                    NodeListener listener = (NodeListener)this.em.getListener(i);
                    try {
                        listener.nodeAction(nde);
                        continue;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            this.collQueue.clear();
        }
    }

    public void processEvent(BasicEvent e) {
    }

    static {
        $assertionsDisabled = !NodeWatcher.class.desiredAssertionStatus();
        allInstances = new HashMap();
    }
}

