/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.OSCResponderNode;
import de.sciss.jcollider.Server;
import de.sciss.net.OSCClient;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSCMultiResponder
implements OSCListener {
    private final List allNodes = new ArrayList();
    private final Map mapCmdToNodes = new HashMap();
    private static final boolean debug = false;
    private final OSCClient c;
    private OSCResponderNode[] resps = new OSCResponderNode[2];
    private final Object sync = new Object();

    protected OSCMultiResponder(OSCClient c) throws IOException {
        this.c = c;
        c.addOSCListener((OSCListener)this);
    }

    protected Object getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(OSCResponderNode node) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            this.allNodes.add(node);
            ArrayList<OSCResponderNode> specialNodes = (ArrayList<OSCResponderNode>)this.mapCmdToNodes.get(node.getCommandName());
            if (specialNodes == null) {
                specialNodes = new ArrayList<OSCResponderNode>(4);
                this.mapCmdToNodes.put(node.getCommandName(), specialNodes);
            }
            specialNodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(OSCResponderNode node) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            List specialNodes = (List)this.mapCmdToNodes.get(node.getCommandName());
            if (specialNodes != null) {
                specialNodes.remove(node);
                this.allNodes.remove(node);
                if (this.allNodes.isEmpty()) {
                    this.mapCmdToNodes.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.sync;
        synchronized (object) {
            this.c.removeOSCListener((OSCListener)this);
            this.allNodes.clear();
            this.mapCmdToNodes.clear();
            this.c.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
        int numResps;
        Object object = this.sync;
        synchronized (object) {
            List specialNodes = (List)this.mapCmdToNodes.get(msg.getName());
            if (specialNodes == null) {
                return;
            }
            numResps = specialNodes.size();
            this.resps = specialNodes.toArray(this.resps);
        }
        for (int i = 0; i < numResps; ++i) {
            try {
                this.resps[i].messageReceived(msg, sender, time);
            }
            catch (Exception e) {
                e.printStackTrace(Server.getPrintStream());
            }
            this.resps[i] = null;
        }
    }
}

