/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.OSCMultiResponder;
import de.sciss.jcollider.Server;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.net.SocketAddress;

public class OSCResponderNode
implements OSCListener {
    private final String cmdName;
    private final OSCListener action;
    private volatile boolean removeWhenDone = false;
    private volatile boolean listening = false;
    private final Object sync;
    private final OSCMultiResponder multi;

    public OSCResponderNode(Server s, String cmdName, OSCListener action) {
        this.cmdName = cmdName;
        this.action = action;
        this.multi = s.getMultiResponder();
        this.sync = this.multi.getSync();
    }

    public String getCommandName() {
        return this.cmdName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCResponderNode add() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (this.listening) {
                throw new IllegalStateException("OSCResponderNode.add() : duplicate call");
            }
            this.multi.addNode(this);
            this.listening = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.sync;
        synchronized (object) {
            return this.listening;
        }
    }

    public OSCResponderNode removeWhenDone() {
        this.removeWhenDone = true;
        return this;
    }

    public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
        if (this.listening) {
            try {
                this.action.messageReceived(msg, sender, time);
            }
            catch (Exception e1) {
                e1.printStackTrace(Server.getPrintStream());
            }
            if (this.removeWhenDone) {
                try {
                    this.remove();
                }
                catch (IOException e1) {
                    e1.printStackTrace(Server.getPrintStream());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCResponderNode remove() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            this.listening = false;
            this.multi.removeNode(this);
            return this;
        }
    }
}

