/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.BlockAllocator;
import java.util.ArrayList;
import java.util.List;

public class PowerOfTwoAllocator
implements BlockAllocator {
    private final int size;
    private int pos;
    private final Block[] allocatedBlocks;
    private final Block[] freeBlocks;

    public PowerOfTwoAllocator(int size) {
        this(size, 0);
    }

    public PowerOfTwoAllocator(int size, int pos) {
        this.size = size;
        this.pos = pos;
        this.allocatedBlocks = new Block[size];
        this.freeBlocks = new Block[32];
    }

    public int alloc(int n) {
        int result;
        int np2 = 1;
        int sizeClass = 0;
        while (np2 < n) {
            np2 <<= 1;
            ++sizeClass;
        }
        Block node = this.freeBlocks[sizeClass];
        if (node != null) {
            this.freeBlocks[sizeClass] = node.next;
            result = node.address;
        } else if (this.pos + np2 <= this.size) {
            this.allocatedBlocks[this.pos] = new Block(this.pos, np2, sizeClass);
            result = this.pos;
            this.pos += np2;
        } else {
            result = -1;
        }
        return result;
    }

    public void free(int address) {
        Block node = this.allocatedBlocks[address];
        if (node != null) {
            node.next = this.freeBlocks[node.sizeClass];
            this.freeBlocks[node.sizeClass] = node;
        }
    }

    public List getAllocatedBlocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (int i = 0; i < this.allocatedBlocks.length; ++i) {
            if (this.allocatedBlocks[i] == null) continue;
            result.add(this.allocatedBlocks[i]);
        }
        return result;
    }

    private static class Block
    implements BlockAllocator.Block {
        protected final int address;
        private final int size;
        protected final int sizeClass;
        protected Block next = null;

        protected Block(int address, int size, int sizeClass) {
            this.address = address;
            this.size = size;
            this.sizeClass = sizeClass;
        }

        public int getAddress() {
            return this.address;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class Factory
    implements BlockAllocator.Factory {
        public BlockAllocator create(int size) {
            return new PowerOfTwoAllocator(size);
        }

        public BlockAllocator create(int size, int pos) {
            return new PowerOfTwoAllocator(size, pos);
        }
    }
}

