/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.jcollider.BlockAllocator;
import de.sciss.jcollider.Buffer;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.NodeIDAllocator;
import de.sciss.jcollider.OSCMultiResponder;
import de.sciss.jcollider.OSCResponderNode;
import de.sciss.jcollider.ServerEvent;
import de.sciss.jcollider.ServerListener;
import de.sciss.jcollider.ServerOptions;
import de.sciss.jcollider.UniqueID;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCClient;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;

public class Server
implements Constants,
EventManager.Processor {
    public static final int DEFAULT_PORT = 57110;
    private static final Set setServers = Collections.synchronizedSet(new HashSet());
    private static final Map mapServerNames = Collections.synchronizedMap(new HashMap());
    private final String name;
    private final InetSocketAddress addr;
    private final ServerOptions options;
    private final int clientID;
    private final boolean isLocal;
    private volatile boolean serverRunning = false;
    protected volatile boolean serverBooting = false;
    private boolean notified = true;
    protected Buffer[] bufferArray;
    protected OSCResponderNode bufInfoResponder;
    protected boolean waitingForBufInfo;
    protected int waitingBufs;
    private NodeIDAllocator nodeAllocator;
    private BlockAllocator controlBusAllocator;
    private BlockAllocator audioBusAllocator;
    private BlockAllocator bufferAllocator;
    private static String program = "scsynth";
    private static boolean inform = true;
    protected static volatile PrintStream printStream = System.err;
    private StatusWatcher aliveThread = null;
    protected final OSCClient c;
    private final OSCMultiResponder multi;
    private int dumpMode = 0;
    private final Group defaultGroup;
    protected final Status status = new Status();
    private final EventManager em = new EventManager(this);
    private final List collBootCompletion = new ArrayList();
    protected BootThread bootThread = null;
    private static final OSCMessage statusMsg = new OSCMessage("/status");
    protected final Server enc_this = this;
    protected final Object syncBootThread = new Object();
    static /* synthetic */ Class class$de$sciss$jcollider$Server;

    public Server(String name, InetSocketAddress addr, ServerOptions options, int clientID) throws IOException {
        this.name = name;
        this.addr = addr;
        this.options = options;
        this.clientID = clientID;
        InetAddress host = addr.getAddress();
        if (host == null) {
            throw new IOException("Server.new : unresolved network address " + addr);
        }
        this.isLocal = host.isLoopbackAddress() || host.equals(InetAddress.getLocalHost());
        mapServerNames.put(name, this);
        setServers.add(this);
        this.defaultGroup = Group.basicNew(this, 0);
        try {
            this.c = OSCClient.newUsing((String)options.getProtocol(), (int)0, (boolean)host.isLoopbackAddress());
            this.c.setBufferSize(65536);
            this.multi = new OSCMultiResponder(this.c);
            this.c.setTarget((SocketAddress)addr);
            this.createNewAllocators();
            this.resetBufferAutoInfo();
        }
        catch (IOException e1) {
            mapServerNames.remove(name);
            setServers.remove(this);
            throw e1;
        }
    }

    public Server(String name, InetSocketAddress addr, ServerOptions options) throws IOException {
        this(name, addr, options, 0);
    }

    public Server(String name, InetSocketAddress addr) throws IOException {
        this(name, addr, new ServerOptions());
    }

    public Server(String name) throws IOException {
        this(name, new InetSocketAddress("127.0.0.1", 57110));
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    protected OSCMultiResponder getMultiResponder() {
        return this.multi;
    }

    public void start() throws IOException {
        this.c.start();
    }

    public String getName() {
        return this.name;
    }

    public ServerOptions getOptions() {
        return this.options;
    }

    public int getClientID() {
        return this.clientID;
    }

    public static String getProgram() {
        return program;
    }

    public static void setProgram(String program) {
        Server.program = program;
    }

    public static void setInform(boolean onOff) {
        inform = onOff;
    }

    public static void setPrintStream(PrintStream printStream) {
        Server.printStream = printStream;
    }

    public static PrintStream getPrintStream() {
        return printStream;
    }

    public boolean isBooting() {
        return this.serverBooting;
    }

    protected void setBooting(boolean serverBooting) {
        this.serverBooting = serverBooting;
    }

    public boolean isRunning() {
        return this.serverRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunning(boolean serverRunning) {
        Object object = this.syncBootThread;
        synchronized (object) {
            if (this.serverRunning != serverRunning) {
                this.serverRunning = serverRunning;
                if (!serverRunning) {
                    this.changed(1);
                    if (this.bootThread != null) {
                        try {
                            this.bootThread.keepScRunning = false;
                            this.syncBootThread.wait(4000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (!this.collBootCompletion.isEmpty()) {
                        ((CompletionAction)this.collBootCompletion.remove(0)).completion(this);
                    }
                    this.changed(0);
                }
            }
        }
    }

    private void createNewAllocators() {
        this.nodeAllocator = new NodeIDAllocator(this.getClientID());
        this.controlBusAllocator = this.options.getBlockAllocFactory().create(this.options.getNumControlBusChannels());
        this.audioBusAllocator = this.options.getBlockAllocFactory().create(this.options.getNumAudioBusChannels(), this.options.getFirstPrivateBus());
        this.bufferAllocator = this.options.getBlockAllocFactory().create(this.options.getNumBuffers());
    }

    protected BlockAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    protected BlockAllocator getAudioBusAllocator() {
        return this.audioBusAllocator;
    }

    protected BlockAllocator getControlBusAllocator() {
        return this.controlBusAllocator;
    }

    public double getSampleRate() {
        return this.status.sampleRate;
    }

    public Status getStatus() {
        return Status.copyFrom(this.status);
    }

    public int getDumpMode() {
        return this.dumpMode;
    }

    public Group getDefaultGroup() {
        return this.defaultGroup;
    }

    public Group asTarget() {
        return this.defaultGroup;
    }

    protected static void inform(String txt) {
        if (inform) {
            printStream.println(txt);
        }
    }

    public void boot() throws IOException {
        this.boot(true);
    }

    public void boot(boolean startAliveThread) throws IOException {
        if (this.isRunning()) {
            printStream.println("server already running");
            return;
        }
        if (this.isBooting()) {
            printStream.println("server already booting");
            return;
        }
        if (!this.isLocal) {
            throw new IllegalStateException("Server.boot() : only allowed for local servers!");
        }
        CompletionAction whenBooted = new CompletionAction(){

            public void completion(Server s) {
                try {
                    s.setBooting(false);
                    if (s.getDumpMode() != 0) {
                        s.dumpOSC(s.getDumpMode());
                    }
                    if (s.isNotified()) {
                        Server.inform("notification is on");
                        s.notify(true);
                    } else {
                        Server.inform("notification is off");
                    }
                    s.initTree();
                }
                catch (IOException e1) {
                    Server.printError("Server.boot", e1);
                }
            }
        };
        this.setBooting(true);
        try {
            this.createNewAllocators();
            this.resetBufferAutoInfo();
            this.addDoWhenBooted(whenBooted);
            this.bootServerApp(startAliveThread);
        }
        catch (IOException e1) {
            this.removeDoWhenBooted(whenBooted);
            try {
                this.stopAliveThread();
            }
            catch (IOException e2) {
                Server.printError("Server.boot", e2);
            }
            this.setBooting(false);
            throw e1;
        }
    }

    public void dumpOSC() throws IOException {
        this.dumpOSC(1);
    }

    public void dumpOSC(int dumpMode) throws IOException {
        this.sendMsg(this.dumpOSCMsg(dumpMode));
    }

    public OSCMessage dumpOSCMsg(int dumpMode) {
        this.dumpMode = dumpMode;
        return new OSCMessage("/dumpOSC", new Object[]{new Integer(dumpMode)});
    }

    public void dumpIncomingOSC(int dumpMode) {
        this.c.dumpIncomingOSC(dumpMode, printStream);
    }

    public void dumpOutgoingOSC(int dumpMode) {
        this.c.dumpOutgoingOSC(dumpMode, printStream);
    }

    public void notify(boolean notified) throws IOException {
        this.notified = notified;
        this.sendMsg(new OSCMessage("/notify", new Object[]{new Integer(notified ? 1 : 0)}));
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void initTree() throws IOException {
        this.nodeAllocator = new NodeIDAllocator(this.getClientID());
    }

    public void addDoWhenBooted(CompletionAction action) {
        this.collBootCompletion.add(action);
    }

    public void removeDoWhenBooted(CompletionAction action) {
        this.collBootCompletion.remove(action);
    }

    public void addListener(ServerListener l) {
        this.em.addListener(l);
    }

    public void removeListener(ServerListener l) {
        this.em.removeListener(l);
    }

    protected void changed(int id) {
        this.em.dispatchEvent(new ServerEvent(this, id, System.currentTimeMillis(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootServerApp(boolean startAliveThread) {
        int port = this.getAddr().getPort();
        List cmdList = this.getOptions().toOptionList(port);
        cmdList.add(0, program);
        String[] cmdArray = ServerOptions.optionListToStringArray(cmdList);
        Server.inform("Booting SuperCollider server at " + this.getOptions().getProtocol().toUpperCase() + " port " + port + " ...");
        Object object = this.syncBootThread;
        synchronized (object) {
            this.bootThread = new BootThread(this, cmdArray, startAliveThread);
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean didWeBootTheServer() {
        return this.bootThread != null;
    }

    public void startAliveThread() throws IOException {
        this.startAliveThread(2.0f, 0.7f, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAliveThread(float delay, float period, int deathBounces) throws IOException {
        Object object = this.syncBootThread;
        synchronized (object) {
            if (this.aliveThread == null) {
                this.aliveThread = new StatusWatcher(delay, period, deathBounces);
                this.aliveThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAliveThread() throws IOException {
        Object object = this.syncBootThread;
        synchronized (object) {
            if (this.aliveThread != null) {
                this.aliveThread.stop();
                this.aliveThread = null;
            }
        }
    }

    protected void status() throws IOException {
        this.sendMsg(statusMsg);
    }

    public void sendMsg(OSCMessage msg) throws IOException {
        this.c.send((OSCPacket)msg);
    }

    public void sendBundle(OSCBundle bndl) throws IOException {
        this.c.send((OSCPacket)bndl);
    }

    public boolean sendMsgSync(OSCMessage msg, float timeout) throws IOException {
        OSCMessage result = this.sendMsgSync(msg, "/done", "/fail", 0, msg.getName(), timeout);
        return result != null && result.getName().equals("/done");
    }

    public OSCMessage sendMsgSync(OSCMessage msg, String doneCmd, String failCmd, int doneArgIdx, Object doneArgMatch, float timeout) throws IOException {
        return this.sendMsgSync(msg, doneCmd, failCmd, new int[]{doneArgIdx}, new Object[]{doneArgMatch}, new int[]{0}, new Object[]{msg.getName()}, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCMessage sendMsgSync(OSCMessage msg, String doneCmd, String failCmd, int[] doneArgIndices, Object[] doneArgMatches, int[] failArgIndices, Object[] failArgMatches, float timeout) throws IOException {
        SyncResponder resp = new SyncResponder(doneCmd, failCmd, doneArgIndices, doneArgMatches, failArgIndices, failArgMatches);
        try {
            SyncResponder syncResponder = resp;
            synchronized (syncResponder) {
                resp.add();
                this.sendMsg(msg);
                resp.wait((long)(timeout * 1000.0f));
            }
        }
        catch (InterruptedException e1) {
        }
        finally {
            resp.remove();
        }
        return resp.replyMsg;
    }

    public boolean sendBundleSync(OSCBundle bndl, String cmdName, float timeout) throws IOException {
        OSCMessage result = this.sendBundleSync(bndl, "/done", "/fail", 0, cmdName, timeout);
        return result != null && result.getName().equals("/done");
    }

    public OSCMessage sendBundleSync(OSCBundle bndl, String doneCmd, String failCmd, int argIdx, Object argMatch, float timeout) throws IOException {
        return this.sendBundleSync(bndl, doneCmd, failCmd, new int[]{argIdx}, new Object[]{argMatch}, new int[0], new Object[0], timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCMessage sendBundleSync(OSCBundle bndl, String doneCmd, String failCmd, int[] doneArgIndices, Object[] doneArgMatches, int[] failArgIndices, Object[] failArgMatches, float timeout) throws IOException {
        SyncResponder resp = new SyncResponder(doneCmd, failCmd, doneArgIndices, doneArgMatches, failArgIndices, failArgMatches);
        try {
            SyncResponder syncResponder = resp;
            synchronized (syncResponder) {
                resp.add();
                this.sendBundle(bndl);
                resp.wait((long)(timeout * 1000.0f));
            }
        }
        catch (InterruptedException e1) {
        }
        finally {
            resp.remove();
        }
        return resp.replyMsg;
    }

    public boolean sync(float timeout) throws IOException {
        return this.sync(null, timeout);
    }

    public boolean sync(OSCBundle bndl, float timeout) throws IOException {
        Integer id = new Integer(UniqueID.next());
        if (bndl == null) {
            bndl = new OSCBundle();
        }
        bndl.addPacket((OSCPacket)new OSCMessage("/sync", new Object[]{id}));
        return this.sendBundleSync(bndl, "/synced", null, 0, id, timeout) != null;
    }

    public int nextNodeID() {
        return this.nodeAllocator.alloc();
    }

    protected void addBuf(Buffer buf) {
        this.bufferArray[buf.getBufNum()] = buf;
    }

    protected void freeBuf(int idx) {
        this.bufferArray[idx] = null;
    }

    protected void waitForBufInfo() throws IOException {
        if (!this.waitingForBufInfo) {
            this.bufInfoResponder = new OSCResponderNode(this, "/b_info", new OSCListener(){

                public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
                    if (msg.getArgCount() < 4) {
                        return;
                    }
                    try {
                        Buffer buf = Server.this.bufferArray[((Number)msg.getArg(0)).intValue()];
                        if (buf != null) {
                            buf.setNumFrames(((Number)msg.getArg(1)).intValue());
                            buf.setNumChannels(((Number)msg.getArg(2)).intValue());
                            buf.setSampleRate(((Number)msg.getArg(3)).doubleValue());
                            buf.queryDone();
                            if (--Server.this.waitingBufs == 0) {
                                Server.this.waitingForBufInfo = false;
                                Server.this.bufInfoResponder.remove();
                            }
                        }
                    }
                    catch (IOException e1) {
                        Server.printError("Server.waitForBufInfo", e1);
                    }
                    catch (ClassCastException e2) {
                        Server.printError("Server.waitForBufInfo", e2);
                    }
                }
            }).add();
            this.waitingForBufInfo = true;
        }
        ++this.waitingBufs;
    }

    private void resetBufferAutoInfo() throws IOException {
        this.bufferArray = new Buffer[this.options.getNumBuffers()];
        this.waitingBufs = 0;
        this.waitingForBufInfo = false;
        if (this.bufInfoResponder != null) {
            this.bufInfoResponder.remove();
        }
    }

    public void printOn(PrintStream stream) {
        stream.print("Server(" + this.getName() + "," + this.getAddr() + "," + this.getOptions() + "," + this.getClientID() + ")");
    }

    public void quit() throws IOException {
        this.sendMsg(this.quitMsg());
        Server.inform("/quit sent");
        this.cleanUpAfterQuit();
    }

    public OSCMessage quitMsg() {
        return new OSCMessage("/quit", OSCMessage.NO_ARGS);
    }

    private void cleanUpAfterQuit() {
        try {
            this.stopAliveThread();
            this.dumpMode = 0;
            this.setBooting(false);
            this.setRunning(false);
            this.createNewAllocators();
            this.resetBufferAutoInfo();
        }
        catch (IOException e1) {
            Server.printError("Server.cleanUpAfterQuit", e1);
        }
    }

    public void dispose() {
        this.multi.dispose();
        setServers.remove(this);
        mapServerNames.remove(this.getName());
        this.em.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quitAndWait() throws IOException {
        try {
            boolean bl;
            if (!this.isBooting() && !this.isRunning()) {
                boolean bl2 = true;
                return bl2;
            }
            OSCMessage msg = this.quitMsg();
            for (int i = 0; i < 16; ++i) {
                if (!this.sendMsgSync(msg, 0.5f)) continue;
                this.cleanUpAfterQuit();
                boolean bl3 = true;
                return bl3;
            }
            if (this.isLocal) {
                try {
                    Object i = this.syncBootThread;
                    synchronized (i) {
                        if (this.bootThread != null) {
                            this.bootThread.keepScRunning = false;
                            this.syncBootThread.wait(4000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isBooting() && !this.isRunning()) {
                bl = true;
                return bl;
            }
            this.printOn(printStream);
            printStream.println(" : failed to quit!");
            bl = false;
            return bl;
        }
        finally {
            this.cleanUpAfterQuit();
        }
    }

    public static void quitAll() {
        Iterator iter = setServers.iterator();
        while (iter.hasNext()) {
            Server s = (Server)iter.next();
            if (s.isLocal) {
                try {
                    s.quitAndWait();
                }
                catch (IOException e1) {
                    Server.printError("Server.quitAll", e1);
                }
            }
            s.dispose();
        }
    }

    protected static void printError(String name, Throwable t) {
        printStream.print(name + " : ");
        t.printStackTrace(printStream);
    }

    public void processEvent(BasicEvent e) {
        ServerEvent sce = (ServerEvent)e;
        for (int i = 0; i < this.em.countListeners(); ++i) {
            ServerListener listener = (ServerListener)this.em.getListener(i);
            listener.serverAction(sce);
        }
    }

    private class SyncResponder
    implements OSCListener {
        protected volatile OSCMessage replyMsg = null;
        private final OSCResponderNode doneResp;
        private final OSCResponderNode failResp;
        private final String doneCmdName;
        private final int[] doneArgIndices;
        private final Object[] doneArgMatches;
        private final int doneMinArgNum;
        private final String failCmdName;
        private final int[] failArgIndices;
        private final Object[] failArgMatches;
        private final int failMinArgNum;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected SyncResponder(String doneCmdName, String failCmdName, int[] doneArgIndices, Object[] doneArgMatches, int[] failArgIndices, Object[] failArgMatches) throws IOException {
            int j;
            this.doneCmdName = doneCmdName;
            this.doneArgIndices = doneArgIndices;
            this.doneArgMatches = doneArgMatches;
            this.failCmdName = failCmdName;
            this.failArgIndices = failArgIndices;
            this.failArgMatches = failArgMatches;
            int i = 0;
            for (j = 0; j < doneArgIndices.length; ++j) {
                i = Math.max(i, doneArgIndices[j]);
            }
            this.doneMinArgNum = i;
            this.doneResp = new OSCResponderNode(Server.this.enc_this, doneCmdName, this);
            if (failCmdName != null) {
                i = 0;
                for (j = 0; j < failArgIndices.length; ++j) {
                    i = Math.max(i, failArgIndices[j]);
                }
                this.failMinArgNum = i;
                this.failResp = new OSCResponderNode(Server.this.enc_this, failCmdName, this);
            } else {
                this.failMinArgNum = 0;
                this.failResp = null;
            }
        }

        protected void add() throws IOException {
            this.doneResp.add();
            if (this.failResp != null) {
                this.failResp.add();
            }
        }

        protected void remove() {
            try {
                this.doneResp.remove();
            }
            catch (IOException e1) {
                Server.printError("SyncResponder.remove", e1);
            }
            try {
                if (this.failResp != null) {
                    this.failResp.remove();
                }
            }
            catch (IOException e1) {
                Server.printError("SyncResponder.remove", e1);
            }
        }

        public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
            if (msg.getName().equals(this.doneCmdName)) {
                this.doneMessageReceived(msg);
            } else if (msg.getName().equals(this.failCmdName)) {
                this.failMessageReceived(msg);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)msg.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doneMessageReceived(OSCMessage msg) {
            if (msg.getArgCount() < this.doneMinArgNum) {
                return;
            }
            for (int i = 0; i < this.doneArgIndices.length; ++i) {
                if (msg.getArg(this.doneArgIndices[i]).equals(this.doneArgMatches[i])) continue;
                return;
            }
            this.replyMsg = msg;
            this.remove();
            SyncResponder syncResponder = this;
            synchronized (syncResponder) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failMessageReceived(OSCMessage msg) {
            if (msg.getArgCount() < this.failMinArgNum) {
                return;
            }
            for (int i = 0; i < this.failArgIndices.length; ++i) {
                if (msg.getArg(this.failArgIndices[i]).equals(this.failArgMatches[i])) continue;
                return;
            }
            this.replyMsg = msg;
            this.remove();
            SyncResponder syncResponder = this;
            synchronized (syncResponder) {
                this.notifyAll();
            }
        }

        static {
            $assertionsDisabled = !(class$de$sciss$jcollider$Server == null ? (class$de$sciss$jcollider$Server = Server.class$("de.sciss.jcollider.Server")) : class$de$sciss$jcollider$Server).desiredAssertionStatus();
        }
    }

    private class StatusWatcher
    implements OSCListener,
    ActionListener {
        private int alive = 0;
        private final int delayMillis;
        private final int periodMillis;
        private final OSCResponderNode resp;
        private final int deathBounces;
        private final Timer timer;

        protected StatusWatcher(float delay, float period, int deathBounces) {
            this.delayMillis = (int)(delay * 1000.0f);
            this.periodMillis = (int)(period * 1000.0f);
            this.resp = new OSCResponderNode(Server.this.enc_this, "status.reply", this);
            this.deathBounces = deathBounces;
            this.timer = new Timer(this.periodMillis, this);
            this.timer.setInitialDelay(this.delayMillis);
        }

        protected void start() throws IOException {
            this.resp.add();
            this.timer.restart();
        }

        protected void stop() throws IOException {
            this.timer.stop();
            this.resp.remove();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.alive > 0) {
                Server.this.setRunning(true);
                --this.alive;
            } else {
                Server.this.setRunning(false);
            }
            if (Server.this.serverBooting && Server.this.getOptions().getProtocol().equals("tcp") && !Server.this.c.isConnected()) {
                try {
                    Server.this.c.start();
                }
                catch (IOException e1) {
                    Server.printError("Server.status", e1);
                }
            } else {
                try {
                    Server.this.status();
                }
                catch (IOException e1) {
                    Server.printError("Server.status", e1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
            if (msg.getArgCount() < 9) {
                return;
            }
            this.alive = this.deathBounces;
            try {
                Status status = Server.this.status;
                synchronized (status) {
                    Server.this.status.numUGens = ((Number)msg.getArg(1)).intValue();
                    Server.this.status.numSynths = ((Number)msg.getArg(2)).intValue();
                    Server.this.status.numGroups = ((Number)msg.getArg(3)).intValue();
                    Server.this.status.numSynthDefs = ((Number)msg.getArg(4)).intValue();
                    Server.this.status.avgCPU = ((Number)msg.getArg(5)).floatValue();
                    Server.this.status.peakCPU = ((Number)msg.getArg(6)).floatValue();
                    Server.this.status.sampleRate = ((Number)msg.getArg(7)).doubleValue();
                    Server.this.status.actualSampleRate = ((Number)msg.getArg(8)).doubleValue();
                }
                Server.this.changed(2);
            }
            catch (ClassCastException e1) {
                Server.printError("StatusWatcher.messageReceived", e1);
            }
        }
    }

    public static class Status {
        public int numUGens;
        public int numSynths;
        public int numGroups;
        public int numSynthDefs;
        public float avgCPU;
        public float peakCPU;
        public volatile double sampleRate;
        public volatile double actualSampleRate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Status copyFrom(Status s) {
            Status result = new Status();
            Status status = s;
            synchronized (status) {
                result.numUGens = s.numUGens;
                result.numSynths = s.numSynths;
                result.numGroups = s.numGroups;
                result.numSynthDefs = s.numSynthDefs;
                result.avgCPU = s.avgCPU;
                result.peakCPU = s.peakCPU;
                result.sampleRate = s.sampleRate;
                result.actualSampleRate = s.actualSampleRate;
            }
            return result;
        }
    }

    private class BootThread
    extends Thread {
        private final String[] cmdArray;
        protected volatile boolean keepScRunning;
        protected final Server server;
        private final boolean startAliveThread;

        protected BootThread(Server server2, String[] cmdArray, boolean startAliveThread) {
            super(server2.getName());
            this.keepScRunning = true;
            this.cmdArray = cmdArray;
            this.server = server2;
            this.startAliveThread = startAliveThread;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process p = null;
            int resultCode = -1;
            boolean pRunning = true;
            boolean cStarted = false;
            byte[] inBuf = new byte[128];
            byte[] errBuf = new byte[128];
            File cwd = new File(this.cmdArray[0]).getParentFile();
            try {
                p = Runtime.getRuntime().exec(this.cmdArray, null, cwd);
                BufferedInputStream inStream = new BufferedInputStream(p.getInputStream());
                BufferedInputStream errStream = new BufferedInputStream(p.getErrorStream());
                while (this.keepScRunning && pRunning) {
                    if (!cStarted) {
                        try {
                            this.server.start();
                            cStarted = true;
                            if (this.startAliveThread) {
                                this.server.startAliveThread(2.0f, 0.7f, 8);
                            }
                        }
                        catch (ConnectException e1) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e5) {
                        // empty catch block
                    }
                    this.handleConsole(inStream, inBuf);
                    this.handleConsole(errStream, errBuf);
                    try {
                        resultCode = p.exitValue();
                        pRunning = false;
                        p = null;
                        printStream.println("scsynth terminated (" + resultCode + ")");
                    }
                    catch (IllegalThreadStateException e1) {}
                }
            }
            catch (IOException e3) {
                Server.printError("BootThread.run", e3);
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
                Object object = Server.this.syncBootThread;
                synchronized (object) {
                    try {
                        this.server.stopAliveThread();
                    }
                    catch (IOException e1) {
                        Server.printError("Server.stopAliveThread", e1);
                    }
                    this.server.bootThread = null;
                    this.server.setBooting(false);
                    this.server.setRunning(false);
                    Server.this.syncBootThread.notifyAll();
                }
            }
        }

        private void handleConsole(InputStream stream, byte[] buf) {
            try {
                while (stream.available() > 0) {
                    int i = Math.min(buf.length, stream.available());
                    stream.read(buf, 0, i);
                    printStream.write(buf, 0, i);
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    public static interface CompletionAction {
        public void completion(Server var1);
    }
}

