/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.BlockAllocator;
import de.sciss.jcollider.PowerOfTwoAllocator;
import java.util.ArrayList;
import java.util.List;

public class ServerOptions {
    public static final String UDP = "udp";
    public static final String TCP = "tcp";
    private static final int DEFAULT_NUMAUDIOBUSCHANNELS = 128;
    private static final int DEFAULT_NUMCONTROLBUSCHANNELS = 4096;
    private static final int DEFAULT_NUMINPUTBUSCHANNELS = 8;
    private static final int DEFAULT_NUMOUTPUTBUSCHANNELS = 8;
    private static final int DEFAULT_NUMBUFFERS = 1024;
    private static final int DEFAULT_MAXNODES = 1024;
    private static final int DEFAULT_MAXSYNTHDEFS = 1024;
    private static final String DEFAULT_PROTOCOL = "udp";
    private static final int DEFAULT_BLOCKSIZE = 64;
    private static final int DEFAULT_HARDWAREBUFFERSIZE = 0;
    private static final int DEFAULT_MEMSIZE = 8192;
    private static final int DEFAULT_NUMRGENS = 64;
    private static final int DEFAULT_NUMWIREBUFS = 64;
    private static final double DEFAULT_SAMPLERATE = 0.0;
    private static final boolean DEFAULT_LOADDEFS = true;
    private static final String DEFAULT_INPUTSTREAMSENABLED;
    private static final String DEFAULT_OUTPUTSTREAMSENABLED;
    private static final String DEFAULT_DEVICE;
    private static final int DEFAULT_VERBOSITY = 0;
    private static final boolean DEFAULT_RENDEZVOUS = true;
    private int numAudioBusChannels = 128;
    private int numControlBusChannels = 4096;
    private int numInputBusChannels = 8;
    private int numOutputBusChannels = 8;
    private int numBuffers = 1024;
    private int maxNodes = 1024;
    private int maxSynthDefs = 1024;
    private String protocol = "udp";
    private int blockSize = 64;
    private int hardwareBufferSize = 0;
    private int memSize = 8192;
    private int numRGens = 64;
    private int numWireBufs = 64;
    private double sampleRate = 0.0;
    private boolean loadDefs = true;
    private String inputStreamsEnabled = DEFAULT_INPUTSTREAMSENABLED;
    private String outputStreamsEnabled = DEFAULT_OUTPUTSTREAMSENABLED;
    private String device = DEFAULT_DEVICE;
    private BlockAllocator.Factory blockAlloc = new PowerOfTwoAllocator.Factory();
    private int verbosity = 0;
    private boolean rendezvous = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public List toOptionList(int port) {
        return this.toOptionList(port, false);
    }

    public List toOptionList(int port, boolean verbose) {
        ArrayList<String> coll = new ArrayList<String>();
        if (this.protocol.equals("udp")) {
            coll.add("-u");
        } else if (this.protocol.equals(TCP)) {
            coll.add("-t");
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)this.protocol);
        }
        coll.add(String.valueOf(port));
        if (verbose || this.numAudioBusChannels != 128) {
            coll.add("-a");
            coll.add(String.valueOf(this.numAudioBusChannels));
        }
        if (verbose || this.numControlBusChannels != 4096) {
            coll.add("-c");
            coll.add(String.valueOf(this.numControlBusChannels));
        }
        if (verbose || this.numInputBusChannels != 8) {
            coll.add("-i");
            coll.add(String.valueOf(this.numInputBusChannels));
        }
        if (verbose || this.numOutputBusChannels != 8) {
            coll.add("-o");
            coll.add(String.valueOf(this.numOutputBusChannels));
        }
        if (verbose || this.numBuffers != 1024) {
            coll.add("-b");
            coll.add(String.valueOf(this.numBuffers));
        }
        if (verbose || this.maxNodes != 1024) {
            coll.add("-n");
            coll.add(String.valueOf(this.maxNodes));
        }
        if (verbose || this.maxSynthDefs != 1024) {
            coll.add("-d");
            coll.add(String.valueOf(this.maxSynthDefs));
        }
        if (verbose || this.blockSize != 64) {
            coll.add("-z");
            coll.add(String.valueOf(this.blockSize));
        }
        if (verbose || this.hardwareBufferSize != 0) {
            coll.add("-Z");
            coll.add(String.valueOf(this.hardwareBufferSize));
        }
        if (verbose || this.memSize != 8192) {
            coll.add("-m");
            coll.add(String.valueOf(this.memSize));
        }
        if (verbose || this.numRGens != 64) {
            coll.add("-r");
            coll.add(String.valueOf(this.numRGens));
        }
        if (verbose || this.numWireBufs != 64) {
            coll.add("-w");
            coll.add(String.valueOf(this.numWireBufs));
        }
        if (verbose || this.sampleRate != 0.0) {
            coll.add("-S");
            coll.add(String.valueOf(this.sampleRate));
        }
        if (verbose || !this.loadDefs) {
            coll.add("-D");
            coll.add(String.valueOf(this.loadDefs ? 1 : 0));
        }
        if (this.inputStreamsEnabled != DEFAULT_INPUTSTREAMSENABLED) {
            coll.add("-I");
            coll.add(this.inputStreamsEnabled);
        }
        if (this.outputStreamsEnabled != DEFAULT_OUTPUTSTREAMSENABLED) {
            coll.add("-O");
            coll.add(this.outputStreamsEnabled);
        }
        if (this.device != DEFAULT_DEVICE) {
            coll.add("-H");
            coll.add(this.device);
        }
        if (verbose || this.verbosity != 0) {
            coll.add("-v");
            coll.add(String.valueOf(this.verbosity));
        }
        if (verbose || !this.rendezvous) {
            coll.add("-R");
            coll.add(String.valueOf(this.rendezvous ? 1 : 0));
        }
        return coll;
    }

    public int getNumAudioBusChannels() {
        return this.numAudioBusChannels;
    }

    public void setNumAudioBusChannels(int numAudioBusChannels) {
        this.numAudioBusChannels = numAudioBusChannels;
    }

    public int getNumControlBusChannels() {
        return this.numControlBusChannels;
    }

    public void setNumControlBusChannels(int numControlBusChannels) {
        this.numControlBusChannels = numControlBusChannels;
    }

    public int getNumInputBusChannels() {
        return this.numInputBusChannels;
    }

    public void setNumInputBusChannels(int numInputBusChannels) {
        this.numInputBusChannels = numInputBusChannels;
    }

    public int getNumOutputBusChannels() {
        return this.numOutputBusChannels;
    }

    public void setNumOutputBusChannels(int numOutputBusChannels) {
        this.numOutputBusChannels = numOutputBusChannels;
    }

    public int getNumBuffers() {
        return this.numBuffers;
    }

    public void setNumBuffers(int numBuffers) {
        this.numBuffers = numBuffers;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public int getMaxSynthDefs() {
        return this.maxSynthDefs;
    }

    public void setMaxSynthDefs(int maxSynthDefs) {
        this.maxSynthDefs = maxSynthDefs;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (!protocol.equals("udp") && !protocol.equals(TCP)) {
            throw new IllegalArgumentException(protocol);
        }
        this.protocol = protocol;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getHardwareBufferSize() {
        return this.hardwareBufferSize;
    }

    public void setHardwareBufferSize(int hardwareBufferSize) {
        this.hardwareBufferSize = hardwareBufferSize;
    }

    public int getMemSize() {
        return this.memSize;
    }

    public void setMemSize(int memSize) {
        this.memSize = memSize;
    }

    public int getNumRGens() {
        return this.numRGens;
    }

    public void setNumRGens(int numRGens) {
        this.numRGens = numRGens;
    }

    public int getNumWireBufs() {
        return this.numWireBufs;
    }

    public void setNumWireBufs(int numWireBufs) {
        this.numWireBufs = numWireBufs;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public boolean getLoadDefs() {
        return this.loadDefs;
    }

    public void setLoadDefs(boolean loadDefs) {
        this.loadDefs = loadDefs;
    }

    public String getInputStreamsEnabled() {
        return this.inputStreamsEnabled;
    }

    public void setInputStreamsEnabled(String inputStreamsEnabled) {
        this.inputStreamsEnabled = inputStreamsEnabled;
    }

    public String getOutputStreamsEnabled() {
        return this.outputStreamsEnabled;
    }

    public void setOutputStreamsEnabled(String outputStreamsEnabled) {
        this.outputStreamsEnabled = outputStreamsEnabled;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public BlockAllocator.Factory getBlockAllocFactory() {
        return this.blockAlloc;
    }

    public void setBlockAllocFactory(BlockAllocator.Factory baf) {
        this.blockAlloc = baf;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public boolean getRendezvous() {
        return this.rendezvous;
    }

    public void setRendezvous(boolean rendezvous) {
        this.rendezvous = rendezvous;
    }

    public int getFirstPrivateBus() {
        return this.getNumOutputBusChannels() + this.getNumInputBusChannels();
    }

    public static String[] optionListToStringArray(List list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).toString();
        }
        return array;
    }

    public static String stringArrayToConsoleString(String[] array) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            boolean b;
            boolean bl = b = array[i].indexOf(32) != -1;
            if (b) {
                strBuf.append('\"');
            }
            strBuf.append(array[i]);
            if (b) {
                strBuf.append('\"');
            }
            strBuf.append(' ');
        }
        return strBuf.toString();
    }

    static {
        $assertionsDisabled = !ServerOptions.class.desiredAssertionStatus();
        DEFAULT_INPUTSTREAMSENABLED = null;
        DEFAULT_OUTPUTSTREAMSENABLED = null;
        DEFAULT_DEVICE = null;
    }
}

