/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Group;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.Server;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class Synth
extends Node {
    private final String defName;

    public Synth(String defName, Node target) throws IOException {
        this(defName, null, null, target, 0);
    }

    public Synth(String defName, String[] argNames, float[] argValues, Node target) throws IOException {
        this(defName, argNames, argValues, target, 0);
    }

    public Synth(String defName, String[] argNames, float[] argValues, Node target, int addAction) throws IOException {
        this(defName, target.getServer(), target.getServer().nextNodeID());
        this.getServer().sendMsg(this.newMsg(target, argNames, argValues, addAction));
    }

    protected Synth(String defName, Server server, int nodeID) {
        super(server, nodeID);
        this.defName = defName;
    }

    public static void grain(String defName, Node target) throws IOException {
        Synth.grain(defName, null, null, target, 0);
    }

    public static void grain(String defName, String[] argNames, float[] argValues, Node target) throws IOException {
        Synth.grain(defName, argNames, argValues, target, 0);
    }

    public static void grain(String defName, String[] argNames, float[] argValues, Node target, int addAction) throws IOException {
        Synth s = new Synth(defName, target.getServer(), -1);
        s.getServer().sendMsg(s.newMsg(target, argNames, argValues, addAction));
    }

    public String getDefName() {
        return this.defName;
    }

    public OSCMessage newMsg() {
        return this.newMsg(this.getServer().asTarget());
    }

    public OSCMessage newMsg(Node target) {
        return this.newMsg(target, null, null);
    }

    public OSCMessage newMsg(Node target, String[] argNames, float[] argValues) {
        return this.newMsg(target, argNames, argValues, 0);
    }

    public OSCMessage newMsg(Node target, String[] argNames, float[] argValues, int addAction) {
        if (target == null) {
            target = this.getServer().getDefaultGroup();
        }
        int argNum = argNames == null ? 0 : argNames.length;
        Object[] allArgs = new Object[argNum * 2 + 4];
        allArgs[0] = this.getDefName();
        allArgs[1] = new Integer(this.getNodeID());
        allArgs[2] = new Integer(addAction);
        allArgs[3] = new Integer(target.getNodeID());
        int j = 4;
        for (int i = 0; i < argNum; ++i) {
            allArgs[j++] = argNames[i];
            allArgs[j++] = new Float(argValues[i]);
        }
        return new OSCMessage("/s_new", allArgs);
    }

    public static Synth newPaused(String defName, String[] argNames, float[] argValues, Node target) throws IOException {
        return Synth.newPaused(defName, argNames, argValues, target, 0);
    }

    public static Synth newPaused(String defName, String[] argNames, float[] argValues, Node target, int addAction) throws IOException {
        Synth synth = Synth.basicNew(defName, target.getServer());
        OSCBundle bndl = new OSCBundle(0.0);
        bndl.addPacket((OSCPacket)synth.newMsg(target, argNames, argValues, addAction));
        bndl.addPacket((OSCPacket)synth.runMsg(false));
        synth.getServer().sendBundle(bndl);
        return synth;
    }

    public static Synth basicNew(String defName, Server server) {
        return Synth.basicNew(defName, server, server.nextNodeID());
    }

    public static Synth basicNew(String defName, Server server, int nodeID) {
        return new Synth(defName, server, nodeID);
    }

    public static Synth after(Node aNode, String defName) throws IOException {
        return Synth.after(aNode, defName, null, null);
    }

    public static Synth after(Node aNode, String defName, String[] argNames, float[] argValues) throws IOException {
        return new Synth(defName, argNames, argValues, aNode, 3);
    }

    public static Synth before(Node aNode, String defName) throws IOException {
        return Synth.before(aNode, defName, null, null);
    }

    public static Synth before(Node aNode, String defName, String[] argNames, float[] argValues) throws IOException {
        return new Synth(defName, argNames, argValues, aNode, 2);
    }

    public static Synth head(Group aGroup, String defName) throws IOException {
        return Synth.head(aGroup, defName, null, null);
    }

    public static Synth head(Node aGroup, String defName, String[] argNames, float[] argValues) throws IOException {
        return new Synth(defName, argNames, argValues, aGroup, 0);
    }

    public static Synth tail(Group aGroup, String defName) throws IOException {
        return Synth.tail(aGroup, defName, null, null);
    }

    public static Synth tail(Node aGroup, String defName, String[] argNames, float[] argValues) throws IOException {
        return new Synth(defName, argNames, argValues, aGroup, 1);
    }

    public static Synth replace(Node nodeToReplace, String defName) throws IOException {
        return Synth.replace(nodeToReplace, defName, null, null);
    }

    public static Synth replace(Node nodeToReplace, String defName, String[] argNames, float[] argValues) throws IOException {
        return new Synth(defName, argNames, argValues, nodeToReplace, 4);
    }

    public OSCMessage addToHeadMsg(Group aGroup, String[] argNames, float[] argValues) {
        return this.newMsg(aGroup, argNames, argValues, 0);
    }

    public OSCMessage addToTailMsg(Group aGroup, String[] argNames, float[] argValues) {
        return this.newMsg(aGroup, argNames, argValues, 1);
    }

    public OSCMessage addAfterMsg(Node aNode, String[] argNames, float[] argValues) {
        return this.newMsg(aNode, argNames, argValues, 3);
    }

    public OSCMessage addBeforeMsg(Node aNode, String[] argNames, float[] argValues) {
        return this.newMsg(aNode, argNames, argValues, 2);
    }

    public OSCMessage addReplaceMsg(Node aNode, String[] argNames, float[] argValues) {
        return this.newMsg(aNode, argNames, argValues, 4);
    }

    public float get(int index) throws IOException {
        OSCMessage getMsg = this.getMsg(index);
        OSCMessage replyMsg = this.getServer().sendMsgSync(getMsg, "/n_set", "/fail", new int[]{0, 1}, new Object[]{new Integer(this.getNodeID()), new Integer(index)}, new int[]{0}, new Object[]{getMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_set")) {
            return ((Number)replyMsg.getArg(2)).floatValue();
        }
        throw new IOException(replyMsg == null ? "s_get timeout" : "s_get failed");
    }

    public float[] get(int[] indices) throws IOException {
        OSCMessage getMsg = this.getMsg(indices);
        int[] doneIndices = new int[indices.length + 1];
        Object[] doneMatches = new Object[indices.length + 1];
        doneIndices[0] = 0;
        doneMatches[0] = new Integer(this.getNodeID());
        int i = 1;
        int j = 0;
        int k = 1;
        while (j < indices.length) {
            doneIndices[i] = k;
            doneMatches[i] = new Integer(indices[j]);
            ++i;
            ++j;
            k += 2;
        }
        OSCMessage replyMsg = this.getServer().sendMsgSync(getMsg, "/n_set", "/fail", doneIndices, doneMatches, new int[]{0}, new Object[]{getMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_set")) {
            float[] values = new float[indices.length];
            int i2 = 2;
            for (int j2 = 0; j2 < indices.length; ++j2) {
                values[j2] = ((Number)replyMsg.getArg(i2)).floatValue();
                i2 += 2;
            }
            return values;
        }
        return null;
    }

    public float get(String name) throws IOException {
        OSCMessage getMsg = this.getMsg(name);
        OSCMessage replyMsg = this.getServer().sendMsgSync(getMsg, "/n_set", "/fail", new int[]{0, 1}, new Object[]{new Integer(this.getNodeID()), name}, new int[]{0}, new Object[]{getMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_set")) {
            return ((Number)replyMsg.getArg(2)).floatValue();
        }
        throw new IOException(replyMsg == null ? "s_get timeout" : "s_get failed");
    }

    public float[] get(String[] names) throws IOException {
        OSCMessage getMsg = this.getMsg(names);
        int[] doneIndices = new int[names.length + 1];
        Object[] doneMatches = new Object[names.length + 1];
        doneIndices[0] = 0;
        doneMatches[0] = new Integer(this.getNodeID());
        int i = 1;
        int j = 0;
        int k = 1;
        while (j < names.length) {
            doneIndices[i] = k;
            doneMatches[i] = names[j];
            ++i;
            ++j;
            k += 2;
        }
        OSCMessage replyMsg = this.getServer().sendMsgSync(getMsg, "/n_set", "/fail", doneIndices, doneMatches, new int[]{0}, new Object[]{getMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_set")) {
            float[] values = new float[names.length];
            int i2 = 2;
            for (int j2 = 0; j2 < names.length; ++j2) {
                values[j2] = ((Number)replyMsg.getArg(i2)).floatValue();
                i2 += 2;
            }
            return values;
        }
        return null;
    }

    public OSCMessage getMsg(int index) {
        return new OSCMessage("/s_get", new Object[]{new Integer(this.getNodeID()), new Integer(index)});
    }

    public OSCMessage getMsg(int[] indices) {
        Object[] args = new Object[indices.length + 1];
        args[0] = new Integer(this.getNodeID());
        int i = 1;
        for (int j = 0; j < indices.length; ++j) {
            args[i] = new Integer(indices[j]);
            ++i;
        }
        return new OSCMessage("/s_get", args);
    }

    public OSCMessage getMsg(String name) {
        return new OSCMessage("/s_get", new Object[]{new Integer(this.getNodeID()), name});
    }

    public OSCMessage getMsg(String[] names) {
        Object[] args = new Object[names.length + 1];
        args[0] = new Integer(this.getNodeID());
        System.arraycopy(names, 0, args, 1, names.length);
        return new OSCMessage("/s_get", args);
    }

    public float[] getn(int index, int count) throws IOException {
        OSCMessage getnMsg = this.getnMsg(index, count);
        OSCMessage replyMsg = this.getServer().sendMsgSync(getnMsg, "/n_setn", "/fail", new int[]{0, 1, 2}, new Object[]{new Integer(this.getNodeID()), new Integer(index), new Integer(count)}, new int[]{0}, new Object[]{getnMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_setn")) {
            float[] values = new float[count];
            int i = 3;
            for (int j = 0; j < count; ++j) {
                values[j] = ((Number)replyMsg.getArg(i)).floatValue();
            }
            return values;
        }
        return null;
    }

    public float[] getn(String name, int count) throws IOException {
        OSCMessage getnMsg = this.getnMsg(name, count);
        OSCMessage replyMsg = this.getServer().sendMsgSync(getnMsg, "/n_setn", "/fail", new int[]{0, 1, 2}, new Object[]{new Integer(this.getNodeID()), new Integer(name), new Integer(count)}, new int[]{0}, new Object[]{getnMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_setn")) {
            float[] values = new float[count];
            int i = 3;
            for (int j = 0; j < count; ++j) {
                values[j] = ((Number)replyMsg.getArg(i)).floatValue();
            }
            return values;
        }
        return null;
    }

    public float[] getn(int[] indices, int[] counts) throws IOException {
        OSCMessage getnMsg = this.getnMsg(indices, counts);
        int[] doneIndices = new int[(indices.length << 1) + 1];
        Object[] doneMatches = new Object[(indices.length << 1) + 1];
        int numValues = 0;
        doneIndices[0] = 0;
        doneMatches[0] = new Integer(this.getNodeID());
        int i = 1;
        int k = 1;
        for (int j = 0; j < indices.length; ++j) {
            doneIndices[i] = k++;
            doneMatches[i] = new Integer(indices[j]);
            doneIndices[++i] = k;
            doneMatches[i] = new Integer(counts[j]);
            ++i;
            k += counts[j] + 1;
            numValues += counts[j];
        }
        OSCMessage replyMsg = this.getServer().sendMsgSync(getnMsg, "/n_setn", "/fail", doneIndices, doneMatches, new int[]{0}, new Object[]{getnMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_setn")) {
            float[] values = new float[numValues];
            int i2 = 3;
            int k2 = 0;
            for (int j = 0; j < indices.length; ++j) {
                for (int m = 0; m < counts[j]; ++m) {
                    values[k2] = ((Number)replyMsg.getArg(i2)).floatValue();
                    ++i2;
                    ++k2;
                }
                i2 += 2;
            }
            return values;
        }
        return null;
    }

    public float[] getn(String[] names, int[] counts) throws IOException {
        OSCMessage getnMsg = this.getnMsg(names, counts);
        int[] doneIndices = new int[(names.length << 1) + 1];
        Object[] doneMatches = new Object[(names.length << 1) + 1];
        int numValues = 0;
        doneIndices[0] = 0;
        doneMatches[0] = new Integer(this.getNodeID());
        int i = 1;
        int k = 1;
        for (int j = 0; j < names.length; ++j) {
            doneIndices[i] = k++;
            doneMatches[i] = new Integer(names[j]);
            doneIndices[++i] = k;
            doneMatches[i] = new Integer(counts[j]);
            ++i;
            k += counts[j] + 1;
            numValues += counts[j];
        }
        OSCMessage replyMsg = this.getServer().sendMsgSync(getnMsg, "/n_setn", "/fail", doneIndices, doneMatches, new int[]{0}, new Object[]{getnMsg.getName()}, 4.0f);
        if (replyMsg != null && replyMsg.getName().equals("/n_setn")) {
            float[] values = new float[numValues];
            int i2 = 3;
            int k2 = 0;
            for (int j = 0; j < names.length; ++j) {
                for (int m = 0; m < counts[j]; ++m) {
                    values[k2] = ((Number)replyMsg.getArg(i2)).floatValue();
                    ++i2;
                    ++k2;
                }
                i2 += 2;
            }
            return values;
        }
        return null;
    }

    public OSCMessage getnMsg(int index, int count) {
        return new OSCMessage("/s_getn", new Object[]{new Integer(this.getNodeID()), new Integer(index), new Integer(count)});
    }

    public OSCMessage getnMsg(int[] indices, int[] counts) {
        if (indices.length != counts.length) {
            throw new IllegalArgumentException("# of indices must match # of counts");
        }
        Object[] args = new Object[(indices.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int i = 1;
        for (int j = 0; j < indices.length; ++j) {
            args[i++] = new Integer(indices[j]);
            args[i++] = new Integer(counts[j]);
        }
        return new OSCMessage("/s_getn", args);
    }

    public OSCMessage getnMsg(String name, int count) {
        return new OSCMessage("/s_getn", new Object[]{new Integer(this.getNodeID()), name, new Integer(count)});
    }

    public OSCMessage getnMsg(String[] names, int[] counts) {
        if (names.length != counts.length) {
            throw new IllegalArgumentException("# of names must match # of counts");
        }
        Object[] args = new Object[(names.length << 1) + 1];
        args[0] = new Integer(this.getNodeID());
        int i = 1;
        for (int j = 0; j < names.length; ++j) {
            args[i++] = names[j];
            args[i++] = new Integer(counts[j]);
        }
        return new OSCMessage("/s_getn", args);
    }

    public String toString() {
        if (this.getName() == null) {
            return "Synth(" + this.getNodeID() + ",\"" + this.defName + "\")";
        }
        return "Synth::" + this.getName() + "(" + this.getNodeID() + ",\"" + this.defName + "\")";
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndex(TreeNode node) {
        return -1;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return null;
    }
}

