/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Constant;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Control;
import de.sciss.jcollider.ControlDesc;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.GraphElemArray;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.UGen;
import de.sciss.jcollider.UGenChannel;
import de.sciss.jcollider.UGenInput;
import de.sciss.net.OSCMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SynthDef
implements Constants {
    public static final String SUFFIX = ".scsyndef";
    public static final int SCGF_VERSION = 1;
    private static final int SCGF_MAGIC = 1396926310;
    private List controlDescs = new ArrayList();
    private List ugens = new ArrayList();
    private Set ugenSet = new HashSet();
    private List constants = new ArrayList();
    private Set constantSet = new HashSet();
    private final String name;
    private List variants = new ArrayList();
    private static final Object[] RATES = new Object[]{kScalarRate, kControlRate, kAudioRate, kDemandRate};
    private static final Comparator synthIdxComp = new SynthIndexComparator();
    private static final Set ctrlUGensSet = new HashSet();

    private SynthDef(String name) {
        this.name = name;
    }

    public SynthDef(String name, GraphElem graph) {
        this(name);
        this.build(GraphElemArray.asArray(graph));
    }

    private void build(GraphElemArray graphArray) {
        this.collectUGens(graphArray);
        this.collectConstants();
        this.topologicalSort();
    }

    private void addControlDesc(ControlDesc desc) {
        this.controlDescs.add(desc);
    }

    private void addUGen(UGen ugen) {
        if (this.ugenSet.add(ugen)) {
            this.ugens.add(ugen);
            if (ugen instanceof Control) {
                Control ctrl = (Control)ugen;
                ctrl.setSpecialIndex(this.controlDescs.size());
                for (int i = 0; i < ctrl.getNumDescs(); ++i) {
                    this.addControlDesc(ctrl.getDesc(i));
                }
            }
        }
    }

    private void addConstant(Constant value) {
        if (this.constantSet.add(value)) {
            this.constants.add(value);
        }
    }

    private void collectUGens(GraphElemArray graphArray) {
        for (int i = 0; i < graphArray.getNumElements(); ++i) {
            GraphElem g = graphArray.getElement(i);
            if (g instanceof UGen) {
                UGen ugen = (UGen)g;
                this.addUGen(ugen);
                this.collectUGens(ugen.getInputs());
                continue;
            }
            if (g instanceof GraphElemArray) {
                this.collectUGens((GraphElemArray)g);
                continue;
            }
            this.collectUGens(g.asUGenInputs());
        }
    }

    private void collectUGens(UGenInput[] ins) {
        for (int i = 0; i < ins.length; ++i) {
            if (!(ins[i] instanceof UGenChannel)) continue;
            UGen ugen = ((UGenChannel)ins[i]).getUGen();
            this.addUGen(ugen);
            this.collectUGens(ugen.getInputs());
        }
    }

    private void collectConstants() {
        for (int i = 0; i < this.ugens.size(); ++i) {
            UGen ugen = (UGen)this.ugens.get(i);
            for (int j = 0; j < ugen.getNumInputs(); ++j) {
                UGenInput ui = ugen.getInput(j);
                if (!(ui instanceof Constant)) continue;
                this.addConstant((Constant)ui);
            }
        }
    }

    private void topologicalSort() {
        List available = this.initTopoSort();
        this.ugens.clear();
        while (!available.isEmpty()) {
            UGenEnv env = (UGenEnv)available.remove(available.size() - 1);
            for (int i = env.collDe.size() - 1; i >= 0; --i) {
                UGenEnv env2 = (UGenEnv)env.collDe.get(i);
                env2.collAnte.remove(env);
                if (!env2.collAnte.isEmpty()) continue;
                available.add(env2);
            }
            this.ugens.add(env.ugen);
        }
    }

    private List initTopoSort() {
        UGenEnv env;
        UGen ugen;
        int i;
        int numUGens = this.ugens.size();
        ArrayList<UGenEnv> available = new ArrayList<UGenEnv>();
        HashMap<UGen, UGenEnv> mapEnv = new HashMap<UGen, UGenEnv>();
        UGenEnv[] envs = new UGenEnv[numUGens];
        for (i = 0; i < numUGens; ++i) {
            ugen = (UGen)this.ugens.get(i);
            env = new UGenEnv(ugen, i);
            mapEnv.put(ugen, env);
            envs[i] = env;
        }
        for (i = 0; i < numUGens; ++i) {
            env = envs[i];
            ugen = env.ugen;
            for (int j = 0; j < ugen.getNumInputs(); ++j) {
                UGenInput ui = ugen.getInput(j);
                if (!(ui instanceof UGenChannel)) continue;
                UGenEnv env2 = (UGenEnv)mapEnv.get(((UGenChannel)ui).getUGen());
                env.collAnte.add(env2);
                env2.collDe.add(env);
            }
        }
        for (i = numUGens - 1; i >= 0; --i) {
            env = envs[i];
            Collections.sort(env.collDe, synthIdxComp);
            if (!env.collAnte.isEmpty()) continue;
            available.add(env);
        }
        return available;
    }

    private byte[] asBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(1396926310);
        dos.writeInt(1);
        dos.writeShort(1);
        this.write(dos);
        dos.flush();
        dos.close();
        return baos.toByteArray();
    }

    public void send(Server server) throws IOException {
        server.sendMsg(this.recvMsg());
    }

    public void send(Server server, OSCMessage completionMsg) throws IOException {
        server.sendMsg(this.recvMsg(completionMsg));
    }

    public OSCMessage recvMsg() throws IOException {
        return this.recvMsg(null);
    }

    public OSCMessage recvMsg(OSCMessage completionMsg) throws IOException {
        Object[] args = completionMsg == null ? new Object[]{this.asBytes()} : new Object[]{this.asBytes(), completionMsg};
        return new OSCMessage("/d_recv", args);
    }

    public String getName() {
        return this.name;
    }

    public void load(Server s) throws IOException {
        this.load(s, null);
    }

    public void load(Server s, OSCMessage completionMsg) throws IOException {
        File f = File.createTempFile("tmp", SUFFIX);
        f.deleteOnExit();
        this.load(s, completionMsg, f);
    }

    public void load(Server s, OSCMessage completionMsg, File path) throws IOException {
        this.writeDefFile(path);
        Object[] args = completionMsg == null ? new Object[]{path} : new Object[]{path, completionMsg};
        s.sendMsg(new OSCMessage("/d_load", args));
    }

    public Synth play(Group target) throws IOException {
        return this.play(target, null, null);
    }

    public Synth play(Group target, String[] argNames, float[] argValues) throws IOException {
        return this.play(target, argNames, argValues, 0);
    }

    public Synth play(Node target, String[] argNames, float[] argValues, int addAction) throws IOException {
        Synth synth = Synth.basicNew(this.getName(), target.getServer());
        OSCMessage msg = synth.newMsg(target, argNames, argValues, addAction);
        this.send(target.getServer(), msg);
        return synth;
    }

    public void printOn(PrintStream out) {
        int i;
        out.println("SynthDef(\"" + this.getName() + "\")");
        if (this.ugens.size() > 0) {
            out.println("\n ugens:");
        }
        for (i = 0; i < this.ugens.size(); ++i) {
            UGenInput[] inputs;
            out.print("  #" + i + " : ");
            UGen ugen = (UGen)this.ugens.get(i);
            out.print(ugen.dumpName() + " @ " + ugen.getRate());
            if (ugen.getNumOutputs() != 1) {
                out.print(", numOuts: " + ugen.getNumOutputs());
            }
            if ((inputs = ugen.getInputs()).length > 0) {
                out.print(", arg: [ ");
                for (int j = 0; j < inputs.length; ++j) {
                    if (inputs[j] instanceof UGenChannel) {
                        UGenChannel uch = (UGenChannel)inputs[j];
                        out.print("#" + this.ugens.indexOf(uch.getUGen()) + '_');
                        if (uch.getUGen().getName().equals("Control")) {
                            out.print("Control(\"" + ((ControlDesc)this.controlDescs.get(uch.getUGen().getSpecialIndex() + uch.getChannel())).getName() + "\")");
                        } else {
                            out.print(uch.dumpName());
                        }
                    } else {
                        out.print(inputs[j].dumpName());
                    }
                    if (j >= inputs.length - 1) continue;
                    out.print(", ");
                }
                out.print(" ]");
            }
            out.println();
        }
        if (this.controlDescs.size() > 0) {
            out.println("\n controls:");
        }
        for (i = 0; i < this.controlDescs.size(); ++i) {
            out.print("  #" + i + " : ");
            ((ControlDesc)this.controlDescs.get(i)).printOn(out);
        }
    }

    public List getUGens() {
        return new ArrayList(this.ugens);
    }

    public static boolean isDefFile(File path) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(path));
        boolean result = dis.available() >= 10 && dis.readInt() == 1396926310;
        dis.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDefFile(File path, SynthDef[] defs) throws IOException {
        FileOutputStream os = new FileOutputStream(path);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
        try {
            dos.writeInt(1396926310);
            dos.writeInt(1);
            dos.writeShort(defs.length);
            for (int i = 0; i < defs.length; ++i) {
                defs[i].write(dos);
            }
        }
        finally {
            dos.close();
        }
    }

    public void writeDefFile(File path) throws IOException {
        SynthDef.writeDefFile(path, new SynthDef[]{this});
    }

    public void write(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
        this.write(dos);
        dos.flush();
    }

    private void write(DataOutputStream dos) throws IOException {
        ControlDesc desc;
        int i;
        SynthDef.writePascalString(dos, this.name);
        this.writeConstants(dos);
        dos.writeShort(this.controlDescs.size());
        for (i = 0; i < this.controlDescs.size(); ++i) {
            desc = (ControlDesc)this.controlDescs.get(i);
            dos.writeFloat(desc.getDefaultValue());
        }
        dos.writeShort(this.controlDescs.size());
        for (i = 0; i < this.controlDescs.size(); ++i) {
            desc = (ControlDesc)this.controlDescs.get(i);
            if (desc.getName() != null) {
                SynthDef.writePascalString(dos, desc.getName());
                dos.writeShort(i);
                continue;
            }
            System.err.println("Warning: unnamed control " + i + " dropped.");
        }
        dos.writeShort(this.ugens.size());
        for (i = 0; i < this.ugens.size(); ++i) {
            this.writeUGenSpec(dos, (UGen)this.ugens.get(i));
        }
        dos.writeShort(this.variants.size());
        if (!this.variants.isEmpty()) {
            throw new IllegalStateException("Variants : not supported!!");
        }
    }

    private void writeConstants(DataOutputStream dos) throws IOException {
        dos.writeShort(this.constants.size());
        for (int i = 0; i < this.constants.size(); ++i) {
            dos.writeFloat(((Constant)this.constants.get(i)).getValue());
        }
    }

    private int getRateID(Object rate) {
        for (int i = 0; i < RATES.length; ++i) {
            if (!rate.equals(RATES[i])) continue;
            return i;
        }
        return -1;
    }

    private void writeUGenSpec(DataOutputStream dos, UGen ugen) throws IOException {
        int i;
        UGenInput[] inputs = ugen.getInputs();
        Object[] outputRates = ugen.getOutputRates();
        SynthDef.writePascalString(dos, ugen.getName());
        dos.writeByte(this.getRateID(ugen.getRate()));
        dos.writeShort(ugen.getNumInputs());
        dos.writeShort(ugen.getNumOutputs());
        dos.writeShort(ugen.getSpecialIndex());
        for (i = 0; i < inputs.length; ++i) {
            this.writeInputSpec(dos, inputs[i]);
        }
        for (i = 0; i < outputRates.length; ++i) {
            dos.writeByte(this.getRateID(outputRates[i]));
        }
    }

    private void writeInputSpec(DataOutputStream dos, UGenInput inp) throws IOException {
        if (inp instanceof UGenChannel) {
            UGenChannel uch = (UGenChannel)inp;
            int synthIndex = this.ugens.indexOf(uch.getUGen());
            if (synthIndex == -1) {
                throw new IOException("UGen not listed in graph function : " + inp.dumpName());
            }
            dos.writeShort(synthIndex);
            dos.writeShort(uch.getChannel());
        } else if (inp instanceof Constant) {
            int constIndex = this.constants.indexOf(inp);
            if (constIndex == -1) {
                throw new IOException("Constant not listed in synth def : " + inp.dumpName());
            }
            dos.writeShort(-1);
            dos.writeShort(constIndex);
        } else {
            throw new IOException("Illegal UGen input class " + inp.getClass().getName());
        }
    }

    private static void writePascalString(DataOutputStream dos, String str) throws IOException {
        dos.writeByte(str.length());
        dos.write(str.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthDef[] readDefFile(URL path) throws IOException {
        InputStream is = path.openStream();
        try {
            SynthDef[] synthDefArray = SynthDef.readDefFile(is);
            return synthDefArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthDef[] readDefFile(File path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        try {
            SynthDef[] synthDefArray = SynthDef.readDefFile(is);
            return synthDefArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static SynthDef[] readDefFile(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        if (dis.readInt() != 1396926310) {
            throw new IOException("Not a SynthDef SCgf file");
        }
        int version = dis.readInt();
        if (version > 1) {
            throw new IOException("Unknown SynthDef file format version : " + version);
        }
        int numDefs = dis.readShort();
        SynthDef[] defs = new SynthDef[numDefs];
        for (int i = 0; i < numDefs; ++i) {
            defs[i] = SynthDef.read(dis);
        }
        return defs;
    }

    public static SynthDef read(InputStream is) throws IOException {
        return SynthDef.read(new DataInputStream(new BufferedInputStream(is)));
    }

    private static SynthDef read(DataInputStream dis) throws IOException {
        int i;
        SynthDef def = new SynthDef(SynthDef.readPascalString(dis));
        int numConstants = dis.readShort();
        Constant[] constants = new Constant[numConstants];
        for (i = 0; i < numConstants; ++i) {
            constants[i] = new Constant(dis.readFloat());
        }
        short numParams = dis.readShort();
        float[] controlDefaults = new float[numParams];
        ControlDesc[] controlDescs = new ControlDesc[numParams];
        for (i = 0; i < numParams; ++i) {
            controlDefaults[i] = dis.readFloat();
        }
        short numParamNames = dis.readShort();
        String[] paramName = new String[numParamNames];
        for (i = 0; i < numParamNames; ++i) {
            String str;
            paramName[dis.readShort()] = str = SynthDef.readPascalString(dis);
        }
        short numUGens = dis.readShort();
        for (i = 0; i < numUGens; ++i) {
            UGen ugen = SynthDef.readUGenSpec(dis, def, paramName, constants);
            def.addUGen(ugen);
            if (!ctrlUGensSet.contains(ugen.getName())) continue;
            int k = 0;
            int j = ugen.getSpecialIndex();
            while (k < ugen.getNumOutputs()) {
                controlDescs[j] = new ControlDesc(j < paramName.length ? paramName[j] : "?", ugen.getRate(), controlDefaults[j]);
                ++k;
                ++j;
            }
        }
        for (i = 0; i < controlDescs.length; ++i) {
            if (controlDescs[i] != null) {
                if (controlDescs[i].getName() != null) {
                    def.addControlDesc(controlDescs[i]);
                    continue;
                }
                System.err.println("Warning: unnamed control " + i + " (" + paramName[i] + ") dropped.");
                continue;
            }
            System.err.println("Warning: unreferenced control " + i + " (" + paramName[i] + ") dropped.");
        }
        for (i = 0; i < constants.length; ++i) {
            def.addConstant(constants[i]);
        }
        return def;
    }

    private static UGen readUGenSpec(DataInputStream dis, SynthDef def, String[] paramName, Constant[] constants) throws IOException {
        int i;
        String name = SynthDef.readPascalString(dis);
        Object rate = RATES[dis.readByte()];
        int numInputs = dis.readShort();
        short numOutputs = dis.readShort();
        short specialIndex = dis.readShort();
        Object[] outputRates = new Object[numOutputs];
        UGenInput[] ugenInputs = new UGenInput[numInputs];
        for (i = 0; i < numInputs; ++i) {
            short ugenIndex = dis.readShort();
            short outputIndex = dis.readShort();
            ugenInputs[i] = ugenIndex < 0 ? constants[outputIndex] : new UGenChannel((UGen)def.ugens.get(ugenIndex), outputIndex);
        }
        for (i = 0; i < numOutputs; ++i) {
            outputRates[i] = RATES[dis.readByte()];
        }
        UGen ugen = new UGen(name, rate, outputRates, ugenInputs, specialIndex);
        return ugen;
    }

    private static String readPascalString(DataInputStream dis) throws IOException {
        byte numChars = dis.readByte();
        byte[] buf = new byte[numChars];
        dis.readFully(buf);
        return new String(buf);
    }

    static {
        ctrlUGensSet.add("Control");
        ctrlUGensSet.add("TrigControl");
        ctrlUGensSet.add("LagControl");
    }

    private static class SynthIndexComparator
    implements Comparator {
        protected SynthIndexComparator() {
        }

        public int compare(Object env1, Object env2) {
            return ((UGenEnv)env1).synthIndex - ((UGenEnv)env2).synthIndex;
        }
    }

    private static class UGenEnv {
        protected final UGen ugen;
        protected final List collAnte;
        protected final List collDe;
        protected int synthIndex;

        protected UGenEnv(UGen ugen, int synthIndex) {
            this.ugen = ugen;
            this.synthIndex = synthIndex;
            this.collAnte = new ArrayList(ugen.getNumInputs());
            this.collDe = new ArrayList();
        }
    }
}

