/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Constant;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.GraphElemArray;
import de.sciss.jcollider.UGenChannel;
import de.sciss.jcollider.UGenInfo;
import de.sciss.jcollider.UGenInput;
import java.util.ArrayList;

public class UGen
implements Constants,
GraphElem {
    private final String name;
    private final Object rate;
    private final Object[] outputRates;
    private final UGenInput[] inputs;
    private int specialIndex;
    private static final GraphElem[] NO_ARGS = new GraphElem[0];

    protected UGen(String name, Object rate, Object[] outputRates, UGenInput[] inputs, int specialIndex) {
        this.name = name;
        this.rate = rate;
        this.outputRates = outputRates;
        this.inputs = inputs;
        this.specialIndex = specialIndex;
    }

    public Object getRate() {
        return this.rate;
    }

    public Object[] getOutputRates() {
        return this.outputRates;
    }

    public Object getOutputRate(int channel) {
        return this.outputRates[channel];
    }

    public UGenInput[] getInputs() {
        return this.inputs;
    }

    public UGenInput getInput(int index) {
        return this.inputs[index];
    }

    public int getSpecialIndex() {
        return this.specialIndex;
    }

    protected void setSpecialIndex(int idx) {
        this.specialIndex = idx;
    }

    public int getNumInputs() {
        return this.inputs.length;
    }

    public int getNumOutputs() {
        return this.outputRates.length;
    }

    public GraphElem getOutput(int idx) {
        return this.getChannel(idx);
    }

    public UGenInput[] asUGenInputs() {
        UGenInput[] result = new UGenInput[this.getNumOutputs()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getChannel(i);
        }
        return result;
    }

    public UGenChannel getChannel(int ch) {
        return new UGenChannel(this, ch);
    }

    public String getName() {
        return this.name;
    }

    public String dumpName() {
        if (this.specialIndex == 0) {
            return this.getName();
        }
        return this.getName() + '?' + this.specialIndex;
    }

    public static GraphElem ar(String name, int numChannels) {
        return UGen.construct(name, kAudioRate, numChannels, NO_ARGS);
    }

    public static GraphElem ar(String name) {
        return UGen.construct(name, kAudioRate, -1, NO_ARGS);
    }

    public static GraphElem ar(String name, int numChannels, GraphElem in1) {
        return UGen.construct(name, kAudioRate, numChannels, new GraphElem[]{in1});
    }

    public static GraphElem ar(String name, GraphElem in1) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1});
    }

    public static GraphElem ar(String name, int numChannels, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kAudioRate, numChannels, new GraphElem[]{in1, in2});
    }

    public static GraphElem ar(String name, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1, in2});
    }

    public static GraphElem ar(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kAudioRate, numChannels, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem ar(String name, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem ar(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kAudioRate, numChannels, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem ar(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem ar(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kAudioRate, numChannels, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem ar(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem ar(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5, GraphElem in6) {
        return UGen.construct(name, kAudioRate, -1, new GraphElem[]{in1, in2, in3, in4, in5, in6});
    }

    public static GraphElem kr(String name, int numChannels) {
        return UGen.construct(name, kControlRate, numChannels, NO_ARGS);
    }

    public static GraphElem kr(String name) {
        return UGen.construct(name, kControlRate, -1, NO_ARGS);
    }

    public static GraphElem kr(String name, int numChannels, GraphElem in1) {
        return UGen.construct(name, kControlRate, numChannels, new GraphElem[]{in1});
    }

    public static GraphElem kr(String name, GraphElem in1) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1});
    }

    public static GraphElem kr(String name, int numChannels, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kControlRate, numChannels, new GraphElem[]{in1, in2});
    }

    public static GraphElem kr(String name, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1, in2});
    }

    public static GraphElem kr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kControlRate, numChannels, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem kr(String name, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem kr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kControlRate, numChannels, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem kr(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem kr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kControlRate, numChannels, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem kr(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem kr(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5, GraphElem in6) {
        return UGen.construct(name, kControlRate, -1, new GraphElem[]{in1, in2, in3, in4, in5, in6});
    }

    public static GraphElem dr(String name, int numChannels) {
        return UGen.construct(name, kDemandRate, numChannels, NO_ARGS);
    }

    public static GraphElem dr(String name) {
        return UGen.construct(name, kDemandRate, -1, NO_ARGS);
    }

    public static GraphElem dr(String name, int numChannels, GraphElem in1) {
        return UGen.construct(name, kDemandRate, numChannels, new GraphElem[]{in1});
    }

    public static GraphElem dr(String name, GraphElem in1) {
        return UGen.construct(name, kDemandRate, -1, new GraphElem[]{in1});
    }

    public static GraphElem dr(String name, int numChannels, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kDemandRate, numChannels, new GraphElem[]{in1, in2});
    }

    public static GraphElem dr(String name, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kDemandRate, -1, new GraphElem[]{in1, in2});
    }

    public static GraphElem dr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kDemandRate, numChannels, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem dr(String name, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kDemandRate, -1, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem dr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kDemandRate, numChannels, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem dr(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kDemandRate, -1, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem dr(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kDemandRate, numChannels, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem dr(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kDemandRate, -1, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem ir(float value) {
        return new Constant(value);
    }

    public static GraphElem ir(String name, int numChannels) {
        return UGen.construct(name, kScalarRate, numChannels, NO_ARGS);
    }

    public static GraphElem ir(String name) {
        return UGen.construct(name, kScalarRate, -1, NO_ARGS);
    }

    public static GraphElem ir(String name, int numChannels, GraphElem in1) {
        return UGen.construct(name, kScalarRate, numChannels, new GraphElem[]{in1});
    }

    public static GraphElem ir(String name, GraphElem in1) {
        return UGen.construct(name, kScalarRate, -1, new GraphElem[]{in1});
    }

    public static GraphElem ir(String name, int numChannels, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kScalarRate, numChannels, new GraphElem[]{in1, in2});
    }

    public static GraphElem ir(String name, GraphElem in1, GraphElem in2) {
        return UGen.construct(name, kScalarRate, -1, new GraphElem[]{in1, in2});
    }

    public static GraphElem ir(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kScalarRate, numChannels, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem ir(String name, GraphElem in1, GraphElem in2, GraphElem in3) {
        return UGen.construct(name, kScalarRate, -1, new GraphElem[]{in1, in2, in3});
    }

    public static GraphElem ir(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kScalarRate, numChannels, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem ir(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4) {
        return UGen.construct(name, kScalarRate, -1, new GraphElem[]{in1, in2, in3, in4});
    }

    public static GraphElem ir(String name, int numChannels, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kScalarRate, numChannels, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    public static GraphElem ir(String name, GraphElem in1, GraphElem in2, GraphElem in3, GraphElem in4, GraphElem in5) {
        return UGen.construct(name, kScalarRate, -1, new GraphElem[]{in1, in2, in3, in4, in5});
    }

    private static GraphElem construct(String name, Object rate, int numChannels, GraphElem[] inputs) {
        Object o;
        int outChan;
        UGenInput[] ins;
        int i;
        ArrayList<UGenInput[]> args;
        boolean hasArray;
        UGenInfo ui = (UGenInfo)UGenInfo.infos.get(name);
        if (ui == null) {
            throw new IllegalArgumentException("Unknown UGen class " + name);
        }
        if (!ui.rates.contains(rate)) {
            throw new IllegalArgumentException(rate.toString() + " : illegal rate for UGen " + name);
        }
        int chanExp = 1;
        int numArgs = ui.args.length;
        int numIns = inputs.length;
        int specialIndex = 0;
        if (numArgs > 0 && ui.args[numArgs - 1].isArray) {
            hasArray = true;
            args = new ArrayList(--numArgs + inputs[--numIns].getNumOutputs());
        } else {
            hasArray = false;
            args = new ArrayList<UGenInput[]>(numArgs);
        }
        for (i = 0; i < numArgs && i < numIns; ++i) {
            ins = inputs[i].asUGenInputs();
            chanExp = Math.max(chanExp, ins.length);
            args.add(ins);
        }
        while (i < numArgs) {
            UGenInfo.Arg argInfo = ui.args[i];
            if (Float.isNaN(argInfo.def)) {
                throw new IllegalStateException("Missing argument " + argInfo.name + " for UGen " + name);
            }
            ins = new Constant(argInfo.def).asUGenInputs();
            args.add(ins);
            ++i;
        }
        if (hasArray) {
            GraphElem graph = inputs[numIns];
            for (i = 0; i < graph.getNumOutputs(); ++i) {
                ins = graph.getOutput(i).asUGenInputs();
                chanExp = Math.max(chanExp, ins.length);
                args.add(ins);
            }
        }
        if (ui.args.length < inputs.length) {
            System.err.println(name + ": Warning, illegal additional arguments (" + (inputs.length - numArgs) + ")");
        }
        if ((outChan = ui.getNumOutputs(numArgs = args.size(), numChannels)) == -1) {
            throw new IllegalArgumentException(name + " : numChannels need to be specified");
        }
        Object[] outRates = new Object[outChan];
        for (i = 0; i < outChan; ++i) {
            outRates[i] = rate;
        }
        GraphElem[] ugens = new GraphElem[chanExp];
        UGenInput[][] ugenIns = new UGenInput[chanExp][numArgs];
        for (i = 0; i < numArgs; ++i) {
            ins = (UGenInput[])args.get(i);
            for (int j = 0; j < chanExp; ++j) {
                ugenIns[j][i] = ins[j % ins.length];
            }
        }
        if (ui.specials != null && (o = ui.specials.get(name)) != null) {
            specialIndex = (Integer)o;
        }
        for (i = 0; i < chanExp; ++i) {
            ugens[i] = new UGen(ui.className, rate, outRates, ugenIns[i], specialIndex);
        }
        return chanExp == 1 ? ugens[0] : new GraphElemArray(ugens);
    }

    public static GraphElem array(GraphElem g1, GraphElem g2) {
        return new GraphElemArray(new GraphElem[]{g1, g2});
    }

    public static GraphElem array(GraphElem g1, GraphElem g2, GraphElem g3) {
        return new GraphElemArray(new GraphElem[]{g1, g2, g3});
    }

    public static GraphElem array(GraphElem g1, GraphElem g2, GraphElem g3, GraphElem g4) {
        return new GraphElemArray(new GraphElem[]{g1, g2, g3, g4});
    }

    public static GraphElem array(GraphElem g1, GraphElem g2, GraphElem g3, GraphElem g4, GraphElem g5) {
        return new GraphElemArray(new GraphElem[]{g1, g2, g3, g4, g5});
    }
}

