/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider;

import de.sciss.jcollider.Constants;
import de.sciss.jcollider.UGen;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UGenInfo
implements Constants,
Comparable {
    private static final String UGENDEFS_DTD = "ugendefs.dtd";
    private static final EntityResolver dtdResolver;
    private static final int BINARY_FILE_COOKIE = 1969710446;
    private static final int BINARY_FILE_VERSION = 0;
    public static Map infos;
    public static final int OUTPUT_FIXED = 0;
    public static final int OUTPUT_ARG = 1;
    public static final int OUTPUT_ARRAYSIZE = 2;
    public final String className;
    public final Arg[] args;
    public final Set rates;
    public final Map specials;
    public final int outputType;
    public final int outputVal;
    public final float outputMul;
    static final /* synthetic */ boolean $assertionsDisabled;

    private UGenInfo(String className, Arg[] args, Set rates, Map specials, int outputType, int outputVal, float outputMul) {
        this.className = className;
        this.args = args;
        this.rates = rates;
        this.specials = specials == null ? specials : Collections.unmodifiableMap(specials);
        this.outputType = outputType;
        this.outputVal = outputVal;
        this.outputMul = outputMul;
    }

    public int compareTo(Object o) {
        if (o instanceof UGenInfo) {
            return this.className.compareTo(((UGenInfo)o).className);
        }
        throw new ClassCastException();
    }

    public String getDisplayName(UGen ugen) {
        if (this.specials == null) {
            return this.className;
        }
        Integer specialIndex = new Integer(ugen.getSpecialIndex());
        Iterator iter = this.specials.keySet().iterator();
        while (iter.hasNext()) {
            String specialName = iter.next().toString();
            if (!this.specials.get(specialName).equals(specialIndex)) continue;
            return specialName;
        }
        return this.className;
    }

    public String getArgNameForInput(UGen ugen, int argIdx) {
        if (this.args.length == 0) {
            return null;
        }
        if (argIdx < this.args.length) {
            if (this.args[argIdx].isArray) {
                return this.args[argIdx].name + "[0]";
            }
            return this.args[argIdx].name;
        }
        if (this.args[this.args.length - 1].isArray) {
            return this.args[this.args.length - 1].name + '[' + (argIdx - this.args.length + 1) + ']';
        }
        return null;
    }

    public int getNumOutputs(int numArgs, int pre) {
        switch (this.outputType) {
            case 0: {
                return this.outputVal;
            }
            case 2: {
                return (int)((float)(numArgs - this.args.length + 1) * this.outputMul);
            }
            case 1: {
                if (pre == -1) {
                    return this.outputVal;
                }
                return pre;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(this.outputType);
        }
        return -1;
    }

    public void printOn(PrintStream out) {
        boolean b = false;
        out.print("UGenInfo(\"" + this.className + "\")\n rates: ");
        Iterator iter = this.rates.iterator();
        while (iter.hasNext()) {
            if (b) {
                out.print(", ");
            }
            out.print(iter.next());
            b = true;
        }
        out.print("\n args: [ ");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            if (this.args[i].isArray) {
                out.print("... ");
            }
            out.print(this.args[i].name);
            if (Float.isNaN(this.args[i].def)) continue;
            out.print(" = " + this.args[i].def);
        }
        out.println(" ]");
    }

    public static void readDefinitions() throws IOException {
        HashMap<String, UGenInfo> map = new HashMap<String, UGenInfo>();
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(dtdResolver);
            Document domDoc = builder.parse(ClassLoader.getSystemClassLoader().getResourceAsStream("ugendefs.xml"));
            Element node = domDoc.getDocumentElement();
            NodeList ugenList = node.getElementsByTagName("ugen");
            for (int i = 0; i < ugenList.getLength(); ++i) {
                Element elem = (Element)ugenList.item(i);
                UGenInfo info = UGenInfo.decodeUGenNode(domDoc, elem);
                map.put(info.className, info);
                if (info.specials == null) continue;
                Iterator iter = info.specials.keySet().iterator();
                while (iter.hasNext()) {
                    map.put((String)iter.next(), info);
                }
            }
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getClass().getName() + " : " + e1.getLocalizedMessage());
        }
        catch (SAXParseException e2) {
            throw new IOException(e2.getClass().getName() + " : " + e2.getLocalizedMessage());
        }
        catch (SAXException e3) {
            throw new IOException(e3.getClass().getName() + " : " + e3.getLocalizedMessage());
        }
        infos = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryDefinitions(File path) throws IOException {
        UGenInfo info;
        Map.Entry me;
        UGenInfo[] infos2 = new UGenInfo[infos.size()];
        if (path.exists() && !path.delete()) {
            throw new IOException("Could not overwrite " + path);
        }
        RandomAccessFile raf = new RandomAccessFile(path, "rw");
        int numInfos = 0;
        Iterator iter = infos.entrySet().iterator();
        while (iter.hasNext()) {
            me = iter.next();
            info = (UGenInfo)me.getValue();
            if (!me.getKey().equals(info.className)) continue;
            infos2[numInfos++] = info;
        }
        try {
            raf.writeInt(1969710446);
            raf.writeShort(0);
            raf.writeShort(numInfos);
            for (int i = 0; i < numInfos; ++i) {
                info = infos2[i];
                int iRates = 0;
                if (info.rates.contains(kScalarRate)) {
                    iRates |= 1;
                }
                if (info.rates.contains(kControlRate)) {
                    iRates |= 2;
                }
                if (info.rates.contains(kAudioRate)) {
                    iRates |= 4;
                }
                if (info.rates.contains(kDemandRate)) {
                    iRates |= 8;
                }
                raf.writeUTF(info.className);
                raf.writeByte(iRates);
                raf.writeByte(info.outputType);
                raf.writeShort(info.outputVal);
                raf.writeFloat(info.outputMul);
                raf.writeShort(info.args.length);
                for (int j = 0; j < info.args.length; ++j) {
                    raf.writeUTF(info.args[j].name);
                    raf.writeFloat(info.args[j].min);
                    raf.writeFloat(info.args[j].max);
                    raf.writeFloat(info.args[j].def);
                    int flags = 0;
                    if (info.args[j].isArray) {
                        flags |= 1;
                    }
                    raf.writeByte(flags);
                }
                int numSpecials = info.specials == null ? 0 : info.specials.size();
                raf.writeShort(numSpecials);
                if (numSpecials <= 0) continue;
                Iterator iter2 = info.specials.entrySet().iterator();
                while (iter2.hasNext()) {
                    me = iter2.next();
                    raf.writeUTF(me.getKey().toString());
                    raf.writeShort(((Number)me.getValue()).shortValue());
                }
            }
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readBinaryDefinitions() throws IOException {
        HashMap<String, UGenInfo> map;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(ClassLoader.getSystemClassLoader().getResourceAsStream("ugendefs.bin")));
        try {
            int i;
            if (dis.readInt() != 1969710446) {
                throw new IOException("Not a valid binary ugen file");
            }
            if (dis.readShort() > 0) {
                throw new IOException("Unsupport binary ugen file version");
            }
            int numInfos = dis.readShort();
            UGenInfo[] infos = new UGenInfo[numInfos];
            int mapSize = numInfos;
            for (i = 0; i < numInfos; ++i) {
                HashMap<String, Integer> specials;
                String name;
                int j;
                String className = dis.readUTF();
                byte iRates = dis.readByte();
                HashSet<Object> rates = new HashSet<Object>(4);
                if ((iRates & 1) != 0) {
                    rates.add(kScalarRate);
                }
                if ((iRates & 2) != 0) {
                    rates.add(kControlRate);
                }
                if ((iRates & 4) != 0) {
                    rates.add(kAudioRate);
                }
                if ((iRates & 8) != 0) {
                    rates.add(kDemandRate);
                }
                byte outputType = dis.readByte();
                short outputVal = dis.readShort();
                float outputMul = dis.readFloat();
                int numArgs = dis.readShort();
                Arg[] args = new Arg[numArgs];
                for (j = 0; j < numArgs; ++j) {
                    name = dis.readUTF();
                    float min = dis.readFloat();
                    float max = dis.readFloat();
                    float def = dis.readFloat();
                    byte flags = dis.readByte();
                    boolean isArray = (flags & 1) != 0;
                    args[j] = new Arg(name, min, max, def, isArray);
                }
                short numSpecials = dis.readShort();
                if (numSpecials > 0) {
                    specials = new HashMap<String, Integer>(numSpecials);
                    for (j = 0; j < numSpecials; ++j) {
                        name = dis.readUTF();
                        short specialValue = dis.readShort();
                        specials.put(name, new Integer(specialValue));
                    }
                } else {
                    specials = null;
                }
                infos[i] = new UGenInfo(className, args, rates, specials, outputType, outputVal, outputMul);
            }
            map = new HashMap<String, UGenInfo>(mapSize);
            for (i = 0; i < numInfos; ++i) {
                UGenInfo info = infos[i];
                map.put(info.className, info);
                if (info.specials == null) continue;
                Iterator iter = info.specials.keySet().iterator();
                while (iter.hasNext()) {
                    map.put((String)iter.next(), info);
                }
            }
        }
        finally {
            dis.close();
        }
        infos = map;
    }

    private static UGenInfo decodeUGenNode(Document domDoc, Element node) {
        HashMap<String, Integer> specials;
        String name;
        Element elem;
        int i;
        HashSet<Object> rates = new HashSet<Object>();
        String className = node.getAttribute("class");
        NodeList argList = node.getElementsByTagName("arg");
        NodeList outList = node.getElementsByTagName("outputs");
        NodeList specialList = node.getElementsByTagName("special");
        Arg[] args = new Arg[argList.getLength()];
        String val = node.getAttribute("rates");
        if (val.indexOf("audio") >= 0) {
            rates.add(kAudioRate);
        }
        if (val.indexOf("control") >= 0) {
            rates.add(kControlRate);
        }
        if (val.indexOf("scalar") >= 0) {
            rates.add(kScalarRate);
        }
        if (val.indexOf("demand") >= 0) {
            rates.add(kDemandRate);
        }
        for (i = 0; i < argList.getLength(); ++i) {
            elem = (Element)argList.item(i);
            name = elem.getAttribute("name");
            val = elem.getAttribute("type");
            boolean b = val.equals("array");
            if (b && i != argList.getLength() - 1) {
                throw new IllegalArgumentException(className + "(arg:" + name + ") : array not allowed here");
            }
            val = elem.getAttribute("def");
            float defaultValue = Float.NaN;
            if (val.length() > 0) {
                try {
                    defaultValue = Float.parseFloat(val);
                }
                catch (NumberFormatException e1) {
                    System.err.println(className + "(arg:" + name + ") : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                }
            }
            args[i] = new Arg(name, defaultValue, b);
        }
        int outputType = 0;
        int outputVal = -1;
        float outputMul = 1.0f;
        if (outList.getLength() > 0) {
            try {
                elem = (Element)outList.item(0);
                val = elem.getAttribute("type");
                if (val.length() > 0) {
                    if (val.equals("fixed")) {
                        outputType = 0;
                    } else if (val.equals("arg")) {
                        outputType = 1;
                    } else if (val.equals("arraySize")) {
                        outputType = 2;
                    }
                }
                if ((val = elem.getAttribute("val")).length() > 0) {
                    if (outputType == 2) {
                        for (i = 0; i < args.length; ++i) {
                            if (!args[i].name.equals(val)) continue;
                            outputVal = i;
                            break;
                        }
                        if (outputVal == -1) {
                            System.err.println(className + " (outputs) : illegal ref " + val);
                        }
                    } else {
                        outputVal = Integer.parseInt(val);
                    }
                }
                if ((val = elem.getAttribute("mul")).length() > 0) {
                    outputMul = Float.parseFloat(val);
                }
            }
            catch (NumberFormatException e1) {
                System.err.println(className + " (outputs) : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
            }
        }
        if (outputType == 0 && outputVal == -1) {
            outputVal = 1;
        }
        if (specialList.getLength() > 0) {
            specials = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < specialList.getLength(); ++i2) {
                elem = (Element)specialList.item(i2);
                name = elem.getAttribute("name");
                val = elem.getAttribute("idx");
                try {
                    int n = Integer.parseInt(val);
                    specials.put(name, new Integer(n));
                    continue;
                }
                catch (NumberFormatException e1) {
                    System.err.println(className + "(arg:" + name + ") : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                }
            }
        } else {
            specials = null;
        }
        return new UGenInfo(className, args, rates, specials, outputType, outputVal, outputMul);
    }

    static {
        $assertionsDisabled = !UGenInfo.class.desiredAssertionStatus();
        dtdResolver = new DTDResolver();
    }

    private static class DTDResolver
    implements EntityResolver {
        protected DTDResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (systemId.endsWith(UGenInfo.UGENDEFS_DTD)) {
                InputStream dtdStream = this.getClass().getClassLoader().getResourceAsStream(UGenInfo.UGENDEFS_DTD);
                InputSource is = new InputSource(dtdStream);
                is.setSystemId(UGenInfo.UGENDEFS_DTD);
                return is;
            }
            return null;
        }
    }

    public static class Arg {
        public final String name;
        public final float min;
        public final float max;
        public final float def;
        public final boolean isArray;

        protected Arg(String name, float min, float max, float def, boolean isArray) {
            this.name = name;
            this.min = min;
            this.max = max;
            this.def = def;
            this.isArray = isArray;
        }

        protected Arg(String name, float def, boolean isArray) {
            this(name, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, def, isArray);
        }
    }
}

