/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.gui.Warp;

public class ControlSpec {
    private final double minVal;
    private final double maxVal;
    private final double clipLo;
    private final double clipHi;
    private final double step;
    private final double defaultVal;
    private final String units;
    private final Warp warp;
    public static final ControlSpec defaultSpec = new ControlSpec();

    public ControlSpec() {
        this(0.0, 1.0);
    }

    public ControlSpec(double minVal, double maxVal) {
        this(minVal, maxVal, Warp.lin);
    }

    public ControlSpec(double minVal, double maxVal, Warp warp) {
        this(minVal, maxVal, warp, 0.0);
    }

    public ControlSpec(double minVal, double maxVal, Warp warp, double step) {
        this(minVal, maxVal, warp, step, minVal);
    }

    public ControlSpec(double minVal, double maxVal, Warp warp, double step, double defaultVal) {
        this(minVal, maxVal, warp, step, defaultVal, null);
    }

    public ControlSpec(double minVal, double maxVal, Warp warp, double step, double defaultVal, String units) {
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.warp = warp;
        this.step = step;
        this.defaultVal = defaultVal;
        this.units = units;
        this.clipLo = Math.min(minVal, maxVal);
        this.clipHi = Math.max(minVal, maxVal);
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public double getClipLo() {
        return this.clipLo;
    }

    public double getClipHi() {
        return this.clipHi;
    }

    public double getDefaultVal() {
        return this.defaultVal;
    }

    public double getStep() {
        return this.step;
    }

    public Warp getWarp() {
        return this.warp;
    }

    public String getUnits() {
        return this.units;
    }

    public double constrain(double value) {
        value = Math.max(this.clipLo, Math.min(this.clipHi, value));
        if (this.step == 0.0) {
            return value;
        }
        return (double)Math.round(value / this.step) * this.step;
    }

    public double getRange() {
        return this.maxVal - this.minVal;
    }

    public double getRatio() {
        return this.maxVal / this.minVal;
    }

    public double map(double value) {
        value = this.warp.map(Math.max(0.0, Math.min(1.0, value)), this);
        if (this.step == 0.0) {
            return value;
        }
        return (double)Math.round(value / this.step) * this.step;
    }

    public double unmap(double value) {
        if (this.step != 0.0) {
            value = (double)Math.round(value / this.step) * this.step;
        }
        return this.warp.unmap(Math.max(this.clipLo, Math.min(this.clipHi, value)), this);
    }
}

