/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.gui.ControlSpec;
import de.sciss.jcollider.gui.NumberEvent;
import de.sciss.jcollider.gui.NumberField;
import de.sciss.jcollider.gui.NumberListener;
import de.sciss.jcollider.gui.NumberSpace;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EZSlider
extends JComponent {
    private final Object sync = new Object();
    private ActionListener actionListener = null;
    protected ControlSpec spec;
    protected double value = 0.0;
    private final JLabel ggLabel;
    protected final JSlider ggSlider;
    protected final NumberField ggNumber;
    private final JLabel ggUnits;

    public EZSlider() {
        GridBagLayout lay = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        this.setLayout(lay);
        con.fill = 2;
        con.insets = new Insets(0, 2, 0, 2);
        this.setLayout(lay);
        this.ggLabel = new JLabel((String)null, 4);
        con.weightx = 0.0;
        lay.setConstraints(this.ggLabel, con);
        this.add(this.ggLabel);
        this.ggSlider = new JSlider(0, 65536);
        this.ggSlider.setMaximumSize(new Dimension(65536, this.ggSlider.getMaximumSize().height));
        con.weightx = 1.0;
        lay.setConstraints(this.ggSlider, con);
        this.add(this.ggSlider);
        this.ggNumber = new NumberField();
        con.weightx = 0.0;
        lay.setConstraints(this.ggNumber, con);
        this.add(this.ggNumber);
        this.ggUnits = new JLabel();
        lay.setConstraints(this.ggUnits, con);
        this.add(this.ggUnits);
        this.setControlSpec(ControlSpec.defaultSpec);
        this.ggNumber.addListener(new NumberListener(){

            public void numberChanged(NumberEvent e) {
                EZSlider.this.value = e.getNumber().doubleValue();
                EZSlider.this.ggSlider.setValue((int)(EZSlider.this.spec.unmap(EZSlider.this.value) * 65536.0));
                EZSlider.this.dispatchEvent();
            }
        });
        this.ggSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EZSlider.this.value = EZSlider.this.spec.map((double)EZSlider.this.ggSlider.getValue() / 65536.0);
                EZSlider.this.ggNumber.setNumber(new Double(EZSlider.this.value));
                EZSlider.this.dispatchEvent();
            }
        });
    }

    public static void align(EZSlider[] ez) {
        int i;
        int maxLabelWidth = 0;
        int maxNumberWidth = 0;
        int maxUnitsWidth = 0;
        for (i = 0; i < ez.length; ++i) {
            maxLabelWidth = Math.max(maxLabelWidth, ez[i].ggLabel.getPreferredSize().width);
            maxNumberWidth = Math.max(maxNumberWidth, ez[i].ggNumber.getPreferredSize().width);
            maxUnitsWidth = Math.max(maxUnitsWidth, ez[i].ggUnits.getPreferredSize().width);
        }
        for (i = 0; i < ez.length; ++i) {
            ez[i].setLabelWidth(maxLabelWidth);
            ez[i].setNumberWidth(maxNumberWidth);
            ez[i].setUnitsWidth(maxUnitsWidth);
        }
    }

    public void setLabelWidth(int width) {
        this.setComponentWidth(this.ggLabel, width);
    }

    public void setSliderWidth(int width) {
        this.setComponentWidth(this.ggSlider, width);
    }

    public void setNumberWidth(int width) {
        this.setComponentWidth(this.ggNumber, width);
        this.ggNumber.setColumns(0);
    }

    public void setUnitsWidth(int width) {
        this.setComponentWidth(this.ggUnits, width);
    }

    private void setComponentWidth(JComponent c, int width) {
        c.setSize(width, c.getHeight());
        c.setPreferredSize(new Dimension(width, c.getPreferredSize().height));
        c.setMinimumSize(new Dimension(width, c.getMinimumSize().height));
        c.setMaximumSize(new Dimension(width, c.getMaximumSize().height));
    }

    public void setLabel(String label) {
        this.ggLabel.setText(label);
    }

    public String getLabel() {
        return this.ggLabel.getText();
    }

    public void setControlSpec(ControlSpec spec) {
        this.spec = spec;
        this.ggNumber.setSpace(new NumberSpace(spec.getMinVal(), spec.getMaxVal(), spec.getStep()));
        this.ggUnits.setText(spec.getUnits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Object object = this.sync;
        synchronized (object) {
            this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Object object = this.sync;
        synchronized (object) {
            this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
        }
    }

    protected void dispatchEvent() {
        ActionListener l = this.actionListener;
        if (l != null) {
            l.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getUnmappedValue() {
        return this.spec.unmap(this.value);
    }

    public void setValue(double value) {
        this.value = this.spec.constrain(value);
        this.ggSlider.setValue((int)(this.spec.unmap(value) * 65536.0));
        this.ggNumber.setNumber(new Double(value));
    }

    public void setUnmappedValue(double value) {
        this.setValue(this.spec.map(value));
    }

    public void setValueAction(double value) {
        this.setValue(value);
        this.dispatchEvent();
    }
}

