/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogTextArea
extends JTextArea {
    protected final boolean useLogFile;
    protected final File logFile;
    private final PrintStream outStream;
    protected FileWriter logFileWriter = null;
    private int totalLength = 0;
    private AbstractAction actionClear = null;

    public LogTextArea(int rows, int columns, boolean useLogFile, File logFile) {
        super(rows, columns);
        this.useLogFile = useLogFile;
        this.logFile = logFile;
        this.outStream = new PrintStream(new RedirectedStream());
        this.setEditable(false);
        this.setLineWrap(true);
    }

    public LogTextArea() {
        this(6, 40, false, null);
    }

    public PrintStream getLogStream() {
        return this.outStream;
    }

    public void append(String str) {
        super.append(str);
        this.totalLength += str.length();
        this.updateCaret();
    }

    private void updateCaret() {
        try {
            this.setCaretPosition(Math.max(0, this.totalLength - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setText(String str) {
        super.setText(str);
        this.totalLength = str == null ? 0 : str.length();
    }

    public AbstractAction getClearAction() {
        if (this.actionClear == null) {
            this.actionClear = new ActionClear();
        }
        return this.actionClear;
    }

    public JScrollPane placeMeInAPane() {
        return new JScrollPane(this, 20, 31);
    }

    public void makeSystemOutput() {
        System.setOut(this.getLogStream());
        System.setErr(this.getLogStream());
    }

    private class ActionClear
    extends AbstractAction {
        protected ActionClear() {
        }

        public void actionPerformed(ActionEvent e) {
            LogTextArea.this.setText(null);
        }
    }

    private class RedirectedStream
    extends OutputStream {
        private byte[] cheesy = new byte[1];

        protected RedirectedStream() {
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String str = new String(b, off, len);
            LogTextArea.this.append(str);
            if (LogTextArea.this.useLogFile) {
                if (LogTextArea.this.logFileWriter == null) {
                    LogTextArea.this.logFileWriter = new FileWriter(LogTextArea.this.logFile);
                }
                LogTextArea.this.logFileWriter.write(str);
            }
        }

        public void flush() throws IOException {
            if (LogTextArea.this.logFileWriter != null) {
                LogTextArea.this.logFileWriter.flush();
            }
            super.flush();
        }

        public void close() throws IOException {
            if (LogTextArea.this.logFileWriter != null) {
                LogTextArea.this.logFileWriter.close();
                LogTextArea.this.logFileWriter = null;
            }
            super.close();
        }

        public void write(int b) throws IOException {
            this.cheesy[0] = (byte)b;
            this.write(this.cheesy);
        }
    }
}

