/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.Group;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.NodeEvent;
import de.sciss.jcollider.NodeListener;
import de.sciss.jcollider.NodeWatcher;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class NodeTreeManager
implements NodeListener {
    public boolean VERBOSE = false;
    private final DefaultTreeModel model;
    private final NodeWatcher nw;
    private final Map mapNodeBackups = new HashMap();

    public NodeTreeManager(NodeWatcher nw, Node rootNode) {
        this.nw = nw;
        this.model = new DefaultTreeModel(rootNode, true);
        nw.addListener(this);
        List collNodes = nw.getAllNodes();
        for (int i = 0; i < collNodes.size(); ++i) {
            Node node = (Node)collNodes.get(i);
            this.mapNodeBackups.put(new Integer(node.getNodeID()), node);
        }
    }

    public NodeTreeManager(NodeWatcher nw) {
        this(nw, null);
    }

    public void setRoot(Node rootNode) {
        this.model.setRoot(rootNode);
    }

    public void dispose() {
        this.mapNodeBackups.clear();
        this.setRoot(null);
        this.nw.removeListener(this);
    }

    public TreeModel getModel() {
        return this.model;
    }

    public static void dumpTree(PrintStream stream, TreeNode rootNode) {
        if (rootNode == null) {
            stream.println("Empty tree");
        } else {
            NodeTreeManager.dumpTree(stream, rootNode, 0);
        }
    }

    private static void dumpTree(PrintStream stream, TreeNode node, int nestCount) {
        for (int i = 0; i < nestCount; ++i) {
            stream.print("  ");
        }
        if (node.isLeaf()) {
            stream.println("- " + node.toString());
        } else {
            int childCount;
            stream.println(node.toString());
            if (++nestCount > 100) {
                stream.println("\nNest count exceeds 100, probably closed loop. Terminating");
            }
            Enumeration<? extends TreeNode> children = node.children();
            for (childCount = 0; children.hasMoreElements() && childCount < 300; ++childCount) {
                NodeTreeManager.dumpTree(stream, children.nextElement(), nestCount);
            }
            if (childCount == 300) {
                stream.println("\nChild count exceeds 300, probably closed loop. Terminating");
            }
        }
    }

    public void nodeAction(NodeEvent e) {
        Node node = e.getNode();
        if (node == null) {
            return;
        }
        Integer key = new Integer(e.getNodeID());
        switch (e.getID()) {
            case 0: {
                Group group = node.getGroup();
                if (group != null) {
                    int idx = group.getIndex(node);
                    if (this.VERBOSE) {
                        System.err.println("nodesWereInserted( " + group + ", { " + idx + " }, { " + node + " })");
                    }
                    this.model.nodesWereInserted(group, new int[]{idx});
                }
                this.mapNodeBackups.put(key, node);
                break;
            }
            case 1: {
                Group groupBak = (Group)this.mapNodeBackups.get(new Integer(e.getOldParentGroupID()));
                Node predBak = (Node)this.mapNodeBackups.get(new Integer(e.getOldPredNodeID()));
                if (groupBak != null) {
                    int idx;
                    int n = idx = predBak == null ? 0 : groupBak.getIndex(predBak) + 1;
                    if (this.VERBOSE) {
                        System.err.println("nodesWereRemoved( " + groupBak + ", { " + idx + " }, { " + node + " })");
                    }
                    this.model.nodesWereRemoved(groupBak, new int[]{idx}, new Object[]{node});
                }
                this.mapNodeBackups.remove(key);
                break;
            }
            case 2: 
            case 3: {
                if (this.VERBOSE) {
                    System.err.println("nodeChanged( " + node + ")");
                }
                this.model.nodeChanged(node);
                break;
            }
            case 4: {
                Group groupBak = (Group)this.mapNodeBackups.get(new Integer(e.getOldParentGroupID()));
                Group group = node.getGroup();
                if (group == null || groupBak == null) break;
                TreeNode[] oldPath = this.model.getPathToRoot(groupBak);
                TreeNode[] newPath = this.model.getPathToRoot(group);
                TreeNode commonParent = (TreeNode)this.model.getRoot();
                block7: for (int i = 0; i < oldPath.length; ++i) {
                    int nodeID = ((Node)oldPath[i]).getNodeID();
                    for (int j = 0; j < newPath.length; ++j) {
                        if (nodeID != ((Node)newPath[j]).getNodeID()) continue;
                        commonParent = oldPath[i];
                        break block7;
                    }
                }
                if (commonParent != null) {
                    if (this.VERBOSE) {
                        System.err.println("nodeStructureChanged( " + commonParent + ")");
                    }
                    this.model.nodeStructureChanged(commonParent);
                    break;
                }
                this.model.nodeStructureChanged((TreeNode)this.model.getRoot());
                break;
            }
            case 5: {
                Group group = node.getGroup();
                if (group != null) {
                    if (this.VERBOSE) {
                        System.err.println("nodeStructureChanged( " + group + ")");
                    }
                    this.model.nodeStructureChanged(group);
                }
                this.mapNodeBackups.put(key, node);
                break;
            }
        }
    }
}

