/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.Group;
import de.sciss.jcollider.Node;
import de.sciss.jcollider.NodeWatcher;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.gui.NodeTreeManager;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class NodeTreePanel
extends JPanel
implements TreeSelectionListener,
TreeModelListener {
    public static final int BUTTONS = 1;
    private final NodeTreeManager ntm;
    private final JTree ggTree;
    private final Node rootNode;
    protected boolean selectionContainsSynths = false;
    protected boolean selectionContainsGroups = false;
    protected boolean selectionContainsPlaying = false;
    protected boolean selectionContainsPausing = false;
    protected final List collSelectedNodes = new ArrayList();
    private ActionPauseResume actionPauseResume = null;
    private ActionFree actionFree = null;
    private ActionFreeAll actionFreeAll = null;
    private ActionDeepFree actionDeepFree = null;
    private ActionTrace actionTrace = null;

    public NodeTreePanel(NodeWatcher nw, Node rootNode, int flags) {
        super(new BorderLayout());
        this.rootNode = rootNode;
        this.ntm = new NodeTreeManager(nw, rootNode);
        this.ggTree = new JTree(this.ntm.getModel());
        this.ggTree.setShowsRootHandles(true);
        this.ggTree.setCellRenderer(new TreeNodeRenderer());
        this.ggTree.addTreeSelectionListener(this);
        this.ntm.getModel().addTreeModelListener(this);
        JScrollPane ggScroll = new JScrollPane(this.ggTree, 20, 31);
        this.add((Component)ggScroll, "Center");
        if ((flags & 1) != 0) {
            this.add((Component)this.createButtons(flags), "South");
        }
    }

    public NodeTreePanel(NodeWatcher nw, Node rootNode) {
        this(nw, rootNode, 1);
    }

    public NodeTreeManager getManager() {
        return this.ntm;
    }

    private JComponent createButtons(int flags) {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.actionPauseResume = new ActionPauseResume();
        JButton but = new JButton(this.actionPauseResume);
        tb.add(but);
        this.actionFree = new ActionFree();
        but = new JButton(this.actionFree);
        tb.add(but);
        this.actionFreeAll = new ActionFreeAll();
        but = new JButton(this.actionFreeAll);
        tb.add(but);
        this.actionDeepFree = new ActionDeepFree();
        but = new JButton(this.actionDeepFree);
        tb.add(but);
        this.actionTrace = new ActionTrace();
        but = new JButton(this.actionTrace);
        tb.add(but);
        return tb;
    }

    public void dispose() {
        this.ggTree.removeTreeSelectionListener(this);
        this.ntm.getModel().removeTreeModelListener(this);
        this.ntm.dispose();
    }

    public JFrame makeWindow() {
        JFrame f = new JFrame("[" + this.rootNode.getServer().getName() + "] tree for " + this.rootNode.toString());
        Container cp = f.getContentPane();
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                NodeTreePanel.this.dispose();
            }
        });
        cp.setLayout(new BorderLayout());
        cp.add((Component)this, "Center");
        f.pack();
        f.setVisible(true);
        f.toFront();
        return f;
    }

    private void updateActions() {
        TreePath[] sel = this.ggTree.getSelectionPaths();
        this.selectionContainsSynths = false;
        this.selectionContainsGroups = false;
        this.selectionContainsPlaying = false;
        this.selectionContainsPausing = false;
        this.collSelectedNodes.clear();
        if (sel != null) {
            for (int i = 0; i < sel.length; ++i) {
                Node node = (Node)sel[i].getLastPathComponent();
                this.collSelectedNodes.add(node);
                if (!this.selectionContainsSynths && node instanceof Synth) {
                    this.selectionContainsSynths = true;
                }
                if (!this.selectionContainsGroups && node instanceof Group) {
                    this.selectionContainsGroups = true;
                }
                if (!this.selectionContainsPlaying && node.isPlaying()) {
                    this.selectionContainsPlaying = true;
                }
                if (this.selectionContainsPausing || node.isPlaying()) continue;
                this.selectionContainsPausing = true;
            }
        }
        if (this.actionPauseResume != null) {
            this.actionPauseResume.update();
        }
        if (this.actionFree != null) {
            this.actionFree.update();
        }
        if (this.actionFreeAll != null) {
            this.actionFreeAll.update();
        }
        if (this.actionDeepFree != null) {
            this.actionDeepFree.update();
        }
        if (this.actionTrace != null) {
            this.actionTrace.update();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.updateActions();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.updateActions();
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.updateActions();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.updateActions();
    }

    private static class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final Color colrPlaying = Color.black;
        private static final Color colrPausing = new Color(144, 144, 144);
        private static final Color colrDied = new Color(144, 0, 48);

        protected TreeNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Node node = (Node)value;
            if (node.isRunning()) {
                if (node.isPlaying()) {
                    this.setForeground(colrPlaying);
                } else {
                    this.setForeground(colrPausing);
                }
            } else {
                this.setForeground(colrDied);
            }
            return this;
        }
    }

    private class ActionTrace
    extends NodeAction {
        protected ActionTrace() {
            super("Trace");
            this.setEnabled(false);
        }

        protected OSCMessage createMessage(Node node) {
            return node.traceMsg();
        }

        protected void update() {
            this.setEnabled(NodeTreePanel.this.selectionContainsSynths || NodeTreePanel.this.selectionContainsGroups);
        }
    }

    private class ActionDeepFree
    extends NodeAction {
        protected ActionDeepFree() {
            super("Deep Free");
            this.setEnabled(false);
        }

        protected OSCMessage createMessage(Node node) {
            if (node instanceof Group) {
                return ((Group)node).deepFreeMsg();
            }
            return null;
        }

        protected void update() {
            this.setEnabled(!NodeTreePanel.this.selectionContainsSynths && NodeTreePanel.this.selectionContainsGroups);
        }
    }

    private class ActionFreeAll
    extends NodeAction {
        protected ActionFreeAll() {
            super("Free All");
            this.setEnabled(false);
        }

        protected OSCMessage createMessage(Node node) {
            if (node instanceof Group) {
                return ((Group)node).freeAllMsg();
            }
            return null;
        }

        protected void update() {
            this.setEnabled(!NodeTreePanel.this.selectionContainsSynths && NodeTreePanel.this.selectionContainsGroups);
        }
    }

    private class ActionFree
    extends NodeAction {
        protected ActionFree() {
            super("Free");
            this.setEnabled(false);
        }

        protected OSCMessage createMessage(Node node) {
            return node.freeMsg();
        }

        protected void update() {
            this.setEnabled(NodeTreePanel.this.selectionContainsSynths || NodeTreePanel.this.selectionContainsGroups);
        }
    }

    private class ActionPauseResume
    extends NodeAction {
        private static final String NAME_PAUSE = "Pause";
        private static final String NAME_RESUME = "Resume";
        private boolean runFlag;

        protected ActionPauseResume() {
            super(NAME_PAUSE);
            this.runFlag = false;
            this.setEnabled(false);
        }

        protected OSCMessage createMessage(Node node) {
            return node.runMsg(this.runFlag);
        }

        protected void update() {
            this.runFlag = NodeTreePanel.this.selectionContainsPausing;
            this.setEnabled((NodeTreePanel.this.selectionContainsSynths || NodeTreePanel.this.selectionContainsGroups) && NodeTreePanel.this.selectionContainsPlaying != NodeTreePanel.this.selectionContainsPausing);
            this.putValue("Name", this.runFlag ? NAME_RESUME : NAME_PAUSE);
        }
    }

    private abstract class NodeAction
    extends AbstractAction {
        protected NodeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Server server;
            HashMap<Server, OSCBundle> mapServersToBundles = new HashMap<Server, OSCBundle>();
            for (int i = 0; i < NodeTreePanel.this.collSelectedNodes.size(); ++i) {
                Node node = (Node)NodeTreePanel.this.collSelectedNodes.get(i);
                OSCMessage msg = this.createMessage(node);
                if (msg == null) continue;
                server = node.getServer();
                OSCBundle bndl = (OSCBundle)mapServersToBundles.get(server);
                if (bndl == null) {
                    bndl = new OSCBundle();
                    mapServersToBundles.put(server, bndl);
                }
                bndl.addPacket((OSCPacket)msg);
            }
            Iterator iter = mapServersToBundles.keySet().iterator();
            while (iter.hasNext()) {
                server = (Server)iter.next();
                try {
                    server.sendBundle((OSCBundle)mapServersToBundles.get(server));
                }
                catch (IOException e1) {
                    System.err.println(e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                }
            }
        }

        protected abstract OSCMessage createMessage(Node var1);

        protected abstract void update();
    }
}

