/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.jcollider.gui.NumberEvent;
import de.sciss.jcollider.gui.NumberListener;
import de.sciss.jcollider.gui.NumberSpace;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberField
extends JFormattedTextField
implements EventManager.Processor {
    private static final double LN10;
    public static final int HHMMSS = 131072;
    private NumberSpace space;
    protected Number value;
    private NumberFormat numberFormat;
    private int flags;
    private EventManager em = null;
    private final DefaultFormatterFactory factory = new DefaultFormatterFactory();
    private final NumberFormatter numberFormatter = new NumberFormatter();
    protected final NumberField enc_this = this;
    private final AbstractAction actionLooseFocus;
    protected static final DataFlavor numberFlavor;
    protected static final DataFlavor[] supportedFlavors;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NumberField() {
        ActionMap amap = this.getActionMap();
        InputMap imap = this.getInputMap();
        int msh = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.setFormatterFactory(this.factory);
        this.setHorizontalAlignment(4);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Number newVal = (Number)NumberField.this.getValue();
                if (newVal.equals(NumberField.this.value)) {
                    NumberField.this.value = newVal;
                    NumberField.this.fireNumberChanged();
                }
            }
        });
        this.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Number newVal = (Number)NumberField.this.getValue();
                if (!newVal.equals(NumberField.this.value)) {
                    NumberField.this.value = newVal;
                    NumberField.this.fireNumberChanged();
                }
            }
        });
        this.actionLooseFocus = new ActionLooseFocus();
        Object key = "lost";
        imap.put(KeyStroke.getKeyStroke(27, 0), key);
        amap.put(key, this.actionLooseFocus);
        Action action = TransferHandler.getCopyAction();
        key = action.getValue("Name");
        imap.put(KeyStroke.getKeyStroke(67, msh), key);
        amap.put(key, action);
        action = TransferHandler.getPasteAction();
        key = action.getValue("Name");
        imap.put(KeyStroke.getKeyStroke(86, msh), key);
        amap.put(key, action);
        this.setTransferHandler(new NumberTransferHandler());
    }

    public NumberField(NumberSpace space) {
        this();
        this.setSpace(space);
    }

    public void setSpace(NumberSpace space) {
        if (!space.equals(this.space)) {
            this.space = space;
            this.updateFormatter();
        }
    }

    public void setFlags(int newFlags) {
        int change = this.flags ^ newFlags;
        this.flags = newFlags;
        if ((change & 0x20000) != 0) {
            this.updateFormatter();
        }
    }

    public int getFlags() {
        return this.flags;
    }

    private void updateFormatter() {
        int i;
        if (this.space.isInteger()) {
            this.numberFormat = NumberFormat.getIntegerInstance(Locale.US);
        } else {
            this.numberFormat = NumberFormat.getInstance(Locale.US);
            i = Math.min(8, this.space.maxFracDigits);
            this.numberFormat.setMinimumFractionDigits(this.space.minFracDigits);
            this.numberFormat.setMaximumFractionDigits(i);
        }
        if (Double.isInfinite(this.space.min) || Double.isInfinite(this.space.max)) {
            this.numberFormat.setMaximumIntegerDigits(8);
        } else {
            double d = Math.max(1.0, Math.floor(Math.abs(this.space.min)) + 0.1);
            i = (int)(Math.log(d) / LN10) + 1;
            d = Math.max(1.0, Math.floor(Math.abs(this.space.max)) + 0.1);
            i = Math.max(i, (int)(Math.log(d) / LN10) + 1);
            this.numberFormat.setMaximumIntegerDigits(i);
        }
        i = 1;
        this.setColumns(i += Math.min(4, this.numberFormat.getMaximumFractionDigits()) + this.numberFormat.getMaximumIntegerDigits());
        if (this.value == null) {
            this.value = this.space.isInteger() ? (Number)new Long((long)(this.space.reset + 0.5)) : (Number)new Double(this.space.reset);
        }
        this.numberFormat.setGroupingUsed(false);
        this.numberFormatter.setFormat(this.numberFormat);
        if (this.space.isInteger()) {
            this.numberFormatter.setValueClass(Long.class);
            if (!Double.isInfinite(this.space.min)) {
                this.numberFormatter.setMinimum(new Long((long)this.space.min));
            }
            if (!Double.isInfinite(this.space.max)) {
                this.numberFormatter.setMaximum(new Long((long)this.space.max));
            }
        } else {
            this.numberFormatter.setValueClass(Double.class);
            if (!Double.isInfinite(this.space.min)) {
                this.numberFormatter.setMinimum(new Double(this.space.min));
            }
            if (!Double.isInfinite(this.space.max)) {
                this.numberFormatter.setMaximum(new Double(this.space.max));
            }
        }
        this.factory.setDefaultFormatter(this.numberFormatter);
        this.setValue(this.value);
    }

    public Number getNumber() {
        return this.value;
    }

    public void setNumber(Number value) {
        this.value = value;
        this.setValue(value);
    }

    public NumberSpace getSpace() {
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NumberListener listener) {
        NumberField numberField = this;
        synchronized (numberField) {
            if (this.em == null) {
                this.em = new EventManager(this);
            }
            this.em.addListener(listener);
        }
    }

    public void removeListener(NumberListener listener) {
        if (this.em != null) {
            this.em.removeListener(listener);
        }
    }

    public void processEvent(BasicEvent e) {
        block3: for (int i = 0; i < this.em.countListeners(); ++i) {
            NumberListener listener = (NumberListener)this.em.getListener(i);
            switch (e.getID()) {
                case 0: {
                    listener.numberChanged((NumberEvent)e);
                    continue block3;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(e.getID());
                    }
                    continue block3;
                }
            }
        }
    }

    protected void fireNumberChanged() {
        if (this.em != null) {
            this.em.dispatchEvent(new NumberEvent(this, 0, System.currentTimeMillis(), this.value, false));
        }
    }

    static {
        $assertionsDisabled = !NumberField.class.desiredAssertionStatus();
        LN10 = Math.log(10.0);
        numberFlavor = new DataFlavor(Number.class, Number.class.getName());
        supportedFlavors = new DataFlavor[]{numberFlavor, DataFlavor.stringFlavor};
    }

    private static class NumberTransferable
    implements Transferable {
        private final Number n;
        private final JFormattedTextField.AbstractFormatter f;

        protected NumberTransferable(Number n, JFormattedTextField.AbstractFormatter f) {
            this.n = n;
            this.f = f;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < supportedFlavors.length; ++i) {
                if (!supportedFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.n == null) {
                throw new IOException();
            }
            if (flavor.equals(numberFlavor)) {
                return this.n;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                try {
                    return this.f.valueToString(this.n);
                }
                catch (ParseException e1) {
                    throw new IOException(e1.getLocalizedMessage());
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class NumberTransferHandler
    extends TransferHandler {
        protected NumberTransferHandler() {
        }

        public boolean importData(JComponent c, Transferable t) {
            Number n = null;
            try {
                if (t.isDataFlavorSupported(numberFlavor)) {
                    n = (Number)t.getTransferData(numberFlavor);
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    n = (Number)NumberField.this.getFormatter().stringToValue((String)t.getTransferData(DataFlavor.stringFlavor));
                }
                if (n != null) {
                    NumberField.this.setNumber(n);
                    NumberField.this.fireNumberChanged();
                    return true;
                }
            }
            catch (UnsupportedFlavorException e1) {
            }
            catch (IOException e2) {
            }
            catch (ParseException e3) {
                // empty catch block
            }
            return false;
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        protected Transferable createTransferable(JComponent c) {
            return new NumberTransferable(NumberField.this.getNumber(), NumberField.this.getFormatter());
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                for (int j = 0; j < supportedFlavors.length; ++j) {
                    if (!flavors[i].equals(supportedFlavors[j])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class ActionLooseFocus
    extends AbstractAction {
        protected ActionLooseFocus() {
        }

        public void actionPerformed(ActionEvent e) {
            JRootPane rp = SwingUtilities.getRootPane(NumberField.this.enc_this);
            if (rp != null) {
                rp.requestFocus();
            }
        }
    }
}

