/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

public class NumberSpace {
    public final double min;
    public final double max;
    public final double quant;
    public final double reset;
    public final int minFracDigits;
    public final int maxFracDigits;
    public static NumberSpace genericDoubleSpace = new NumberSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
    public static NumberSpace genericIntSpace = new NumberSpace(-2.147483648E9, 2.147483647E9, 1.0);
    private final boolean isInteger;

    public NumberSpace(double min, double max, double quant, int minFracDigits, int maxFracDigits, double reset) {
        this.min = min;
        this.max = max;
        this.quant = quant;
        this.reset = reset;
        this.minFracDigits = minFracDigits;
        this.maxFracDigits = maxFracDigits;
        this.isInteger = quant > 0.0 && quant % 1.0 == 0.0;
    }

    public NumberSpace(double min, double max, double quant, int minFracDigits, int maxFracDigits) {
        this(min, max, quant, minFracDigits, maxFracDigits, NumberSpace.fitValue(0.0, min, max, quant));
    }

    public NumberSpace(double min, double max, double quant) {
        this(min, max, quant, Math.max(1, NumberSpace.fracDigitsFromQuant(quant)), Math.min(2, NumberSpace.fracDigitsFromQuant(quant)));
    }

    public static int fracDigitsFromQuant(double quant) {
        if (quant > 0.0) {
            int maxFracDigits = 0;
            while (quant % 1.0 != 0.0) {
                ++maxFracDigits;
                quant *= 10.0;
            }
            return maxFracDigits;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public static NumberSpace createIntSpace(int min, int max) {
        return new NumberSpace(min, max, 1.0);
    }

    public double fitValue(double value) {
        if (this.quant > 0.0) {
            value = (double)Math.round(value / this.quant) * this.quant;
        }
        return Math.min(this.max, Math.max(this.min, value));
    }

    public static double fitValue(double value, double min, double max, double quant) {
        if (quant > 0.0) {
            value = (double)Math.round(value / quant) * quant;
        }
        return Math.min(max, Math.max(min, value));
    }
}

