/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.Constants;
import de.sciss.jcollider.JCollider;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.ServerEvent;
import de.sciss.jcollider.ServerListener;
import de.sciss.jcollider.gui.LogTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ServerPanel
extends JPanel
implements ServerListener,
Constants {
    public static Font fntConsole;
    public static Font fntGUI;
    public static Font fntBigName;
    public static final int CONSOLE = 1;
    public static final int BOOTQUIT = 2;
    public static final int BIGNAME = 8;
    public static final int COUNTS = 64;
    public static final int DUMP = 128;
    public static final int MIMIC = 126;
    private static final int BUTTONS = 190;
    protected final Server server;
    protected final ServerPanel enc_this = this;
    private JTextField lbBigName = null;
    private ActionBoot actionBoot = null;
    private JFrame ourFrame;
    private JScrollPane ggScroll;
    private boolean showHide;
    private JLabel lbCntAvgCPU;
    private JLabel lbCntPeakCPU;
    private JLabel lbCntUGens;
    private JLabel lbCntSynths;
    private JLabel lbCntGroups;
    private JLabel lbCntSynthDefs;
    private static final String COUNT_NA = "?";
    private static final MessageFormat msgCntPercent;
    private static final Color colrRunning;
    private static final Color colrBooting;
    private static final Color colrStopped;

    public ServerPanel(Server server, int flags) {
        this.server = server;
        BoxLayout lay = new BoxLayout(this, 1);
        this.setLayout(lay);
        if ((flags & 1) != 0) {
            this.add(this.createConsole());
        }
        if ((flags & 0xBE) != 0) {
            this.add(this.createButtons(flags));
        }
        if ((flags & 0x40) != 0) {
            this.add(this.createCountsPanel());
        }
        server.addListener(this);
    }

    public void dispose() {
        this.server.removeListener(this);
    }

    private JComponent createConsole() {
        LogTextArea lta = new LogTextArea(12, 40, false, null);
        InputMap imap = lta.getInputMap();
        ActionMap amap = lta.getActionMap();
        imap.put(KeyStroke.getKeyStroke(127, 0), "clear");
        amap.put("clear", lta.getClearAction());
        lta.setFont(fntConsole);
        Server.setPrintStream(lta.getLogStream());
        this.ggScroll = lta.placeMeInAPane();
        return this.ggScroll;
    }

    private JComponent createCountsPanel() {
        JPanel p = new JPanel(new GridLayout(3, 4, 0, 4));
        this.lbCntAvgCPU = new JLabel();
        this.lbCntPeakCPU = new JLabel();
        this.lbCntUGens = new JLabel();
        this.lbCntSynths = new JLabel();
        this.lbCntGroups = new JLabel();
        this.lbCntSynthDefs = new JLabel();
        p.add(new JLabel(JCollider.getResourceString("countsAvgCPU") + " : ", 4));
        p.add(this.lbCntAvgCPU);
        p.add(new JLabel(JCollider.getResourceString("countsPeakCPU") + " : ", 4));
        p.add(this.lbCntPeakCPU);
        p.add(new JLabel(JCollider.getResourceString("countsUGens") + " : ", 4));
        p.add(this.lbCntUGens);
        p.add(new JLabel(JCollider.getResourceString("countsSynths") + " : ", 4));
        p.add(this.lbCntSynths);
        p.add(new JLabel(JCollider.getResourceString("countsGroups") + " : ", 4));
        p.add(this.lbCntGroups);
        p.add(new JLabel(JCollider.getResourceString("countsSynthDefs") + " : ", 4));
        p.add(this.lbCntSynthDefs);
        p.setBorder(BorderFactory.createEmptyBorder(2, 8, 8, 8));
        JCollider.setDeepFont(p, fntGUI);
        p.setMaximumSize(p.getPreferredSize());
        this.updateCounts();
        return p;
    }

    private JComponent createButtons(int flags) {
        Insets insets;
        AbstractButton but;
        JToolBar tb = new JToolBar();
        tb.setBorderPainted(false);
        tb.setFloatable(false);
        if ((flags & 2) != 0) {
            this.actionBoot = new ActionBoot();
            but = new JButton(this.actionBoot);
            but.setFont(fntGUI);
            insets = but.getMargin();
            but.setMargin(new Insets(insets.top + 2, insets.left + 4, insets.bottom + 2, insets.right + 4));
            tb.add(but);
        }
        if ((flags & 8) != 0) {
            this.lbBigName = new JTextField(8);
            this.lbBigName.setFont(fntBigName);
            this.lbBigName.setMaximumSize(this.lbBigName.getPreferredSize());
            this.lbBigName.setText(this.server.getName());
            this.lbBigName.setEditable(false);
            this.lbBigName.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.lbBigName.setBackground(Color.black);
            this.lbBigName.setHorizontalAlignment(0);
            this.updateBigName();
            tb.add(this.lbBigName);
        }
        if ((flags & 0x80) != 0) {
            but = new JToggleButton(new ActionDump());
            but.setFont(fntGUI);
            insets = but.getMargin();
            but.setMargin(new Insets(insets.top + 2, insets.left + 4, insets.bottom + 2, insets.right + 4));
            tb.add(but);
        }
        return tb;
    }

    protected void updateBigName() {
        if (this.lbBigName == null) {
            return;
        }
        if (this.server.isRunning()) {
            this.lbBigName.setForeground(colrRunning);
        } else if (this.server.isBooting()) {
            this.lbBigName.setForeground(colrBooting);
        } else {
            this.lbBigName.setForeground(colrStopped);
        }
    }

    private void updateCounts() {
        if (this.lbCntAvgCPU == null) {
            return;
        }
        if (this.server.isRunning()) {
            Server.Status status = this.server.getStatus();
            Float[] cntArgs = new Float[]{new Float(status.avgCPU)};
            this.lbCntAvgCPU.setText(msgCntPercent.format(cntArgs));
            cntArgs[0] = new Float(status.peakCPU);
            this.lbCntPeakCPU.setText(msgCntPercent.format(cntArgs));
            this.lbCntUGens.setText(String.valueOf(status.numUGens));
            this.lbCntSynths.setText(String.valueOf(status.numSynths));
            this.lbCntGroups.setText(String.valueOf(status.numGroups));
            this.lbCntSynthDefs.setText(String.valueOf(status.numSynthDefs));
        } else {
            this.lbCntAvgCPU.setText(COUNT_NA);
            this.lbCntPeakCPU.setText(COUNT_NA);
            this.lbCntUGens.setText(COUNT_NA);
            this.lbCntSynths.setText(COUNT_NA);
            this.lbCntGroups.setText(COUNT_NA);
            this.lbCntSynthDefs.setText(COUNT_NA);
        }
    }

    protected void showHideConsole(boolean show) {
        if (this.ourFrame == null || this.showHide == show) {
            return;
        }
        this.showHide = show;
        this.ggScroll.setVisible(show);
        this.ourFrame.pack();
    }

    public static JFrame makeWindow(Server server) {
        return ServerPanel.makeWindow(server, 126);
    }

    public static JFrame makeWindow(Server server, int flags) {
        ServerPanel sp = new ServerPanel(server, flags);
        JFrame f = new JFrame(server.getName() + " server");
        Container cp = f.getContentPane();
        sp.ourFrame = f;
        if (sp.ggScroll != null) {
            sp.ggScroll.setVisible(false);
        }
        f.setDefaultCloseOperation(0);
        cp.setLayout(new BorderLayout());
        cp.add((Component)sp, "Center");
        f.pack();
        f.setVisible(true);
        f.toFront();
        return f;
    }

    public void serverAction(ServerEvent e) {
        switch (e.getID()) {
            case 0: {
                if (this.actionBoot != null) {
                    this.actionBoot.booted();
                }
                this.updateBigName();
                break;
            }
            case 1: {
                if (this.actionBoot != null) {
                    this.actionBoot.terminated();
                }
                this.updateBigName();
                this.updateCounts();
                break;
            }
            case 2: {
                this.updateCounts();
                break;
            }
        }
    }

    static {
        fntGUI = new Font("Helvetica", 0, 12);
        fntBigName = new Font("Helvetica", 1, 16);
        msgCntPercent = new MessageFormat("{0,number,#.#} %", Locale.US);
        colrRunning = new Color(88, 176, 141);
        colrBooting = new Color(204, 255, 51);
        colrStopped = new Color(96, 96, 96);
        fntConsole = JCollider.isMacOS ? new Font("Monaco", 0, 10) : new Font("Monospaced", 0, 11);
    }

    private class ActionDump
    extends AbstractAction {
        private boolean dumping;

        protected ActionDump() {
            super(JCollider.getResourceString("buttonDumpOSC"));
            this.dumping = ServerPanel.this.server.getDumpMode() != 0;
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            this.dumping = b.isSelected();
            try {
                ServerPanel.this.server.dumpOSC(this.dumping ? 1 : 0);
            }
            catch (IOException e1) {
                JCollider.displayError(ServerPanel.this.enc_this, e1, this.getValue("Name").toString());
            }
        }
    }

    private class ActionBoot
    extends AbstractAction {
        private boolean booted;

        protected ActionBoot() {
            super(JCollider.getResourceString("buttonBoot"));
            this.booted = ServerPanel.this.server.isRunning() || ServerPanel.this.server.isBooting();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.booted) {
                    ServerPanel.this.server.quit();
                } else {
                    ServerPanel.this.server.boot();
                    ServerPanel.this.updateBigName();
                    ServerPanel.this.showHideConsole(true);
                }
            }
            catch (IOException e1) {
                JCollider.displayError(ServerPanel.this.enc_this, e1, this.getValue("Name").toString());
            }
        }

        protected void terminated() {
            this.booted = false;
            this.putValue("Name", JCollider.getResourceString("buttonBoot"));
            ServerPanel.this.showHideConsole(false);
        }

        protected void booted() {
            this.booted = true;
            this.putValue("Name", JCollider.getResourceString("buttonQuit"));
        }
    }
}

