/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.Constant;
import de.sciss.jcollider.Constants;
import de.sciss.jcollider.SynthDef;
import de.sciss.jcollider.UGen;
import de.sciss.jcollider.UGenChannel;
import de.sciss.jcollider.UGenInfo;
import de.sciss.jcollider.UGenInput;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SynthDefDiagram
extends JFrame {
    private final Font fntGUI = new Font("SansSerif", 0, 10);
    private static final String[] ZOOMS = new String[]{"800%", "400%", "200%", "150%", "125%", "100%", "75%", "50%", "25%", "12.5%"};
    protected static final NumberFormat frmtZoom = NumberFormat.getPercentInstance(Locale.US);
    protected static final Font fntUGen = new Font("Lucida Grande", 0, 10);
    protected static final Font fntToolTip = new Font("Gill Sans", 2, 12);
    private static final NumberFormat frmtConst = NumberFormat.getInstance(Locale.US);

    public SynthDefDiagram(SynthDef def) {
        super("SynthDef(\"" + def.getName() + "\")");
        Container cp = this.getContentPane();
        final SynthDefView synthDefView = new SynthDefView(def);
        JScrollPane scroll = new JScrollPane(synthDefView);
        Box box = Box.createHorizontalBox();
        final JComboBox<String> ggZoom = new JComboBox<String>();
        for (int i = 0; i < ZOOMS.length; ++i) {
            ggZoom.addItem(ZOOMS[i]);
        }
        ggZoom.setSelectedIndex(5);
        ggZoom.setEditable(true);
        ggZoom.setFont(this.fntGUI);
        ggZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = ggZoom.getSelectedItem().toString();
                Number num = null;
                try {
                    num = frmtZoom.parse(text);
                }
                catch (ParseException e1) {
                    // empty catch block
                }
                if (num != null) {
                    synthDefView.setZoom(num.doubleValue());
                } else {
                    ggZoom.setSelectedItem(frmtZoom.format(synthDefView.getZoom()));
                }
            }
        });
        box.add(ggZoom);
        box.add(Box.createHorizontalGlue());
        cp.setLayout(new BorderLayout());
        cp.add((Component)scroll, "Center");
        cp.add((Component)box, "South");
        this.setSize(320, 320);
        this.setVisible(true);
        this.toFront();
    }

    protected static String formatConst(float value) {
        if (value == (float)Math.round(value)) {
            return String.valueOf(Math.round(value));
        }
        return frmtConst.format(new Float(value));
    }

    static {
        frmtConst.setGroupingUsed(false);
        frmtConst.setMaximumFractionDigits(4);
    }

    private static class PositionedString {
        protected final String str;
        protected final double x;
        protected final double y;

        protected PositionedString(String str, double x, double y) {
            this.str = str;
            this.x = x;
            this.y = y;
        }
    }

    private static class UGenView
    implements Constants {
        private final UGen ugen;
        private final Shape shpContainer;
        private final Shape shpCons;
        private final Shape shpConsts;
        private final Shape shpToolTips;
        private final List collConsts = new ArrayList();
        private final List collConstBounds = new ArrayList();
        private final List collToolTips = new ArrayList();
        private final Rectangle2D bounds;
        private static final Stroke strkCons = new BasicStroke(2.0f);
        private static final Paint pntConst = new Color(0, 0, 0, 192);
        private static final Paint pntConstD = new Color(0, 0, 0, 96);
        private static final Paint pntToolTips = new Color(255, 255, 0, 176);
        private static final Paint pntToolTipTxt = new Color(0, 0, 0, 216);
        private final Paint pntBackground;
        private final Paint pntBorder;
        private final Paint pntLabel;
        private final Paint pntBackgroundS;
        private final Paint pntBorderS;
        private final Paint pntLabelS;
        private final Paint pntBackgroundD;
        private final Paint pntBorderD;
        private final Paint pntLabelD;
        private final PositionedString label;
        private final Point2D[] inletLocations;
        private final Point2D[] outletLocations;
        private final List inletWires = new ArrayList();
        private final List outletWires = new ArrayList();
        private boolean selected = false;
        private boolean toolTips = false;
        private static final double minus90 = -1.5707963267948966;

        protected UGenView(UGen ugen, UGenInfo ui, String name, Rectangle2D bounds, FontMetrics fm, FontMetrics fm2) {
            int i;
            int b;
            int g;
            int r;
            this.ugen = ugen;
            this.bounds = bounds;
            this.inletLocations = new Point2D[ugen.getNumInputs()];
            this.outletLocations = new Point2D[ugen.getNumOutputs()];
            GeneralPath gp = new GeneralPath();
            GeneralPath gp2 = new GeneralPath();
            Area a = new Area();
            if (ugen.getRate() == kScalarRate) {
                r = 192;
                g = 192;
                b = 192;
            } else if (ugen.getRate() == kControlRate) {
                r = 128;
                g = 128;
                b = 192;
            } else if (ugen.getRate() == kAudioRate) {
                r = 192;
                g = 128;
                b = 128;
            } else if (ugen.getRate() == kDemandRate) {
                r = 128;
                g = 192;
                b = 128;
            } else {
                System.err.println("Illegal rate : " + ugen.getRate());
                r = 192;
                g = 192;
                b = 192;
            }
            this.pntBackground = new Color(r, g, b);
            this.pntBorder = new Color(r >> 1, g >> 1, b >> 1);
            this.pntLabel = new Color(r >> 2, g >> 2, b >> 2);
            this.pntBackgroundS = new Color(r >> 1, g >> 1, b >> 1);
            this.pntBorderS = new Color(r >> 2, g >> 2, b >> 2);
            this.pntLabelS = Color.white;
            this.pntBackgroundD = new Color(r, g, b, 128);
            this.pntBorderD = new Color(r >> 1, g >> 1, b >> 1, 128);
            this.pntLabelD = new Color(r >> 2, g >> 2, b >> 2, 128);
            double x = 7.0;
            double dx = (bounds.getWidth() - 2.0 - 12.0) / (double)(ugen.getNumInputs() - 1);
            double y = 1.0;
            double h = 3.0;
            for (i = 0; i < ugen.getNumInputs(); ++i) {
                double x2;
                String str;
                UGenInput inp = ugen.getInput(i);
                double y2 = y;
                if (inp instanceof Constant) {
                    str = SynthDefDiagram.formatConst(((Constant)inp).getValue());
                    this.collConsts.add(new PositionedString(str, x + 4.0, (y2 -= (double)(2 + fm.getHeight())) + (double)fm.getAscent()));
                    x2 = x + (double)fm.stringWidth(str);
                    gp2.moveTo((float)x2, (float)y2);
                    gp2.lineTo((float)x, (float)y2);
                    gp2.lineTo((float)x, (float)y);
                    this.collConstBounds.add(new Rectangle2D.Double(x, y2, x2 + 4.0 - x, y - y2));
                }
                gp.append(new Line2D.Double(x, y, x, y + h), false);
                this.inletLocations[i] = new Point2D.Double(x, y);
                if (ui != null && (str = ui.getArgNameForInput(ugen, i)) != null) {
                    this.collToolTips.add(new PositionedString(str, x + (double)fm2.getAscent() - 4.0, y2 - 4.0));
                    x2 = fm2.stringWidth(str) + 8;
                    a.add(new Area(new RoundRectangle2D.Double(x - 2.5, y2 - x2 - 2.0, fm2.getHeight(), x2, 6.0, 6.0)));
                }
                x += dx;
            }
            x = 7.0;
            dx = (bounds.getWidth() - 2.0 - 12.0) / (double)(ugen.getNumOutputs() - 1);
            y = bounds.getHeight() - 1.0;
            for (i = 0; i < ugen.getNumOutputs(); ++i) {
                gp.append(new Line2D.Double(x, y - h, x, y), false);
                this.outletLocations[i] = new Point2D.Double(x, y);
                x += dx;
            }
            this.shpCons = gp;
            this.shpConsts = gp2;
            this.shpToolTips = a;
            this.label = new PositionedString(name, 6.0, 6.0 + (double)fm.getAscent());
            this.shpContainer = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth(), bounds.getHeight());
        }

        protected void setSelected(boolean selected) {
            this.selected = selected;
        }

        protected boolean isSelected() {
            return this.selected;
        }

        protected void showToolTips(boolean yesNo) {
            this.toolTips = yesNo;
        }

        protected boolean isShowingToolTips() {
            return this.toolTips;
        }

        protected Point2D getLocation() {
            return new Point2D.Double(this.bounds.getX(), this.bounds.getY());
        }

        protected Rectangle2D getContainer() {
            return this.bounds.getBounds2D();
        }

        protected boolean contains(Point2D pt) {
            return this.bounds.contains(pt);
        }

        protected void setLocation(Point2D topLeft) {
            int i;
            this.bounds.setFrame(topLeft.getX(), topLeft.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            for (i = 0; i < this.inletWires.size(); ++i) {
                ((Wire)this.inletWires.get(i)).recalcPositions();
            }
            for (i = 0; i < this.outletWires.size(); ++i) {
                ((Wire)this.outletWires.get(i)).recalcPositions();
            }
        }

        protected List getConstBounds() {
            ArrayList<Rectangle2D.Double> result = new ArrayList<Rectangle2D.Double>(this.collConstBounds.size());
            for (int i = 0; i < this.collConstBounds.size(); ++i) {
                Rectangle2D rect = (Rectangle2D)this.collConstBounds.get(i);
                result.add(new Rectangle2D.Double(rect.getX() + this.bounds.getX(), rect.getY() + this.bounds.getY(), rect.getWidth(), rect.getHeight()));
            }
            return result;
        }

        protected Rectangle2D getBoundingBox() {
            Rectangle2D result = this.getContainer();
            List constBounds = this.getConstBounds();
            for (int i = 0; i < constBounds.size(); ++i) {
                Rectangle2D.union(result, (Rectangle2D)constBounds.get(i), result);
            }
            return result;
        }

        protected void addInletWire(Wire wire) {
            this.inletWires.add(wire);
        }

        protected void addOutletWire(Wire wire) {
            this.outletWires.add(wire);
        }

        protected UGen getUGen() {
            return this.ugen;
        }

        protected Point2D getInletLocation(int index) {
            return new Point2D.Double(this.inletLocations[index].getX() + this.bounds.getX(), this.inletLocations[index].getY() + this.bounds.getY());
        }

        protected Point2D getOutletLocation(int index) {
            return new Point2D.Double(this.outletLocations[index].getX() + this.bounds.getX(), this.outletLocations[index].getY() + this.bounds.getY());
        }

        protected void paint(Graphics2D g2, FontMetrics fm, boolean dragging) {
            Stroke strkOrig = g2.getStroke();
            AffineTransform atOrig = g2.getTransform();
            g2.translate(this.bounds.getX(), this.bounds.getY());
            g2.setPaint(dragging ? this.pntBackgroundD : (this.selected ? this.pntBackgroundS : this.pntBackground));
            g2.fill(this.shpContainer);
            g2.setPaint(dragging ? this.pntBorderD : (this.selected ? this.pntBorderS : this.pntBorder));
            g2.draw(this.shpContainer);
            g2.setPaint(dragging ? this.pntLabelD : (this.selected ? this.pntLabelS : this.pntLabel));
            g2.drawString(this.label.str, (float)this.label.x, (float)this.label.y);
            g2.setPaint(dragging ? pntConstD : pntConst);
            for (int i = 0; i < this.collConsts.size(); ++i) {
                PositionedString pStr = (PositionedString)this.collConsts.get(i);
                g2.drawString(pStr.str, (float)pStr.x, (float)pStr.y);
            }
            g2.draw(this.shpConsts);
            g2.setStroke(strkCons);
            g2.draw(this.shpCons);
            g2.setStroke(strkOrig);
            g2.setTransform(atOrig);
        }

        protected void paintToolTips(Graphics2D g2, FontMetrics fm) {
            Stroke strkOrig = g2.getStroke();
            AffineTransform atOrig = g2.getTransform();
            g2.translate(this.bounds.getX(), this.bounds.getY());
            AffineTransform atRecent = g2.getTransform();
            g2.setPaint(pntToolTips);
            g2.fill(this.shpToolTips);
            g2.setPaint(pntToolTipTxt);
            for (int i = 0; i < this.collToolTips.size(); ++i) {
                PositionedString pStr = (PositionedString)this.collToolTips.get(i);
                g2.translate(pStr.x, pStr.y);
                g2.rotate(-1.5707963267948966);
                g2.drawString(pStr.str, 0, 0);
                g2.setTransform(atRecent);
            }
            g2.setStroke(strkOrig);
            g2.setTransform(atOrig);
        }
    }

    private static class Wire
    implements Constants {
        private static final Paint pntScalarWire = new Color(96, 96, 96);
        private static final Paint pntControlWire = new Color(96, 96, 192);
        private static final Paint pntAudioWire = new Color(192, 96, 96);
        private static final Paint pntDemandWire = new Color(64, 128, 64);
        private final Paint pntWire;
        private Shape shpWire;
        private final Stroke strkWire = new BasicStroke(2.0f);
        private final UGenView outputUGen;
        private final UGenView inputUGen;
        private final int outputIndex;
        private final int inputIndex;

        protected Wire(UGenView outputUGen, int outputIndex, UGenView inputUGen, int inputIndex) {
            this.outputUGen = outputUGen;
            this.inputUGen = inputUGen;
            this.outputIndex = outputIndex;
            this.inputIndex = inputIndex;
            Object rate = outputUGen.getUGen().getOutputRate(outputIndex);
            if (rate == kScalarRate) {
                this.pntWire = pntScalarWire;
            } else if (rate == kControlRate) {
                this.pntWire = pntControlWire;
            } else if (rate == kAudioRate) {
                this.pntWire = pntAudioWire;
            } else if (rate == kDemandRate) {
                this.pntWire = pntDemandWire;
            } else {
                System.err.println("Illegal rate : " + rate);
                this.pntWire = pntScalarWire;
            }
            outputUGen.addOutletWire(this);
            inputUGen.addInletWire(this);
            this.recalcPositions();
        }

        protected void recalcPositions() {
            this.shpWire = new Line2D.Double(this.outputUGen.getOutletLocation(this.outputIndex), this.inputUGen.getInletLocation(this.inputIndex));
        }

        protected void paint(Graphics2D g2) {
            Stroke strkOrig = g2.getStroke();
            g2.setPaint(this.pntWire);
            g2.setStroke(this.strkWire);
            g2.draw(this.shpWire);
            g2.setStroke(strkOrig);
        }
    }

    private class SynthDefView
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final double HPAD = 12.0;
        private static final double VPAD = 12.0;
        private static final int MAX_WIDTH = 640;
        private final List collUGenViews = new ArrayList();
        private final List collSelectedViews = new ArrayList();
        private final List collWires = new ArrayList();
        private final Map mapUGensToViews = new HashMap();
        private boolean recalc = true;
        private final SynthDef def;
        private Point dragStartPtScreen = null;
        private Point2D dragStartPt = null;
        private Point2D dragCurrentPt = null;
        private boolean dragStarted = false;
        private double zoom = 1.0;
        private Rectangle2D boundingBox = new Rectangle2D.Double();

        protected SynthDefView(SynthDef def) {
            this.def = def;
            this.setFont(fntUGen);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFocusable(true);
        }

        private void createBoxes(Graphics2D g2, FontMetrics fm, FontMetrics fm2) {
            List children = this.def.getUGens();
            ArrayList verbaut = new ArrayList();
            ArrayList<UGen> neuVerbaut = new ArrayList<UGen>();
            ArrayList constRects = new ArrayList();
            ArrayList<Rectangle2D> ugenRects = new ArrayList<Rectangle2D>();
            double h = (double)fm.getHeight() + 12.0;
            double y = 0.0;
            this.collUGenViews.clear();
            this.mapUGensToViews.clear();
            this.collWires.clear();
            do {
                UGenView uv;
                Rectangle2D rect;
                int j;
                int i;
                double x = 0.0;
                block1: for (i = 0; i < children.size(); ++i) {
                    UGenInput inp;
                    UGen ugen = (UGen)children.get(i);
                    UGenInfo ui = UGenInfo.infos == null ? null : (UGenInfo)UGenInfo.infos.get(ugen.getName());
                    double hpadMax = 12.0;
                    for (j = 0; j < ugen.getNumInputs(); ++j) {
                        inp = ugen.getInput(j);
                        if (inp instanceof UGenChannel) {
                            if (verbaut.contains(((UGenChannel)inp).getUGen())) continue;
                            continue block1;
                        }
                        if (!(inp instanceof Constant)) continue;
                        double constW = 2.0 + fm.getStringBounds(SynthDefDiagram.formatConst(((Constant)inp).getValue()), g2).getWidth();
                        hpadMax = Math.max(hpadMax, constW);
                    }
                    children.remove(i--);
                    String name = ui == null ? ugen.getName() : ui.getDisplayName(ugen);
                    rect = fm.getStringBounds(name, g2);
                    int cons = Math.max(ugen.getNumInputs(), ugen.getNumOutputs());
                    double w = Math.max((double)cons * (2.0 + hpadMax), rect.getWidth() + 12.0);
                    uv = new UGenView(ugen, ui, name, new Rectangle2D.Double(x, y, w, h), fm, fm2);
                    this.collUGenViews.add(uv);
                    this.mapUGensToViews.put(ugen, uv);
                    neuVerbaut.add(ugen);
                    constRects.addAll(uv.getConstBounds());
                    for (j = 0; j < ugen.getNumInputs(); ++j) {
                        inp = ugen.getInput(j);
                        if (!(inp instanceof UGenChannel)) continue;
                        UGenView uv2 = (UGenView)this.mapUGensToViews.get(((UGenChannel)inp).getUGen());
                        Wire wire = new Wire(uv2, ((UGenChannel)inp).getChannel(), uv, j);
                        this.collWires.add(wire);
                    }
                    if ((x += w + 12.0) > 640.0) break;
                }
                double incY = 0.0;
                for (i = 0; i < constRects.size(); ++i) {
                    rect = (Rectangle2D)constRects.get(i);
                    for (j = 0; j < ugenRects.size(); ++j) {
                        Rectangle2D rect2 = (Rectangle2D)ugenRects.get(j);
                        if (!rect.intersects(rect2)) continue;
                        incY = Math.max(incY, rect2.getY() + rect2.getHeight() - rect.getY() + 6.0);
                    }
                }
                ugenRects.clear();
                constRects.clear();
                for (i = 0; i < neuVerbaut.size(); ++i) {
                    uv = (UGenView)this.mapUGensToViews.get(neuVerbaut.get(i));
                    if (incY > 0.0) {
                        Point2D pt = uv.getLocation();
                        uv.setLocation(new Point2D.Double(pt.getX(), pt.getY() + incY));
                    }
                    ugenRects.add(uv.getContainer());
                }
                verbaut.addAll(neuVerbaut);
                for (i = 0; i < neuVerbaut.size(); ++i) {
                    uv = (UGenView)this.mapUGensToViews.get(neuVerbaut.get(i));
                    ugenRects.add(uv.getContainer());
                }
                neuVerbaut.clear();
                y += h + 12.0 + incY;
            } while (!children.isEmpty());
            this.recalcBoundingBox();
            this.recalc = false;
        }

        protected double getZoom() {
            return this.zoom;
        }

        protected void setZoom(double newZoom) {
            this.zoom = newZoom;
            Dimension newSize = new Dimension((int)(this.boundingBox.getMaxX() * this.zoom + 4.0), (int)(this.boundingBox.getMaxY() * this.zoom + 4.0));
            this.setPreferredSize(newSize);
            this.revalidate();
        }

        private void recalcBoundingBox() {
            if (this.collUGenViews.isEmpty()) {
                return;
            }
            UGenView uv = (UGenView)this.collUGenViews.get(0);
            this.boundingBox = uv.getBoundingBox();
            for (int i = 1; i < this.collUGenViews.size(); ++i) {
                uv = (UGenView)this.collUGenViews.get(i);
                Rectangle2D.union(this.boundingBox, uv.getBoundingBox(), this.boundingBox);
            }
            Dimension oldSize = this.getPreferredSize();
            Dimension newSize = new Dimension((int)(this.boundingBox.getMaxX() * this.zoom + 4.0), (int)(this.boundingBox.getMaxY() * this.zoom + 4.0));
            if (this.boundingBox.getX() < 4.0 || this.boundingBox.getY() < 4.0) {
                int dx = Math.max(0, (int)(5.0 - this.boundingBox.getX()));
                int dy = Math.max(0, (int)(5.0 - this.boundingBox.getY()));
                for (int i = 0; i < this.collUGenViews.size(); ++i) {
                    uv = (UGenView)this.collUGenViews.get(i);
                    Point2D pt = uv.getLocation();
                    uv.setLocation(new Point2D.Double(pt.getX() + (double)dx, pt.getY() + (double)dy));
                }
            }
            if (!oldSize.equals(newSize)) {
                this.setPreferredSize(newSize);
                this.revalidate();
            }
        }

        public void paintComponent(Graphics g) {
            UGenView uv;
            int i;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            FontMetrics fm = g2.getFontMetrics();
            FontMetrics fm2 = g2.getFontMetrics(fntToolTip);
            AffineTransform atOrig = g2.getTransform();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.scale(this.zoom, this.zoom);
            if (this.recalc) {
                this.createBoxes(g2, fm, fm2);
            }
            for (i = 0; i < this.collUGenViews.size(); ++i) {
                uv = (UGenView)this.collUGenViews.get(i);
                uv.paint(g2, fm, false);
            }
            for (i = 0; i < this.collWires.size(); ++i) {
                Wire wire = (Wire)this.collWires.get(i);
                wire.paint(g2);
            }
            g2.setFont(fntToolTip);
            for (i = 0; i < this.collUGenViews.size(); ++i) {
                uv = (UGenView)this.collUGenViews.get(i);
                if (!uv.isShowingToolTips()) continue;
                uv.paintToolTips(g2, fm2);
            }
            g2.setFont(fntUGen);
            if (this.dragStarted) {
                g2.translate(this.dragCurrentPt.getX() - this.dragStartPt.getX(), this.dragCurrentPt.getY() - this.dragStartPt.getY());
                for (i = 0; i < this.collSelectedViews.size(); ++i) {
                    uv = (UGenView)this.collSelectedViews.get(i);
                    uv.paint(g2, fm, true);
                }
            }
            g2.setTransform(atOrig);
        }

        private Point2D getVirtualPoint(Point screenPt) {
            return new Point2D.Double((double)screenPt.x / this.zoom, (double)screenPt.y / this.zoom);
        }

        public void mousePressed(MouseEvent e) {
            UGenView uv;
            int i;
            this.requestFocus();
            Point2D mousePt = this.getVirtualPoint(e.getPoint());
            UGenView hitView = null;
            boolean repaint = false;
            for (i = 0; i < this.collUGenViews.size(); ++i) {
                uv = (UGenView)this.collUGenViews.get(i);
                if (!uv.contains(mousePt)) continue;
                hitView = uv;
                break;
            }
            if (!(e.isShiftDown() || this.collSelectedViews.isEmpty() || hitView != null && hitView.isSelected())) {
                for (i = 0; i < this.collSelectedViews.size(); ++i) {
                    uv = (UGenView)this.collSelectedViews.get(i);
                    uv.setSelected(false);
                }
                this.collSelectedViews.clear();
                repaint = true;
            }
            if (hitView != null) {
                if (e.getClickCount() == 2) {
                    hitView.showToolTips(!hitView.isShowingToolTips());
                    repaint = true;
                }
                if (e.isShiftDown()) {
                    if (hitView.isSelected()) {
                        hitView.setSelected(false);
                        this.collSelectedViews.remove(hitView);
                    } else {
                        hitView.setSelected(true);
                        this.collSelectedViews.add(hitView);
                    }
                    repaint = true;
                } else if (!hitView.isSelected()) {
                    hitView.setSelected(true);
                    this.collSelectedViews.add(hitView);
                    repaint = true;
                }
            } else if (e.getClickCount() == 2) {
                for (i = 0; i < this.collUGenViews.size(); ++i) {
                    uv = (UGenView)this.collUGenViews.get(i);
                    uv.showToolTips(false);
                }
                repaint = true;
            }
            if (!this.collSelectedViews.isEmpty()) {
                this.dragStartPtScreen = e.getPoint();
                this.dragStartPt = mousePt;
                this.dragStarted = false;
            }
            if (repaint) {
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragStarted) {
                this.dragCurrentPt = this.getVirtualPoint(e.getPoint());
                double dx = this.dragCurrentPt.getX() - this.dragStartPt.getX();
                double dy = this.dragCurrentPt.getY() - this.dragStartPt.getY();
                for (int i = 0; i < this.collSelectedViews.size(); ++i) {
                    UGenView uv = (UGenView)this.collSelectedViews.get(i);
                    Point2D pt = uv.getLocation();
                    uv.setLocation(new Point2D.Double(pt.getX() + dx, pt.getY() + dy));
                }
                this.recalcBoundingBox();
                this.dragStarted = false;
                this.repaint();
            }
            this.dragStartPt = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragStartPt != null) {
                if (!this.dragStarted) {
                    if (Math.abs((double)e.getX() - this.dragStartPtScreen.getX()) > 2.0 || Math.abs((double)e.getY() - this.dragStartPtScreen.getY()) > 2.0) {
                        this.dragStarted = true;
                    } else {
                        return;
                    }
                }
                this.dragCurrentPt = this.getVirtualPoint(e.getPoint());
                this.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

