/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.gui;

import de.sciss.jcollider.gui.ControlSpec;

public abstract class Warp {
    public static Warp lin = new LinearWarp();
    public static Warp exp = new ExponentialWarp();
    public static Warp sin = new SineWarp();
    public static Warp cos = new CosineWarp();

    public static Warp curve(double curve) {
        if (curve == 0.0) {
            return lin;
        }
        return new CurveWarp(curve);
    }

    public abstract double map(double var1, ControlSpec var3);

    public abstract double unmap(double var1, ControlSpec var3);

    private static class CurveWarp
    extends Warp {
        private final double curve;
        private final double grow;
        private final double oneByOneMGrow;

        protected CurveWarp(double curve) {
            this.curve = curve;
            this.grow = Math.exp(curve);
            this.oneByOneMGrow = 1.0 / (1.0 - this.grow);
        }

        public double map(double value, ControlSpec spec) {
            double a = spec.getRange() * this.oneByOneMGrow;
            double b = spec.getMinVal() + a;
            return b - a * Math.pow(this.grow, value);
        }

        public double unmap(double value, ControlSpec spec) {
            double a = spec.getRange() * this.oneByOneMGrow;
            double b = spec.getMinVal() + a;
            return Math.log((b - value) / a) / this.curve;
        }
    }

    private static class CosineWarp
    extends Warp {
        private static final double PIH = 1.5707963267948966;

        protected CosineWarp() {
        }

        public double map(double value, ControlSpec spec) {
            return (0.5 - Math.cos(Math.PI * value) * 0.5) * spec.getRange() + spec.getMinVal();
        }

        public double unmap(double value, ControlSpec spec) {
            double range = spec.getRange();
            if (range == 0.0) {
                return 0.0;
            }
            return Math.acos(1.0 - (value - spec.getMinVal()) / range * 2.0) / 1.5707963267948966;
        }
    }

    private static class SineWarp
    extends Warp {
        private static final double PIH = 1.5707963267948966;

        protected SineWarp() {
        }

        public double map(double value, ControlSpec spec) {
            return Math.sin(1.5707963267948966 * value) * spec.getRange() + spec.getMinVal();
        }

        public double unmap(double value, ControlSpec spec) {
            double range = spec.getRange();
            if (range == 0.0) {
                return 0.0;
            }
            return Math.asin((value - spec.getMinVal()) / range) / 1.5707963267948966;
        }
    }

    private static class ExponentialWarp
    extends Warp {
        protected ExponentialWarp() {
        }

        public double map(double value, ControlSpec spec) {
            return Math.pow(spec.getRatio(), value) * spec.getMinVal();
        }

        public double unmap(double value, ControlSpec spec) {
            return Math.log(value / spec.getMinVal()) / Math.log(spec.getRatio());
        }
    }

    private static class LinearWarp
    extends Warp {
        protected LinearWarp() {
        }

        public double map(double value, ControlSpec spec) {
            return value * spec.getRange() + spec.getMinVal();
        }

        public double unmap(double value, ControlSpec spec) {
            double range = spec.getRange();
            if (range == 0.0) {
                return 0.0;
            }
            return (value - spec.getMinVal()) / range;
        }
    }
}

