/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.test;

import de.sciss.jcollider.Constants;
import de.sciss.jcollider.Group;
import de.sciss.jcollider.JCollider;
import de.sciss.jcollider.NodeWatcher;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.ServerEvent;
import de.sciss.jcollider.ServerListener;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.SynthDef;
import de.sciss.jcollider.UGenInfo;
import de.sciss.jcollider.gui.NodeTreePanel;
import de.sciss.jcollider.gui.ServerPanel;
import de.sciss.jcollider.gui.SynthDefDiagram;
import de.sciss.jcollider.test.DemoDefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Demo
extends JFrame
implements FileFilter,
ServerListener,
Constants {
    public static Font fntGUI = ServerPanel.fntGUI;
    protected final SynthDefTable[] defTables;
    protected SynthDefTable selectedTable = null;
    protected static final Comparator synthDefNameComp = new SynthDefNameComp();
    protected Server server = null;
    protected NodeWatcher nw = null;
    protected Group grpAll;
    private static final String[] tableNames = new String[]{"JCollider", "Drop Zone"};
    protected final Demo enc_this = this;

    public Demo() {
        super("JCollider Demo");
        Box b = Box.createHorizontalBox();
        Box b2 = Box.createHorizontalBox();
        Container cp = this.getContentPane();
        final JTextField ggAppPath = new JTextField(32);
        String fs = File.separator;
        Component spf = null;
        this.defTables = new SynthDefTable[2];
        for (int i = 0; i < 2; ++i) {
            this.defTables[i] = new SynthDefTable(tableNames[i]);
            JScrollPane ggScroll = new JScrollPane(this.defTables[i]);
            b.add(ggScroll);
            this.defTables[i].getSelectionModel().addListSelectionListener(new TableSelListener(i));
            if (i != 1) continue;
            ggScroll.setTransferHandler(new SynthDefFileTransferHandler(1));
            ggScroll.setToolTipText("Drop SynthDef Files from the Finder here");
        }
        try {
            cp.setLayout(new BorderLayout());
            cp.add((Component)b, "Center");
            this.server = new Server("localhost");
            this.createDefs();
            File f = Demo.findFile(JCollider.isWindows ? "scsynth.exe" : "scsynth", new String[]{fs + "Applications" + fs + "SuperCollider_f", fs + "Applications" + fs + "SC3", fs + "usr" + fs + "local" + fs + "bin", fs + "usr" + fs + "bin", "C:\\Program Files\\SC3", "C:\\Program Files\\SuperCollider_f"});
            if (f != null) {
                Server.setProgram(f.getAbsolutePath());
            }
            ggAppPath.setText(Server.getProgram());
            ggAppPath.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Server.setProgram(ggAppPath.getText());
                }
            });
            JLabel lb = new JLabel("Server App Path :");
            lb.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 4));
            b2.add(lb);
            b2.add(ggAppPath);
            cp.add((Component)b2, "North");
            cp.add((Component)this.createButtons(), "South");
            this.server.addListener(this);
            try {
                this.server.start();
                this.server.startAliveThread();
            }
            catch (IOException e1) {
                // empty catch block
            }
            spf = ServerPanel.makeWindow(this.server, 255);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "Failed to create a server :\n" + e1.getClass().getName() + e1.getLocalizedMessage(), this.getTitle(), 0);
        }
        JCollider.setDeepFont(cp, fntGUI);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (Demo.this.nw != null) {
                    Demo.this.nw.dispose();
                    Demo.this.nw = null;
                }
                if (Demo.this.server != null) {
                    try {
                        if (Demo.this.server.didWeBootTheServer()) {
                            Demo.this.server.quitAndWait();
                        } else if (Demo.this.grpAll != null) {
                            Demo.this.grpAll.free();
                        }
                        Demo.this.server = null;
                    }
                    catch (IOException e1) {
                        Demo.reportError(e1);
                    }
                }
                Demo.this.setVisible(false);
                Demo.this.dispose();
                System.exit(0);
            }
        });
        this.setDefaultCloseOperation(0);
        if (spf != null) {
            this.setLocation(spf.getX() + spf.getWidth() + 24, spf.getY());
        }
        this.setSize(512, 512);
        this.setVisible(true);
        this.toFront();
    }

    private JComponent createButtons() {
        Box b = Box.createHorizontalBox();
        JButton but = new JButton(new ActionPlay());
        but.setToolTipText("Play Selected SynthDef");
        b.add(but);
        but = new JButton(new ActionStop());
        but.setToolTipText("Stop All Synths");
        b.add(but);
        but = new JButton(new ActionDiagram());
        but.setToolTipText("Open Diagram For Selected SynthDef");
        b.add(but);
        but = new JButton(new ActionDump());
        but.setToolTipText("Dump Selected SynthDef To The System Console");
        b.add(but);
        but = new JButton(new ActionSynthDefApiEx());
        but.setToolTipText("Demo code from SynthDef API doc");
        b.add(but);
        but = new JButton(new ActionNodeTree());
        but.setToolTipText("View a Tree of all Nodes");
        b.add(but);
        return b;
    }

    private void createDefs() {
        try {
            UGenInfo.readBinaryDefinitions();
            List collDefs = DemoDefs.create();
            Collections.sort(collDefs, synthDefNameComp);
            this.defTables[0].addDefs(collDefs);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void initServer() throws IOException {
        this.sendDefs();
        if (!this.server.didWeBootTheServer()) {
            this.server.initTree();
            this.server.notify(true);
        }
        this.nw = NodeWatcher.newFrom(this.server);
        this.grpAll = Group.basicNew(this.server);
        this.nw.register(this.server.getDefaultGroup());
        this.nw.register(this.grpAll);
        this.server.sendMsg(this.grpAll.newMsg());
    }

    private void sendDefs() {
        for (int i = 0; i < this.defTables.length; ++i) {
            List defs = this.defTables[i].getDefs();
            for (int j = 0; j < defs.size(); ++j) {
                SynthDef def = (SynthDef)defs.get(j);
                try {
                    def.send(this.server);
                    continue;
                }
                catch (IOException e1) {
                    System.err.println("Sending Def " + def.getName() + " : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                }
            }
        }
    }

    private static File findFile(String fileName, String[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            File f = new File(folders[i], fileName);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Demo();
            }
        });
    }

    protected static void reportError(Exception e) {
        System.err.println(e.getClass().getName() + " : " + e.getLocalizedMessage());
    }

    public void serverAction(ServerEvent e) {
        switch (e.getID()) {
            case 0: {
                try {
                    this.initServer();
                }
                catch (IOException e1) {
                    Demo.reportError(e1);
                }
                break;
            }
            case 1: {
                Timer t = new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (Demo.this.server != null) {
                                Demo.this.server.startAliveThread();
                            }
                        }
                        catch (IOException e1) {
                            Demo.reportError(e1);
                        }
                    }
                });
                t.setRepeats(false);
                t.start();
                break;
            }
        }
    }

    public boolean accept(File f) {
        try {
            return SynthDef.isDefFile(f);
        }
        catch (IOException e1) {
            return false;
        }
    }

    private class SynthDefFileTransferHandler
    extends TransferHandler {
        private final int idx;

        protected SynthDefFileTransferHandler(int idx) {
            this.idx = idx;
        }

        public boolean importData(JComponent c, Transferable t) {
            block9: {
                try {
                    Object o;
                    if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || !((o = t.getTransferData(DataFlavor.javaFileListFlavor)) instanceof List)) break block9;
                    List fileList = (List)o;
                    ArrayList<SynthDef> collDefs = new ArrayList<SynthDef>();
                    for (int i = 0; i < fileList.size(); ++i) {
                        File f = (File)fileList.get(i);
                        try {
                            if (SynthDef.isDefFile(f)) {
                                SynthDef[] defs = SynthDef.readDefFile(f);
                                for (int j = 0; j < defs.length; ++j) {
                                    collDefs.add(defs[j]);
                                }
                                continue;
                            }
                            System.err.println("Not a synth def file : " + f.getName());
                            continue;
                        }
                        catch (IOException e1) {
                            JCollider.displayError(Demo.this.enc_this, e1, "Drop File");
                        }
                    }
                    if (!collDefs.isEmpty()) {
                        Collections.sort(collDefs, synthDefNameComp);
                        Demo.this.defTables[this.idx].addDefs(collDefs);
                        return true;
                    }
                }
                catch (UnsupportedFlavorException e1) {
                }
                catch (IOException e2) {
                    JCollider.displayError(Demo.this.enc_this, e2, "Drop File");
                }
            }
            return false;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SynthDefNameComp
    implements Comparator {
        protected SynthDefNameComp() {
        }

        public int compare(Object def1, Object def2) {
            return ((SynthDef)def1).getName().compareTo(((SynthDef)def2).getName());
        }
    }

    private class ActionNodeTree
    extends AbstractAction {
        protected ActionNodeTree() {
            super("Node Tree");
        }

        public void actionPerformed(ActionEvent e) {
            if (Demo.this.server == null || Demo.this.nw == null || Demo.this.grpAll == null) {
                return;
            }
            final NodeTreePanel ntp = new NodeTreePanel(Demo.this.nw, Demo.this.grpAll);
            final JFrame treeFrame = ntp.makeWindow();
            treeFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    treeFrame.setVisible(false);
                    treeFrame.dispose();
                    ntp.dispose();
                }
            });
        }
    }

    private class ActionSynthDefApiEx
    extends AbstractAction {
        protected ActionSynthDefApiEx() {
            super("API Ex");
        }

        public void actionPerformed(ActionEvent e) {
            DemoDefs.synthDefApiExample(Demo.this.server);
        }
    }

    private class ActionDump
    extends AbstractAction {
        protected ActionDump() {
            super("Def Dump");
        }

        public void actionPerformed(ActionEvent e) {
            if (Demo.this.selectedTable == null) {
                return;
            }
            SynthDef def = Demo.this.selectedTable.getSelectedDef();
            if (def != null) {
                def.printOn(System.out);
            }
        }
    }

    private class ActionDiagram
    extends AbstractAction {
        protected ActionDiagram() {
            super("Def Diagram");
        }

        public void actionPerformed(ActionEvent e) {
            if (Demo.this.selectedTable == null) {
                return;
            }
            SynthDef def = Demo.this.selectedTable.getSelectedDef();
            if (def != null) {
                new SynthDefDiagram(def);
            }
        }
    }

    private class TableSelListener
    implements ListSelectionListener {
        int idx;

        protected TableSelListener(int idx) {
            this.idx = idx;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (Demo.this.defTables[this.idx].getSelectedRowCount() > 0) {
                Demo.this.selectedTable = Demo.this.defTables[this.idx];
                for (int i = 0; i < Demo.this.defTables.length; ++i) {
                    if (i == this.idx || Demo.this.defTables[i].getSelectedRowCount() <= 0) continue;
                    Demo.this.defTables[i].clearSelection();
                }
            }
        }
    }

    private class ActionStop
    extends AbstractAction {
        protected ActionStop() {
            super("Stop All");
        }

        public void actionPerformed(ActionEvent e) {
            if (Demo.this.grpAll != null) {
                try {
                    Demo.this.grpAll.freeAll();
                }
                catch (IOException e1) {
                    JCollider.displayError(Demo.this.enc_this, e1, "Stop");
                }
            }
        }
    }

    private class ActionPlay
    extends AbstractAction {
        protected ActionPlay() {
            super("Play");
        }

        public void actionPerformed(ActionEvent e) {
            if (Demo.this.selectedTable == null) {
                return;
            }
            SynthDef def = Demo.this.selectedTable.getSelectedDef();
            if (def != null && Demo.this.grpAll != null && Demo.this.server != null) {
                try {
                    Synth synth = Synth.basicNew(def.getName(), Demo.this.server);
                    if (Demo.this.nw != null) {
                        Demo.this.nw.register(synth);
                    }
                    Demo.this.server.sendMsg(synth.newMsg(Demo.this.grpAll));
                }
                catch (IOException e1) {
                    JCollider.displayError(Demo.this.enc_this, e1, "Play");
                }
            }
        }
    }

    private static class SynthDefTableModel
    extends AbstractTableModel {
        private final List collDefs = new ArrayList();
        private final String name;

        protected SynthDefTableModel(String name) {
            this.name = name;
        }

        public String getColumnName(int col) {
            return this.name;
        }

        public int getRowCount() {
            return this.collDefs.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int column) {
            if (row < this.collDefs.size()) {
                return ((SynthDef)this.collDefs.get(row)).getName();
            }
            return null;
        }

        protected void addDefs(List defs) {
            if (defs.isEmpty()) {
                return;
            }
            int startRow = this.collDefs.size();
            this.collDefs.addAll(defs);
            this.fireTableRowsInserted(startRow, this.collDefs.size() - 1);
        }

        protected SynthDef getDef(int idx) {
            return (SynthDef)this.collDefs.get(idx);
        }

        protected List getDefs() {
            return new ArrayList(this.collDefs);
        }
    }

    private static class SynthDefTable
    extends JTable {
        private final SynthDefTableModel tm;

        protected SynthDefTable(String name) {
            this.tm = new SynthDefTableModel(name);
            this.setModel(this.tm);
            this.getColumnModel().getColumn(0).setPreferredWidth(128);
            this.setSelectionMode(0);
        }

        protected void addDefs(List defs) {
            this.tm.addDefs(defs);
        }

        protected SynthDef getSelectedDef() {
            int row = this.getSelectedRow();
            if (row >= 0) {
                return this.tm.getDef(row);
            }
            return null;
        }

        protected List getDefs() {
            return this.tm.getDefs();
        }
    }
}

