/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.test;

import de.sciss.jcollider.Control;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.GraphElemArray;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.SynthDef;
import de.sciss.jcollider.UGen;
import de.sciss.jcollider.UGenChannel;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class DemoDefs {
    public static List create() {
        int i;
        int i2;
        ArrayList<SynthDef> result = new ArrayList<SynthDef>();
        Random rnd = new Random(System.currentTimeMillis());
        GraphElem f = UGen.kr("midicps", UGen.kr("MulAdd", UGen.kr("LFSaw", UGen.ir(0.4f), UGen.ir(0.0f)), UGen.ir(24.0f), UGen.kr("MulAdd", UGen.kr("LFSaw", UGen.array(UGen.ir(8.0f), UGen.ir(7.23f)), UGen.ir(0.0f)), UGen.ir(3.0f), UGen.ir(80.0f))));
        GraphElem g = UGen.ar("CombN", UGen.ar("*", UGen.ar("SinOsc", f, UGen.ir(0.0f)), UGen.ir(0.04f)), UGen.ir(0.2f), UGen.ir(0.2f), UGen.ir(4.0f));
        SynthDef def = new SynthDef("JAnalogBubbles", UGen.ar("Out", UGen.ir(0.0f), g));
        result.add(def);
        f = UGen.ar("CombL", UGen.ar("RLPF", UGen.ar("*", UGen.ar("LFPulse", UGen.kr("MulAdd", UGen.kr("FSinOsc", UGen.ir(0.05f), UGen.ir(0.0f)), UGen.ir(80.0f), UGen.ir(160.0f)), UGen.ir(0.0f), UGen.ir(0.4f)), UGen.ir(0.05f)), UGen.kr("MulAdd", UGen.kr("FSinOsc", UGen.array(UGen.ir(0.6f), UGen.ir(0.7f)), UGen.ir(0.0f)), UGen.ir(3600.0f), UGen.ir(4000.0f)), UGen.ir(0.2f)), UGen.ir(0.3f), UGen.array(UGen.ir(0.2f), UGen.ir(0.25f)), UGen.ir(2.0f));
        def = new SynthDef("JPulseModulation", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        f = UGen.ar("clip2", UGen.ar("RLPF", UGen.ar("LFPulse", UGen.kr("MulAdd", UGen.kr("SinOsc", UGen.ir(0.2f), UGen.ir(0.0f)), UGen.ir(10.0f), UGen.ir(21.0f)), UGen.ir(0.1f)), UGen.ir(100.0f), UGen.ir(0.1f)), UGen.ir(0.4f));
        def = new SynthDef("JMotoRev", UGen.ar("Out", UGen.ir(0.0f), UGen.ar("Pan2", f)));
        result.add(def);
        f = UGen.ar("RHPF", UGen.ar("*", UGen.ar("max", UGen.ar("MulAdd", UGen.array(UGen.ar("BrownNoise"), UGen.ar("BrownNoise")), UGen.ir(0.5f), UGen.ir(-0.49f)), UGen.ir(0.0f)), UGen.ir(20.0f)), UGen.ir(5000.0f), UGen.ir(1.0f));
        def = new SynthDef("JScratchy", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        f = UGen.ar("BPZ2", UGen.ar("*", UGen.ar("WhiteNoise"), UGen.kr("*", UGen.kr("LFPulse", UGen.kr("MulAdd", UGen.kr("LFPulse", UGen.ir(0.09f), UGen.ir(0.0f), UGen.ir(0.16f)), UGen.ir(10.0f), UGen.ir(7.0f)), UGen.ir(0.0f), UGen.ir(0.25f)), UGen.ir(0.1f))));
        def = new SynthDef("JSprinkler", UGen.ar("Out", UGen.ir(0.0f), UGen.ar("Pan2", f)));
        result.add(def);
        float freq = 50.0f;
        int partials = 20;
        GraphElem z = UGen.ir(0.0f);
        GraphElem offset = UGen.kr("Line", UGen.ir(0.0f), UGen.ir(-0.02f), UGen.ir(60.0f));
        for (i2 = 0; i2 < partials; ++i2) {
            f = UGen.kr("max", UGen.ir(0.0f), UGen.kr("MulAdd", UGen.kr("LFNoise1", UGen.array(UGen.ir(2.0f + rnd.nextFloat() * 8.0f), UGen.ir(2.0f + rnd.nextFloat() * 8.0f))), UGen.ir(0.02f), offset));
            z = UGen.ar("MulAdd", UGen.ar("FSinOsc", UGen.ir(freq * (float)(i2 + 1)), UGen.ir(0.0f)), f, z);
        }
        def = new SynthDef("JHarmonicSwimming", UGen.ar("Out", UGen.ir(0.0f), z));
        result.add(def);
        freq = 80.0f;
        float partials2 = 10.0f;
        z = UGen.ir(0.0f);
        GraphElem trig = UGen.kr("XLine", UGen.array(UGen.ir(10.0f), UGen.ir(10.0f)), UGen.ir(0.1f), UGen.ir(60.0f));
        i2 = 0;
        while ((float)i2 < partials2) {
            f = UGen.kr("Decay2", UGen.kr("*", UGen.kr("Dust", trig), UGen.ir(0.02f)), UGen.ir(0.005f), UGen.ir(rnd.nextFloat() * 0.5f));
            z = UGen.ar("MulAdd", UGen.ar("FSinOsc", UGen.ir(freq * (float)(i2 + 1)), UGen.ir(0.0f)), f, z);
            ++i2;
        }
        def = new SynthDef("JHarmonicTumbling", UGen.ar("Out", UGen.ir(0.0f), z));
        result.add(def);
        int partials3 = 15;
        GraphElem[] flop = new GraphElem[partials3 * 3];
        int j = 0;
        for (int i3 = 0; i3 < partials3; ++i3) {
            float fl = rnd.nextFloat();
            flop[j++] = UGen.ir(80.0f + fl * fl * 10000.0f);
            flop[j++] = UGen.ir(rnd.nextFloat() * 2.0f - 1.0f);
            flop[j++] = UGen.ir(0.2f + rnd.nextFloat() * 8.0f);
        }
        f = UGen.ar("Klank", UGen.ar("*", UGen.ar("Dust", UGen.ir(0.7f)), UGen.ir(0.04f)), UGen.ir(1.0f), UGen.ir(0.0f), UGen.ir(1.0f), (GraphElem)new GraphElemArray(flop));
        g = UGen.ar("Pan2", f, UGen.ir(rnd.nextFloat() * 2.0f - 1.0f));
        def = new SynthDef("JKlankReson", UGen.ar("Out", UGen.ir(0.0f), g));
        result.add(def);
        int num = 4;
        f = null;
        for (int i4 = 0; i4 < num; ++i4) {
            g = UGen.ar("Pan2", UGen.ar("*", UGen.ar("SinOsc", UGen.kr("MulAdd", UGen.kr("SinOsc", UGen.ir(rnd.nextFloat() * 0.1f + 0.02f), UGen.ir(rnd.nextFloat() * 2.0f * (float)Math.PI)), UGen.ir(rnd.nextInt(600)), UGen.ir(rnd.nextInt(600) + 700)), UGen.ir(0.0f)), UGen.ar("*", UGen.ar("LFNoise2", UGen.ir(80.0f + rnd.nextFloat() * 40.0f)), UGen.ir(0.1f))), UGen.ir(rnd.nextFloat() * 2.0f - 1.0f));
            f = f == null ? g : UGen.ar("+", f, g);
        }
        g = UGen.ar("*", UGen.ar("LFNoise2", UGen.kr("MulAdd", UGen.kr("LFNoise2", UGen.array(UGen.ir(0.4f), UGen.ir(0.4f))), UGen.ir(90.0f), UGen.ir(620.0f))), UGen.kr("MulAdd", UGen.kr("LFNoise2", UGen.array(UGen.ir(0.3f), UGen.ir(0.3f))), UGen.ir(0.15f), UGen.ir(0.18f)));
        GraphElem h = UGen.ar("CombL", UGen.ar("+", f, g), UGen.ir(0.3f), UGen.ir(0.3f), UGen.ir(3.0f));
        def = new SynthDef("JPoliceState", UGen.ar("Out", UGen.ir(0.0f), h));
        result.add(def);
        GraphElem clockRate = UGen.kr("MouseX", UGen.ir(1.0f), UGen.ir(200.0f), UGen.ir(1.0f));
        GraphElem clockTime = UGen.kr("reciprocal", clockRate);
        GraphElem clock = UGen.kr("Impulse", clockRate, UGen.ir(0.4f));
        GraphElem centerFreq = UGen.kr("MouseY", UGen.ir(100.0f), UGen.ir(8000.0f), UGen.ir(1.0f));
        GraphElem freq2 = UGen.kr("Latch", UGen.kr("MulAdd", UGen.kr("WhiteNoise"), UGen.kr("*", centerFreq, UGen.ir(0.5f)), centerFreq), clock);
        GraphElem panPos = UGen.kr("Latch", UGen.kr("WhiteNoise"), clock);
        f = UGen.ar("*", UGen.ar("SinOsc", freq2), UGen.kr("Decay2", clock, UGen.kr("*", UGen.ir(0.1f), clockTime), UGen.kr("*", UGen.ir(0.9f), clockTime)));
        g = UGen.ar("Pan2", f, panPos);
        h = UGen.ar("CombN", g, UGen.ir(0.3f), UGen.ir(0.3f), UGen.ir(2.0f));
        def = new SynthDef("JSampleAndHoldLiquid", UGen.ar("Out", UGen.ir(0.0f), h));
        result.add(def);
        float amp = 0.07f;
        GraphElem density = UGen.kr("MouseX", UGen.ir(0.01f), UGen.ir(1.0f));
        GraphElem dmul = UGen.kr("*", UGen.kr("reciprocal", density), UGen.ir(0.5f * amp));
        GraphElem dadd = UGen.kr("+", UGen.kr("neg", dmul), UGen.ir(amp));
        float[] fRange = new float[]{1.0f, 0.5f, 0.25f};
        f = null;
        for (i = 0; i < 4; ++i) {
            GraphElem excitation = UGen.ar("*", UGen.ar("PinkNoise"), UGen.kr("max", UGen.ir(0.0f), UGen.kr("MulAdd", UGen.kr("LFNoise1", UGen.ir(8.0f)), dmul, dadd)));
            GraphElem freq3 = UGen.kr("midicps", UGen.kr("Lag", UGen.kr("round", UGen.kr("MulAdd", UGen.kr("LFNoise0", UGen.ir(fRange[rnd.nextInt(3)])), UGen.ir(7.0f), UGen.ir(36 + rnd.nextInt(60))), UGen.ir(1.0f)), UGen.ir(0.2f)));
            g = UGen.ar("Pan2", UGen.ar("CombL", excitation, UGen.ir(0.02f), UGen.kr("reciprocal", freq3), UGen.ir(3.0f)), UGen.ir(rnd.nextFloat() * 2.0f - 1.0f));
            f = f == null ? g : UGen.ar("+", f, g);
        }
        for (i = 0; i < 5; ++i) {
            f = UGen.ar("AllpassN", f, UGen.ir(0.05f), UGen.array(UGen.ir(rnd.nextFloat() * 0.05f), UGen.ir(rnd.nextFloat() * 0.05f)), UGen.ir(1.0f));
        }
        f = UGen.ar("LeakDC", f, UGen.ir(0.995f));
        def = new SynthDef("JAleatoricQuartet", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        f = null;
        for (int i5 = 0; i5 < 4; ++i5) {
            g = UGen.ar("*", UGen.ar("LFSaw", UGen.kr("midicps", UGen.kr("MulAdd", UGen.kr("LFPulse", UGen.ir(0.06f), UGen.ir(0.0f), UGen.ir(0.5f)), UGen.ir(2.0f), UGen.array(UGen.ir(34.0f + DemoDefs.rand2(rnd, 0.1f)), UGen.ir(34.0f + DemoDefs.rand2(rnd, 0.1f)))))), UGen.ir(0.01f));
            f = f == null ? g : UGen.ar("+", f, g);
        }
        g = UGen.kr("MouseY", UGen.ir(0.1f), UGen.ir(0.7f));
        h = UGen.kr("LinExp", UGen.kr("SinOsc", UGen.ir(0.07f)), UGen.ir(-1.0f), UGen.ir(1.0f), UGen.ir(300.0f), UGen.ir(5000.0f));
        f = UGen.ar("softclip", UGen.ar("RLPF", f, h, g));
        f = UGen.ar("softclip", UGen.ar("RLPF", f, h, g));
        def = new SynthDef("JNoiseBusiness1", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        float pi2 = (float)Math.PI * 2;
        f = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        f = UGen.ar("max", UGen.ir(0.0f), UGen.ar("*", UGen.ir(0.1f), UGen.ar("+", f, g)));
        h = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 6.0f, 24.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        h = UGen.ar("abs", UGen.ar("*", UGen.ir(0.1f), UGen.ar("+", h, g)));
        f = UGen.ar("*", UGen.ar("SinOsc", UGen.ir(DemoDefs.midicps(DemoDefs.rrand(rnd, 24.0f, 108.0f))), UGen.ir(rnd.nextFloat() * pi2)), UGen.ar("*", f, h));
        f = UGen.ar("Pan2", f, UGen.ir(DemoDefs.rand2(rnd, 1.0f)));
        def = new SynthDef("JNoiseBusiness2", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        pi2 = (float)Math.PI * 2;
        f = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        f = UGen.ar("max", UGen.ir(0.0f), UGen.ar("*", UGen.ir(0.04f), UGen.ar("+", f, g)));
        h = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 6.0f, 24.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        h = UGen.ar("abs", UGen.ar("+", h, g));
        f = UGen.ar("*", UGen.ar("LFTri", UGen.ir(DemoDefs.midicps(DemoDefs.rrand(rnd, 24.0f, 108.0f))), UGen.ir(rnd.nextFloat() * pi2)), UGen.ar("*", f, h));
        f = UGen.ar("Pan2", UGen.ar("HPZ1", f), UGen.ir(DemoDefs.rand2(rnd, 1.0f)));
        def = new SynthDef("JNoiseBusiness3", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        pi2 = (float)Math.PI * 2;
        f = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        f = UGen.ar("max", UGen.ir(0.0f), UGen.ar("*", UGen.ir(0.04f), UGen.ar("+", f, g)));
        h = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 6.0f, 24.0f) * DemoDefs.rrand(rnd, 0.7f, 1.3f)), UGen.ir(rnd.nextFloat() * pi2));
        g = UGen.ar("SinOsc", UGen.ir(DemoDefs.exprand(rnd, 0.3f, 8.0f)), UGen.ir(rnd.nextFloat() * pi2));
        h = UGen.ar("abs", UGen.ar("+", h, g));
        f = UGen.ar("*", UGen.ar("LFPulse", UGen.ir(80.0f * DemoDefs.rrand(rnd, 1.0f, 32.0f)), UGen.ir(rnd.nextFloat() * pi2), UGen.ir(0.1f)), UGen.ar("*", f, h));
        f = UGen.ar("Pan2", UGen.ar("LPZ2", f), UGen.ir(DemoDefs.rand2(rnd, 1.0f)));
        def = new SynthDef("JNoiseBusiness4", UGen.ar("Out", UGen.ir(0.0f), f));
        result.add(def);
        Control kCtrl = Control.kr(new String[]{"out", "freq", "decay", "wet", "gate"}, new float[]{0.0f, 400.0f, 2.0f, 1.0f, 1.0f});
        GraphElem zin = UGen.ar("In", 2, (GraphElem)kCtrl.getChannel("out"));
        GraphElem freq4 = UGen.kr("Lag3", kCtrl.getChannel("freq"), UGen.ir(0.1f));
        GraphElem env = UGen.kr("Linen", kCtrl.getChannel("gate"), UGen.ir(1.0f), UGen.ir(1.0f), UGen.ir(1.0f));
        GraphElem wet = UGen.kr("Ramp", kCtrl.getChannel("wet"), UGen.ir(0.1f));
        GraphElem comb = UGen.ar("CombN", zin, UGen.ir(1.0f / DemoDefs.midicps(24.0f)), UGen.kr("reciprocal", freq4), (GraphElem)kCtrl.getChannel("decay"));
        GraphElem zout = UGen.ar("distort", comb);
        f = UGen.ar("XOut", kCtrl.getChannel("out"), UGen.kr("*", wet, env), zout);
        g = UGen.kr("FreeSelfWhenDone", env);
        def = new SynthDef("JCombDist", new GraphElemArray(new GraphElem[]{f, g}));
        result.add(def);
        kCtrl = Control.kr(new String[]{"out", "freq", "wet", "gate"}, new float[]{0.0f, 800.0f, 1.0f, 1.0f});
        GraphElem freq5 = UGen.kr("Ramp", kCtrl.getChannel("freq"), UGen.ir(0.1f));
        GraphElem env2 = UGen.kr("Linen", kCtrl.getChannel("gate"), UGen.ir(1.0f), UGen.ir(1.0f), UGen.ir(1.0f));
        GraphElem wet2 = UGen.kr("Ramp", kCtrl.getChannel("wet"), UGen.ir(0.1f));
        GraphElem zin2 = UGen.ar("In", 2, (GraphElem)kCtrl.getChannel("out"));
        GraphElem zout2 = UGen.ar("*", zin2, UGen.ar("SinOsc", freq5, UGen.array(UGen.ir(0.0f), UGen.ir(1.5707964f))));
        f = UGen.ar("XOut", kCtrl.getChannel("out"), UGen.kr("*", wet2, env2), zout2);
        g = UGen.kr("FreeSelfWhenDone", env2);
        def = new SynthDef("JRingMod", new GraphElemArray(new GraphElem[]{f, g}));
        result.add(def);
        return result;
    }

    public static void synthDefApiExample(Server myServer) {
        int i;
        GraphElem f = null;
        Control c = Control.kr(new String[]{"resinv"}, new float[]{0.5f});
        UGenChannel reso = c.getChannel(0);
        Random r = new Random(System.currentTimeMillis());
        String defName = "JNoiseBusiness1b";
        for (i = 0; i < 4; ++i) {
            GraphElem g = UGen.ar("*", UGen.ar("LFSaw", UGen.kr("midicps", UGen.kr("MulAdd", UGen.kr("LFPulse", UGen.ir(0.06f), UGen.ir(0.0f), UGen.ir(0.5f)), UGen.ir(2.0f), UGen.array(UGen.ir(34.0f + r.nextFloat() * 0.2f), UGen.ir(34.0f + r.nextFloat() * 0.2f))))), UGen.ir(0.01f));
            f = f == null ? g : UGen.ar("+", f, g);
        }
        GraphElem h = UGen.kr("LinExp", UGen.kr("SinOsc", UGen.ir(0.07f)), UGen.ir(-1.0f), UGen.ir(1.0f), UGen.ir(300.0f), UGen.ir(5000.0f));
        f = UGen.ar("softclip", UGen.ar("RLPF", f, h, (GraphElem)reso));
        f = UGen.ar("softclip", UGen.ar("RLPF", f, h, (GraphElem)reso));
        SynthDef def = new SynthDef(defName, UGen.ar("Out", UGen.ir(0.0f), f));
        Synth synth = Synth.basicNew(defName, myServer);
        try {
            OSCBundle bndl;
            def.send(myServer, synth.newMsg(myServer.asTarget(), new String[]{"resinv"}, new float[]{0.98f}));
            long time = System.currentTimeMillis();
            for (i = 500; i < 5000; i += 250) {
                bndl = new OSCBundle(time + (long)i);
                bndl.addPacket((OSCPacket)synth.setMsg("resinv", r.nextFloat() * 0.8f + 0.015f));
                myServer.sendBundle(bndl);
            }
            bndl = new OSCBundle(time + 5500L);
            bndl.addPacket((OSCPacket)synth.freeMsg());
            myServer.sendBundle(bndl);
        }
        catch (IOException e1) {
            System.err.println(e1);
        }
    }

    private static float exprand(Random rnd, float lo, float hi) {
        double dlog = Math.log(hi) - Math.log(lo);
        return (float)Math.exp(rnd.nextDouble() * dlog) * lo;
    }

    private static float rrand(Random rnd, float lo, float hi) {
        return rnd.nextFloat() * (hi - lo) + lo;
    }

    private static float rand2(Random rnd, float x) {
        return rnd.nextFloat() * 2.0f * x - x;
    }

    private static float midicps(float midi) {
        return (float)(Math.exp((double)((midi - 69.0f) / 12.0f) * Math.log(2.0)) * 440.0);
    }
}

