/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jcollider.test;

import de.sciss.jcollider.Control;
import de.sciss.jcollider.GraphElem;
import de.sciss.jcollider.JCollider;
import de.sciss.jcollider.LagControl;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.ServerEvent;
import de.sciss.jcollider.ServerListener;
import de.sciss.jcollider.Synth;
import de.sciss.jcollider.SynthDef;
import de.sciss.jcollider.UGen;
import de.sciss.jcollider.UGenInfo;
import de.sciss.jcollider.gui.ControlSpec;
import de.sciss.jcollider.gui.EZSlider;
import de.sciss.jcollider.gui.ServerPanel;
import de.sciss.jcollider.gui.Warp;
import de.sciss.net.OSCMessage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class MotoRevCtrl
implements ServerListener {
    protected Server server = null;
    protected Synth synth = null;
    private static final String[] ctrlNames = new String[]{"pulseModFreq", "pulseFreqMin", "pulseFreqMax", "pulseWidth", "lowPassFreq", "amp"};
    private static final float[] ctrlLags = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f};
    private static final ControlSpec[] ctrlSpecs = new ControlSpec[]{new ControlSpec(0.01, 100.0, Warp.exp, 0.0, 0.2, "Hz"), new ControlSpec(0.1, 1000.0, Warp.exp, 0.0, 10.0, "Hz"), new ControlSpec(0.1, 1000.0, Warp.exp, 0.0, 30.0, "Hz"), new ControlSpec(0.01, 0.99, Warp.lin, 0.0, 0.5, null), new ControlSpec(20.0, 20000.0, Warp.exp, 0.0, 100.0, "Hz"), new ControlSpec(0.0, 1.0, Warp.lin, 0.0, 0.4, null)};
    private EZSlider[] ezs;
    private boolean defSent = false;

    public MotoRevCtrl() {
        String fs = File.separator;
        this.createControlWindow();
        try {
            UGenInfo.readBinaryDefinitions();
            this.server = new Server("myServer");
            File f = MotoRevCtrl.findFile(JCollider.isWindows ? "scsynth.exe" : "scsynth", new String[]{fs + "Applications" + fs + "SuperCollider_f", fs + "Applications" + fs + "SC3", fs + "usr" + fs + "local" + fs + "bin", fs + "usr" + fs + "bin", "C:\\Program Files\\SC3", "C:\\Program Files\\SuperCollider_f"});
            if (f != null) {
                Server.setProgram(f.getAbsolutePath());
            }
            this.server.addListener(this);
            try {
                this.server.start();
                this.server.startAliveThread();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        this.createServerWindow();
    }

    private static File findFile(String fileName, String[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            File f = new File(folders[i], fileName);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private void createServerWindow() {
        JFrame spf = ServerPanel.makeWindow(this.server, 255);
        spf.setDefaultCloseOperation(0);
    }

    private void createControlWindow() {
        GridBagLayout lay = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        JFrame win = new JFrame("Moto Rev Ctrl");
        win.setDefaultCloseOperation(2);
        win.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (MotoRevCtrl.this.server != null) {
                    try {
                        if (MotoRevCtrl.this.server.didWeBootTheServer()) {
                            MotoRevCtrl.this.server.quitAndWait();
                        } else if (MotoRevCtrl.this.synth != null) {
                            MotoRevCtrl.this.synth.free();
                        }
                    }
                    catch (IOException e1) {
                        System.err.println(e1);
                    }
                    MotoRevCtrl.this.synth = null;
                }
                System.exit(0);
            }
        });
        Container cp = win.getContentPane();
        JPanel p = new JPanel(lay);
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.ezs = new EZSlider[ctrlNames.length];
        con.gridwidth = 0;
        con.weightx = 1.0;
        con.fill = 2;
        con.insets = new Insets(2, 2, 2, 2);
        for (int i = 0; i < ctrlNames.length; ++i) {
            this.ezs[i] = new EZSlider();
            this.ezs[i].setControlSpec(ctrlSpecs[i]);
            this.ezs[i].setLabel(ctrlNames[i]);
            this.ezs[i].setValue(ctrlSpecs[i].getDefaultVal());
            lay.setConstraints(this.ezs[i], con);
            p.add(this.ezs[i]);
            new ControlListener(this.ezs[i]);
        }
        JToolBar tb = new JToolBar();
        tb.setBorderPainted(false);
        tb.setFloatable(false);
        final JToggleButton ggPlay = new JToggleButton(">");
        ggPlay.setFont(new Font("SansSerif", 0, 36));
        tb.add(ggPlay);
        ggPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MotoRevCtrl.this.server != null) {
                    if (MotoRevCtrl.this.synth != null) {
                        try {
                            MotoRevCtrl.this.synth.free();
                        }
                        catch (IOException e1) {
                            MotoRevCtrl.reportError(e1);
                        }
                        MotoRevCtrl.this.synth = null;
                    }
                    if (ggPlay.isSelected()) {
                        MotoRevCtrl.this.createSynth();
                    }
                }
            }
        });
        cp.add((Component)p, "Center");
        cp.add((Component)tb, "West");
        EZSlider.align(this.ezs);
        win.pack();
        win.setLocationRelativeTo(null);
        win.setVisible(true);
    }

    protected void createSynth() {
        try {
            int i;
            String defName = "MotoRevCtrl";
            float[] ctrlValues = new float[this.ezs.length];
            for (i = 0; i < ctrlValues.length; ++i) {
                ctrlValues[i] = (float)this.ezs[i].getValue();
            }
            this.synth = Synth.basicNew(defName, this.server);
            OSCMessage newMsg = this.synth.newMsg(this.server.asTarget(), ctrlNames, ctrlValues);
            if (!this.defSent) {
                float[] ctrlDefaults = new float[ctrlSpecs.length];
                for (i = 0; i < ctrlDefaults.length; ++i) {
                    ctrlDefaults[i] = (float)ctrlSpecs[i].getDefaultVal();
                }
                Control out = Control.kr("out", 0.0f);
                Control lagCtrl = LagControl.kr(ctrlNames, ctrlDefaults, ctrlLags);
                GraphElem pulseModFreq = lagCtrl.getOutput(0);
                GraphElem pulseFreqMin = UGen.kr("min", lagCtrl.getOutput(1), lagCtrl.getOutput(2));
                GraphElem pulseFreqMax = UGen.kr("max", lagCtrl.getOutput(1), lagCtrl.getOutput(2));
                GraphElem pulseWidth = lagCtrl.getOutput(3);
                GraphElem lowPassFreq = lagCtrl.getOutput(4);
                GraphElem amp = lagCtrl.getOutput(5);
                GraphElem pulseFreqMul = UGen.kr("*", UGen.kr("-", pulseFreqMax, pulseFreqMin), UGen.ir(0.5f));
                GraphElem pulseFreqAdd = UGen.kr("+", pulseFreqMin, pulseFreqMul);
                GraphElem pulseFreq = UGen.kr("MulAdd", UGen.kr("SinOsc", pulseModFreq), pulseFreqMul, pulseFreqAdd);
                GraphElem pulse = UGen.ar("LFPulse", pulseFreq, UGen.ir(0.1f), pulseWidth);
                GraphElem filter = UGen.ar("RLPF", pulse, lowPassFreq, UGen.ir(0.1f));
                GraphElem clip = UGen.ar("clip2", filter, amp);
                GraphElem ugenGraph = UGen.ar("Out", out, clip);
                SynthDef def = new SynthDef(defName, ugenGraph);
                def.send(this.server, newMsg);
                this.defSent = true;
            } else {
                this.server.sendMsg(newMsg);
            }
        }
        catch (IOException e1) {
            MotoRevCtrl.reportError(e1);
        }
    }

    private void initServer() throws IOException {
        if (!this.server.didWeBootTheServer()) {
            this.server.initTree();
        }
        this.defSent = false;
    }

    protected static void reportError(Exception e) {
        System.err.println(e.getClass().getName() + " : " + e.getLocalizedMessage());
    }

    public void serverAction(ServerEvent e) {
        switch (e.getID()) {
            case 0: {
                try {
                    this.initServer();
                }
                catch (IOException e1) {
                    MotoRevCtrl.reportError(e1);
                }
                break;
            }
            case 1: {
                this.synth = null;
                Timer t = new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (MotoRevCtrl.this.server != null) {
                                MotoRevCtrl.this.server.startAliveThread();
                            }
                        }
                        catch (IOException e1) {
                            MotoRevCtrl.reportError(e1);
                        }
                    }
                });
                t.setRepeats(false);
                t.start();
                break;
            }
        }
    }

    private class ControlListener
    implements ActionListener {
        private final EZSlider ez;

        protected ControlListener(EZSlider ez) {
            this.ez = ez;
            ez.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (MotoRevCtrl.this.synth != null) {
                try {
                    MotoRevCtrl.this.synth.set(this.ez.getLabel(), (float)this.ez.getValue());
                }
                catch (IOException e1) {
                    MotoRevCtrl.reportError(e1);
                }
            }
        }
    }
}

