/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.NetUtil;
import de.sciss.net.OSCChannel;
import de.sciss.net.OSCException;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

public abstract class OSCTransmitter
implements OSCChannel {
    protected final Object sync = new Object();
    protected boolean allocBuf = true;
    private int bufSize = 8192;
    protected ByteBuffer byteBuf = null;
    protected int dumpMode = 0;
    protected PrintStream printStream = null;
    private OSCPacketCodec c;
    private final String protocol;
    protected SocketAddress target = null;
    protected final InetSocketAddress localAddress;
    protected final boolean revivable;

    protected OSCTransmitter(OSCPacketCodec c, String protocol, InetSocketAddress localAddress, boolean revivable) {
        this.c = c;
        this.protocol = protocol;
        this.localAddress = localAddress;
        this.revivable = revivable;
    }

    public static OSCTransmitter newUsing(String protocol) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), protocol);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, String protocol) throws IOException {
        return OSCTransmitter.newUsing(c, protocol, 0);
    }

    public static OSCTransmitter newUsing(String protocol, int port) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, String protocol, int port) throws IOException {
        return OSCTransmitter.newUsing(c, protocol, port, false);
    }

    public static OSCTransmitter newUsing(String protocol, int port, boolean loopBack) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port, loopBack);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, String protocol, int port, boolean loopBack) throws IOException {
        InetSocketAddress localAddress = loopBack ? new InetSocketAddress("127.0.0.1", port) : new InetSocketAddress(InetAddress.getLocalHost(), port);
        return OSCTransmitter.newUsing(c, protocol, localAddress);
    }

    public static OSCTransmitter newUsing(String protocol, InetSocketAddress localAddress) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, localAddress);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, String protocol, InetSocketAddress localAddress) throws IOException {
        if (protocol.equals("udp")) {
            return new UDPOSCTransmitter(c, localAddress);
        }
        if (protocol.equals("tcp")) {
            return new TCPOSCTransmitter(c, localAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + protocol);
    }

    public static OSCTransmitter newUsing(DatagramChannel dch) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), dch);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, DatagramChannel dch) throws IOException {
        return new UDPOSCTransmitter(c, dch);
    }

    public static OSCTransmitter newUsing(SocketChannel sch) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), sch);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec c, SocketChannel sch) throws IOException {
        return new TCPOSCTransmitter(c, sch);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public abstract InetSocketAddress getLocalAddress();

    public void setTarget(SocketAddress target) {
        this.target = target;
    }

    public void setCodec(OSCPacketCodec c) {
        this.c = c;
    }

    public OSCPacketCodec getCodec() {
        return this.c;
    }

    public abstract void connect() throws IOException;

    public abstract boolean isConnected();

    public final void send(OSCPacket p, SocketAddress target) throws IOException {
        this.send(this.c, p, target);
    }

    public abstract void send(OSCPacketCodec var1, OSCPacket var2, SocketAddress var3) throws IOException;

    public final void send(OSCPacket p) throws IOException {
        this.send(p, this.target);
    }

    public abstract void send(OSCPacketCodec var1, OSCPacket var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) {
        Object object = this.sync;
        synchronized (object) {
            if (this.bufSize != size) {
                this.bufSize = size;
                this.allocBuf = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        Object object = this.sync;
        synchronized (object) {
            return this.bufSize;
        }
    }

    public void dumpOSC(int mode, PrintStream stream) {
        this.dumpMode = mode;
        this.printStream = stream == null ? System.err : stream;
    }

    public void dispose() {
        this.byteBuf = null;
    }

    protected void checkBuffer() {
        if (this.allocBuf) {
            this.byteBuf = ByteBuffer.allocateDirect(this.bufSize);
            this.allocBuf = false;
        }
    }

    protected abstract SelectableChannel getChannel();

    private static class TCPOSCTransmitter
    extends OSCTransmitter {
        private SocketChannel sch;

        protected TCPOSCTransmitter(OSCPacketCodec c, InetSocketAddress localAddress) {
            super(c, "tcp", localAddress, true);
        }

        protected TCPOSCTransmitter(OSCPacketCodec c, SocketChannel sch) {
            super(c, "tcp", new InetSocketAddress(sch.socket().getLocalAddress(), sch.socket().getLocalPort()), false);
            this.sch = sch;
            if (sch.isConnected()) {
                this.setTarget(sch.socket().getRemoteSocketAddress());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetSocketAddress getLocalAddress() {
            Object object = this.sync;
            synchronized (object) {
                if (this.sch != null) {
                    Socket s = this.sch.socket();
                    return new InetSocketAddress(s.getLocalAddress(), s.getLocalPort());
                }
                return this.localAddress;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectableChannel getChannel() {
            Object object = this.sync;
            synchronized (object) {
                return this.sch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            Object object = this.sync;
            synchronized (object) {
                if (this.sch != null && !this.sch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.sch = null;
                }
                if (this.sch == null) {
                    SocketChannel newCh = SocketChannel.open();
                    newCh.socket().bind(this.localAddress);
                    this.sch = newCh;
                }
                if (!this.sch.isConnected()) {
                    this.sch.connect(this.target);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConnected() {
            Object object = this.sync;
            synchronized (object) {
                return this.sch != null && this.sch.isConnected();
            }
        }

        public void dispose() {
            super.dispose();
            if (this.sch != null) {
                try {
                    this.sch.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.sch = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(OSCPacketCodec c, OSCPacket p, SocketAddress target) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                if (target != null && !target.equals(this.target)) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotBoundToAddress") + target);
                }
                this.send(c, p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(OSCPacketCodec c, OSCPacket p) throws IOException {
            try {
                Object object = this.sync;
                synchronized (object) {
                    if (this.sch == null) {
                        throw new IOException(NetUtil.getResourceString("errChannelNotConnected"));
                    }
                    this.checkBuffer();
                    this.byteBuf.clear();
                    this.byteBuf.position(4);
                    c.encode(p, this.byteBuf);
                    int len = this.byteBuf.position() - 4;
                    this.byteBuf.flip();
                    this.byteBuf.putInt(0, len);
                    if (this.dumpMode != 0) {
                        this.printStream.print("s: ");
                        if ((this.dumpMode & 1) != 0) {
                            OSCPacket.printTextOn(this.printStream, p);
                        }
                        if ((this.dumpMode & 2) != 0) {
                            OSCPacket.printHexOn(this.printStream, this.byteBuf);
                            this.byteBuf.flip();
                        }
                    }
                    this.sch.write(this.byteBuf);
                }
            }
            catch (BufferOverflowException e1) {
                throw new OSCException(2, p instanceof OSCMessage ? ((OSCMessage)p).getName() : p.getClass().getName());
            }
        }
    }

    private static class UDPOSCTransmitter
    extends OSCTransmitter {
        private DatagramChannel dch;

        protected UDPOSCTransmitter(OSCPacketCodec c, InetSocketAddress localAddress) {
            super(c, "udp", localAddress, true);
        }

        protected UDPOSCTransmitter(OSCPacketCodec c, DatagramChannel dch) {
            super(c, "udp", new InetSocketAddress(dch.socket().getLocalAddress(), dch.socket().getLocalPort()), false);
            this.dch = dch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectableChannel getChannel() {
            Object object = this.sync;
            synchronized (object) {
                return this.dch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetSocketAddress getLocalAddress() {
            Object object = this.sync;
            synchronized (object) {
                if (this.dch != null) {
                    DatagramSocket ds = this.dch.socket();
                    return new InetSocketAddress(ds.getLocalAddress(), ds.getLocalPort());
                }
                return this.localAddress;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            Object object = this.sync;
            synchronized (object) {
                if (this.dch != null && !this.dch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.dch = null;
                }
                if (this.dch == null) {
                    DatagramChannel newCh = DatagramChannel.open();
                    newCh.socket().bind(this.localAddress);
                    this.dch = newCh;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConnected() {
            Object object = this.sync;
            synchronized (object) {
                return this.dch != null && this.dch.isOpen();
            }
        }

        public void dispose() {
            super.dispose();
            if (this.dch != null) {
                try {
                    this.dch.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.dch = null;
            }
        }

        public void send(OSCPacketCodec c, OSCPacket p) throws IOException {
            this.send(c, p, this.target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(OSCPacketCodec c, OSCPacket p, SocketAddress target) throws IOException {
            try {
                Object object = this.sync;
                synchronized (object) {
                    if (this.dch == null) {
                        throw new IOException(NetUtil.getResourceString("errChannelNotConnected"));
                    }
                    this.checkBuffer();
                    this.byteBuf.clear();
                    c.encode(p, this.byteBuf);
                    this.byteBuf.flip();
                    if (this.dumpMode != 0) {
                        this.printStream.print("s: ");
                        if ((this.dumpMode & 1) != 0) {
                            OSCPacket.printTextOn(this.printStream, p);
                        }
                        if ((this.dumpMode & 2) != 0) {
                            OSCPacket.printHexOn(this.printStream, this.byteBuf);
                            this.byteBuf.flip();
                        }
                    }
                    this.dch.send(this.byteBuf, target);
                }
            }
            catch (BufferOverflowException e1) {
                throw new OSCException(2, p instanceof OSCMessage ? ((OSCMessage)p).getName() : p.getClass().getName());
            }
        }
    }
}

