SynMultiSeq {
  var seqDic; //Dictionary of SynSeqs
  var playerDic; //Dictionary of EventStreamPlayers
  var timer;
  var net;
  
  *new { arg clock, n;
		^super.new.init(clock, n);
	}
	
	init { arg clock, n;
	  seqDic = Dictionary.new;
	  playerDic = Dictionary.new;
	  timer = clock;
	  net = n;
	}
  
  add { arg id, seq, play;
    var beatToStart, player;
    seq.id = id;
    seqDic.add(id -> seq);
    
    if (play > 0, {
      beatToStart = timer.nextTimeOnGrid(1, -0.001);
      net.sendMsg("/startBeatGraph", beatToStart - timer.beats);
	    timer.schedAbs(beatToStart, {
	      "Starting to play pattern...".postln;
	      player = seq.pattern.play;
	      playerDic.add(id -> player);
      });
    });
  }
  
  getSeq { arg id;
    ^seqDic.at(id);
  }
  
  removeAllSeq {
    seqDic.do({ arg seq;
      this.removeSeq(seq.id);
    });
  }
  
  removeSeq { arg id;
    ("Stopping pattern#" ++ id).postln;
    playerDic.at(id).stop;
    playerDic.removeAt(id);
    seqDic.removeAt(id);
  }
  
  getPlayer { arg id;
    ^playerDic.at(id);
  }
  
  pausePlayer { arg id;
    playerDic.at(id).pause;
  }
  
  resumePlayer { arg id;
    net.sendMsg("/resumeBeatGraph", id, timer.nextTimeOnGrid(1, -0.001) - timer.beats);
    playerDic.at(id).resume(timer, 1);
  }
}

