SynesComm {        
        var acResp;     // OSCnodeResponder for beat graph change listening
        var dbgResp;     // OSCnodeResponder for dbg listening
        
        var timer;
        var recvFrom;
        var sendTo;
        var mseq;
        
        *new { arg clock, rcv, snd, seq;
          ^super.new.init(clock, rcv, snd, seq);
        }
        
        init { arg clock, rcv, snd, seq;
          timer = clock;
          recvFrom = rcv;
          sendTo = snd;
          mseq = seq;
          
          this.prSendInitMsg;
          this.prInitResponders;
        }
        
        prSendInitMsg {
          ("Sending init message...").postln;
          
          sendTo.sendMsg("/init", 57110, NetAddr.langPort);
        }
        
        prInitResponders {
            //Create OSC responders
            acResp = OSCresponderNode(recvFrom, '/change', { arg time, resp, msg;
                msg.postln;
                { this.prProcessMsg(msg[1].asString.split($;)); }.defer;
            }).add;
            
            dbgResp = OSCresponderNode(recvFrom, '/quit', { arg time, resp, msg;
                ("Received /quit msg!").postln;
                acResp.remove;
                mseq.removeAllSeq;
            }).add;
            
            ("Listening for msgs from " ++ recvFrom).postln;
        }
        
        prProcessMsg { arg msg;
          var beatData;
          
          msg[1] = msg[1].asInteger;  //id
          
          if (msg[0] == "addBeat" or: {msg[0] == "updateBeat"}, {
              msg[2] = msg[2].asInteger;  //group id
              msg[3] = msg[3].asInteger;  //pos
              beatData = msg[4].split($,);
              beatData[0] = beatData[0].asFloat;
              beatData[1] = beatData[1].asSymbol;
              beatData[2] = beatData[2].asFloat;
              beatData[3] = beatData[3].asFloat;
              beatData[4] = beatData[4].asFloat;
          });
          
          switch (msg[0],
            "addBeat", {
              this.prProcessAddUpdate(msg[0], msg[1], msg[2], msg[3], beatData);
            },
            "updateBeat", {
              this.prProcessAddUpdate(msg[0], msg[1], 0, msg[3], beatData);
            },
            "removeGraph", {
              this.prProcessRemoveGraph(msg[0], msg[1]);
            },
            "pause", {
              this.prProcessPauseResume(msg[0], msg[1]);
            },
            "resume", {
              this.prProcessPauseResume(msg[0], msg[1]);
            }
          );
        }
        
        prProcessAddUpdate { arg action, rcvdId, rcvdGID, rcvdPos, beatData;
          var play = 0;
          var seq = mseq.getSeq(rcvdId);
          
          ("ID: " + rcvdId).postln;
          
          if (action == "addBeat", {
            if (seq.isNil, {
              seq = SynSeq.new;
              seq.grpID = rcvdGID;
              play = 1;
              ("Will play!").postln;
            });
            
            seq.addBeat(rcvdPos, beatData);

            mseq.add(rcvdId, seq, play);
          },{ //updateBeat
            seq.updateBeat(rcvdPos, beatData);
          });
        }
        
        prProcessRemoveGraph { arg action, id;
          mseq.removeSeq(id);
        }
        
        prProcessPauseResume { arg action, rcvdId;
          if (action == "pause", {
            mseq.pausePlayer(rcvdId);
          },{
            mseq.resumePlayer(rcvdId);
          });
        }
}
