(
  /****************************************************************************/
  /* Sounds & Samples                                                         */
  /****************************************************************************/
  
  b = Buffer.read(s, p ++ "/SuperCollider/samples/acid.wav");
  

  /****************************************************************************/
  /* Modulatable Synths                                                       */
  /****************************************************************************/
  
  //FM
  SynthDef(\synes_fmsine, { |x = 0, y = 69, amp = 0.1, modDist = 1.0, modAmp = 0.1, gate = 1, out|
    var fmModFreq = 1 / modDist.exp * 200;
    var modIndex = (modAmp * 5).exp - 1;
    var fm = modIndex * fmModFreq * SinOsc.ar(fmModFreq);
    
    var sineBase = y.midicps;
    var sig = SinOsc.ar(sineBase + fm, 0, 2.0 * amp);
    
    sig = Linen.kr(gate, 0.25, 1.0, 0.5, doneAction: 2) * sig;
    
    sig = sig.distort * amp;
    
    Out.ar(out, Pan2.ar(sig, x))
  }).store;
  
  //Noise
  SynthDef(\synes_noise, { |x = 0, y = 0, amp = 0.1, modDist = 1.0, modAmp = 0.1, gate = 1, out|
    var noise = Crackle.ar(1.0 + modAmp, modDist * 30).distort;
    var sig = LPF.ar(noise, 100 + ((y+1) * 10000), 1.0);
    
    sig = Linen.kr(gate, 0.25, 1.0, 0.5, doneAction: 2) * sig;
    
    sig = sig.softclip * amp;
    
    Out.ar(out, Pan2.ar(sig, x))
  }).store;
  
  //Scratch
  SynthDef(\synes_scratch, { |x = 0, y = 0, amp = 0.1, modX = 0.0, modY = 0.0, modAmp = 0.1, gate = 1, bufnum = 0, out|
    var delay;
    var sig = BufRd.ar(1, bufnum, K2A.ar(BufFrames.ir(bufnum) * modX.lag(modY)), 1, 2);
    
    delay = CombL.ar(sig, 1, (y + 1) / 2, 0.2); //max. delay: 1 sec.
    sig = sig + (delay * 0.3);
    sig = sig * (modAmp.exp * 10);
    sig = sig.distort * amp;
    
    Out.ar(out, Pan2.ar(sig, x))
  }).store;
  
  
  //Stream
  SynthDef(\synes_stream, { |x = 0, y = 69, amp = 0.1, modDist = 1.0, modAmp = 0.1, gate = 1, out|
    var delay, phaser, phaserDelay = 0.2 * modAmp, phaserFreq = 1 / modDist, ffreq = 200, width = 0.3,
		  detune = 1.005, preamp = (modAmp * 5).exp;
    var freq = y.midicps;
    var sig = Mix(VarSaw.ar([freq, freq * detune], 0, width, preamp)).distort * amp;

    sig = AllpassN.ar(sig, phaserDelay, SinOsc.kr(phaserFreq, 0, phaserDelay / 2, phaserDelay / 2)); //max delay of 20msec

	  sig = LPF.ar(sig, ffreq);
	  
	  //delay = CombL.ar(sig, 1, 0.5, 0.2);
	  //sig = sig + (delay * 0.3);
	  
	  sig = Linen.kr(gate, 0.25, 1.0, 0.5, doneAction: 2) * sig;
	  
	  sig = sig.softclip;

    Out.ar(out, Pan2.ar(sig, x))
  }).store;
  
  //Blip
  SynthDef(\synes_blip, { |x = 0, y = 69, amp = 0.1, modDist = 1.0, modAmp = 0.1, gate = 1, out|
    var pitch = y.midicps;
    var harm = modAmp * 50;
    var sig = Mix.ar(Array.fill(3, { arg i;
      Blip.ar(pitch, SinOsc.kr((0.75 / modDist).exp, Rand(0, pi), harm, harm + 1))
		}) );
		
    sig = FreeVerb.ar(sig, 0.5, 0.5, 0.5);
    sig = Linen.kr(gate, 0.25, 1.0, 0.5, doneAction: 2) * sig;
    sig = sig.softclip * amp;
    
    Out.ar(out, Pan2.ar(sig, x))
  }).store;
  
  //Apad - Orig. Author: Mike Hairston
  SynthDef(\synes_apad, {  |x = 0, y = 69, amp = 0.1, modDist = 1.0, modAmp = 0.1, gate = 1, out|
    var attack=0.4, decay=0.5, sustain=0.8, release=1.0;
	  var env,sig,mod1,mod2,mod3;
	  var freq = y.midicps;
	  var variation = (2 / modDist).exp / 100;
	
	  env=EnvGen.kr(Env.adsr(attack,decay,sustain,release),gate,doneAction:2);
	  mod1=SinOsc.kr(6).range(freq* (1 - variation), freq * (1 + variation)) * ((modAmp + 1) * 2);
	  mod2=LFNoise2.kr(1).range(0.2,1);
	  mod3=SinOsc.kr(rrand(4.0,6.0)).range(0.5,1);
	  sig=Mix(SinOsc.ar([freq,mod1],0,env).distort);
	
	  sig=sig*mod2*mod3;
	  sig = LPF.ar(sig, 200) * 3;
	
	  sig = Linen.kr(gate, 0.25, 1.0, 0.5, doneAction: 2) * sig;
	  
	  sig = sig.softclip * amp;
	
	  Out.ar(out, Pan2.ar(sig, x))
  }
  ).store;

  /****************************************************************************/
  /* Sequencer Synths - Rhythm Instruments (Pitch is the normalized y-Coord.) */
  /****************************************************************************/

  SynthDef(\synes_hihat, { | pan = 0, pitch = 0, sustain = 0.1 , amp = 0.1,  out|
    var freq = 15000;
    var rq = 0.05 + (-0.03 * pitch);
    var decay = 0.05 + sustain / 2 + pitch / 2;
    var preamp = 150;
    
	  var	sig = PinkNoise.ar(preamp),
		  env = EnvGen.kr(Env.perc(0.01, decay), doneAction: 2);
		
	  sig = BPF.ar(sig, freq, rq, env);
    sig = sig.softclip * amp;
    
	  Out.ar(out, Pan2.ar(sig, pan))
  }).store;

  SynthDef(\synes_snare, { | pan = 0, pitch = 0, sustain = 0.1 , amp = 0.1,  out|
    var freq = 1000 + (((pitch+1)/2) * 2000);
    var rq = 3;
    var decay = 0.2 + sustain / 2 + pitch / 2;
    var preamp = 2;
    
	  var	sig = PinkNoise.ar(preamp),
		  env = EnvGen.kr(Env.perc(0.01, decay), doneAction: 2);

	  sig = BPF.ar(sig, freq, rq, env);
    sig = sig.softclip * amp;

	  Out.ar(out, Pan2.ar(sig, pan))
  }).store;

  /****************************************************************************/
  /* Sequencer Synths - Melody Instruments (use MIDI-Notes)                   */
  /****************************************************************************/
  
  /**
   * @author Scott Wilson (modified by Markus Konrad)
   */
  SynthDef(\synes_bass, { |pan = 0, pitch = 69, sustain = 0.1, amp = 0.1, dur = 1.0, gate = 1, out|
    var ffreq = 200, width = 0.3,
		  detune = 1.005, preamp = (amp+0.9) * 5;
    var freq = pitch.midicps;
  //  var env = Env.adsr(0.01, 0.3, 0.4, sustain);
    var env = Env.perc(0.01, dur + sustain);
    var sig = Mix(VarSaw.ar([freq, freq * detune], 0, width, preamp)).distort * amp
		  * EnvGen.kr(env, gate, doneAction: 2);

	  sig = LPF.ar(sig, ffreq);

    Out.ar(out, Pan2.ar(sig, pan))
  }).store;
  
  /**
   * @author
   */
  SynthDef(\synes_kick, { |pan = 0, pitch = 0, sustain = 0.1, amp = 0.1, dur = 1.0,  out|
      var sweeptime = 0.1;
      var preamp = amp * 20;
		  var decay1 = 0.3;
		  var decay1L = 0.8 + dur / 4;
		  var basefreq = pitch.midicps;
		  var decay2 = dur + sustain;
		  var ratio;
		  var fcurve, env, sig;
	  
	  var sigamp = amp;  
	  amp = (amp+0.9) * 0.55;
	  ratio = amp * 50 + 2;
	    
	  fcurve = EnvGen.kr(Env([basefreq * ratio, basefreq], [sweeptime], \exp));
		env = EnvGen.kr(Env([1, decay1L, 0], [decay1, decay2], -4), doneAction: 2);
		sig = SinOsc.ar(fcurve, 0.5pi, preamp).distort * env * amp;
    sig = sig.softclip * sigamp;
    
    Out.ar(out, Pan2.ar(sig, pan))
  }).store;

  /**
   * @author jeff, based on an old example by james mcc
   *         (slightly modified by Markus Konrad)
   */
  SynthDef(\synes_piano, { | pan = 0, pitch = 69, sustain = 0.1 , amp = 0.1, dur = 1.0,  out|
	  var sig, in, n = 6, max = 0.04, min = 0.01, delay, detune, hammer;
    var sigamp = amp;
    amp = (amp+0.9) * 0.4;
    
	  hammer = Decay2.ar(Impulse.ar(0.001), 0.008, 0.04, LFNoise2.ar([2000,4000].asSpec.map(amp), 0.25));
	  
	  sig = Mix.ar(Array.fill(3, { arg i;
			  detune = #[-0.04, 0, 0.03].at(i);
			  delay = (1/(pitch + detune).midicps);
			  CombL.ar(hammer, delay, delay, 50 * amp)
		  }) );
		
	  sig = HPF.ar(sig,50) * EnvGen.ar(Env.perc(0.0001, dur + sustain, amp * 4, -1), doneAction:2);
	  sig = sig.softclip * sigamp;
	  		
	  Out.ar(out, Pan2.ar(sig, pan));
  },
  metadata: (
	  credit: "based on something posted 2008-06-17 by jeff, based on an old example by james mcc",
	  tags: [\casio, \piano, \pitched]
	  )
  ).store;
  
  /****************************************************************************/
  /* Control synths                                                           */
  /****************************************************************************/
  
  SynthDef(\fadeCtrl, { arg ctrlBusIndex = 0, startAmp=0.1, endAmp=0.0, dur=0.5;
	  Out.kr(ctrlBusIndex, Line.kr(startAmp, endAmp, dur, doneAction: 2));
  }).store; 
)
