#include "Framework.hpp"
#include "../game/GameMenu.hpp"

bool CFramework::Init(int ScreenWidth, int ScreenHeight,
                      int ColorDepth, bool bFullscreen)
{
	//Zufallsgenerator starten
	srand((unsigned)time(NULL));

	//Standardeigenschaften festlegen
	m_bFullScreen = bFullscreen;
	m_SDLSrfRes = NULL;

	// Alle Systeme der SDL initialisieren
	if (SDL_Init(SDL_INIT_TIMER | SDL_INIT_VIDEO) == -1)
	{
		cerr << "SDL konnte nicht initialisiert werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError () << endl;

		Quit ();

		return false;
	}

	//GraKa Infos bekommen
	m_pVideoInfo = SDL_GetVideoInfo();

	if (m_pVideoInfo == NULL)
	{
		cerr << "Grafikkarte-Informationen konnten nicht abgefragt werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError() << endl;

		Quit();

		return false;
	}

	//Videomodus einstellen
	m_videoFlags = SDL_OPENGL | SDL_DOUBLEBUF | SDL_HWPALETTE;

	if (m_pVideoInfo->hw_available)
		m_videoFlags = m_videoFlags | SDL_HWSURFACE;
	else
		m_videoFlags = m_videoFlags | SDL_SWSURFACE;

	if (m_pVideoInfo->blit_hw)
		m_videoFlags = m_videoFlags | SDL_HWACCEL;

	if (bFullscreen == true)
	{
		m_SDLSrfRes = SDL_SetVideoMode(ScreenWidth, ScreenHeight, ColorDepth, m_videoFlags | SDL_FULLSCREEN);
	}
	else
	{
		m_SDLSrfRes = SDL_SetVideoMode(ScreenWidth, ScreenHeight, ColorDepth, m_videoFlags);
	}

	// Pr�fen, ob alles funktioniert hat
	if (m_SDLSrfRes == NULL)
	{
		cerr << "Videomodus konnte nicht gesetzt werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError () << endl;

		Quit();

		return false;
	}

    if(!InitGL())
	{
		cerr << "OpenGL konnte nicht initialisiert werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError () << endl;

		Quit();

		return false;
	}

	//Fenstertitel setzen
	SDL_WM_SetCaption(WINDOW_TITLE, NULL);

	// Zeiger auf internes Array f�r Tastaturstatus ermitteln
	m_pKeystate = SDL_GetKeyState(NULL);

	//Cursor ausblenden
	SDL_ShowCursor(false);

	// Alles ging glatt, also true zur�ckliefern
	return true;
}

void CFramework::SwitchFullscreen()
{
	m_bFullScreen = !m_bFullScreen;

	if (m_bFullScreen)
		m_SDLSrfRes = SDL_SetVideoMode(m_SDLSrfRes->w, m_SDLSrfRes->h, m_SDLSrfRes->format->BitsPerPixel, m_videoFlags | SDL_FULLSCREEN);
	else
		m_SDLSrfRes = SDL_SetVideoMode(m_SDLSrfRes->w, m_SDLSrfRes->h, m_SDLSrfRes->format->BitsPerPixel, m_videoFlags);

	if (m_SDLSrfRes == NULL)
	{
		cerr << "Vollbild konnte nicht gewechselt werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError () << endl;

		Quit();
	}

    /*if(!InitGL())
	{
		cerr << "OpenGL konnte nicht initialisiert werden!" << endl;
		cerr << "Fehlermeldung: " << SDL_GetError () << endl;

		Quit();
	}*/
}


bool CFramework::InitGL()
{
	SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
	SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 5 );
	SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
	SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

	//Set clear color
    glClearColor(0, 0, 0, 0);

	//Texturen benutzen!
	glEnable(GL_TEXTURE_2D);

	//Schattenwurf
	glShadeModel(GL_FLAT);

    //Set projection
	glViewport(0, 0, (GLsizei) SCREEN_RES_X, (GLsizei) SCREEN_RES_Y);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f,(GLfloat)SCREEN_RES_X/(GLfloat)SCREEN_RES_Y,0.1f,100.0f);

    //Initialize modelview matrix
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

	//Initialize Depthbuffer & normalizing
	glEnable(GL_DEPTH_TEST);	//Tiefenbuffer wird benutzt! (L�sst sich immer aktivieren, bzw. deaktivieren mitten im Code
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glEnable(GL_NORMALIZE);

	//Turn on the lights...
	InitGLLight();

	//Enable Blending
	glColor4f(1.0f,1.0f,1.0f,0.5f);			// Full Brightness, 50% Alpha ( NEW )
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	//Global Material settings
	float fMatAmb[] = {0.23, 0.23, 0.23, 1.0};
	float fMatDif[] = {0.28, 0.28, 0.28, 1.0};
	float fMatSpe[] = {0.77, 0.77, 0.77, 1.0};

	glMaterialfv(GL_FRONT, GL_AMBIENT, fMatAmb);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, fMatDif);
	glMaterialfv(GL_FRONT, GL_SPECULAR, fMatSpe);
	glMaterialf(GL_FRONT, GL_SHININESS, 89.6);

    //If there were any errors
    if(glGetError() != GL_NO_ERROR)
    {
        return false;
    }

    //... and let the show begin!
    return true;
}

void CFramework::InitGLLight()
{
	GLfloat fLightAmbient[]= { 0.7f, 1.0f, 0.7f, 1.0f };
	GLfloat fLightDiffuse[]= { 0.9f, 1.0f, 0.9f, 1.0f };
	GLfloat fLightPosition[]= { -1.0f, 1.0f, 0.0f, 1.0f };

	//glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.0);
	glLightfv(GL_LIGHT1, GL_AMBIENT, fLightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, fLightDiffuse);
	glLightfv(GL_LIGHT1, GL_POSITION, fLightPosition);

	glLightfv(GL_LIGHT0, GL_AMBIENT, fLightAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, fLightDiffuse);
	glLightfv(GL_LIGHT0, GL_POSITION, fLightPosition);

	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHTING);
}

void CFramework::Quit ()
{
	g_pGameMenu->Del();
	g_pModel->Del();
	g_pText->Del();
	g_pTexture->Del();
	g_pTimer->Del();

	// SDL beenden
	SDL_Quit ();
}


void CFramework::Update()
{
	// Timer updaten
	g_pTimer->Update();

	// Tastaturstatus ermitteln
	m_bEvents = (bool)SDL_PollEvent(&m_Event);

	//Vollbildwechsel-Taste: F2
	SDL_Event* pEvent = GetEvent();

	if (pEvent != NULL && pEvent->type == SDL_KEYDOWN && pEvent->key.keysym.sym == SDLK_F2)
	{
		SwitchFullscreen();
	}

	SDL_PumpEvents();
}

SDL_Event* CFramework::GetEvent()
{
	if (m_bEvents)
		return &m_Event;
	else
		return NULL;
}

bool CFramework::KeyDown(int Key_ID)
{
	// Pr�fen, ob Taste gedr�ckt ist
	return (m_pKeystate[Key_ID] ? true : false);
}


void CFramework::Flip()
{
	SDL_GL_SwapBuffers();
}
