#ifndef FRAMEWORK_HPP
#define FRAMEWORK_HPP

#include <iostream>
#include <time.h>
#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>

#include "../globals.hpp"
#include "../tools/Singleton.hpp"
#include "../tools/Timer.hpp"
#include "../gfx/Texture.hpp"
#include "../gfx/Model.hpp"
#include "../gfx/Text.hpp"
#include "../gfx/Texture.hpp"


using namespace std;

/// Zugriff auf das Framwork via Makro
#define g_pFramework CFramework::Get()

/// Framework Klasse. Initialisiert Anwendung und stellt Schnittstellen
/// und Funktionen f�r den allgemeinen Programmablauf zur Verf�gung.
/// Die Framework Klasse ist als Singleton Objekt per Makro "g_pFramework"
/// im gesamten Projekt anzusteuern
class CFramework : public TSingleton<CFramework>
{
	public:
		/// Initialiserung der Anwendung:
		/// SDL initialisieren, Vollbild/Fenstermodus starten, OpenGL Parameter
		/// setzen
		/// @param ScreenWidth	Bildschirmbreite
		/// @param ScreenHeight	Bildschirmh�he
		/// @param ColorDepth	Farbtiefe
		/// @param bFullscreen	Vollbild?
		bool  Init(int ScreenWidth, int ScreenHeight, int ColorDepth, bool bFullscreen);

		/// Framework beenden & Speicher freigeben:
		/// Aufrufen der Quit() Funktionen anderer Klassen
		/// Beenden von SDL
		void Quit();

		/// Timer und Keyboardstatus updaten
		void Update();

		/// Doppelbuffer austauschen!
		void Flip();

		/// Fullscreen an/aus
		/// Achtung: Funktioniert noch nicht richtig!
		void SwitchFullscreen();

		/// Event-Pointer zur�ckliefern
		///@return Event-Pointer
		SDL_Event* GetEvent();

		/// Tastendruck abfragen
		/// @param Key_ID Tasten-ID
		/// @see http://www.libsdl.org/cgi/docwiki.cgi/SDLKey
		bool  KeyDown(int Key_ID);

	private:
		/// OpenGL Parameter setzen
		bool  InitGL();

		/// OpenGL: Globale Lichteinstellungen setzen
		void  InitGLLight();

		
		Uint8 *m_pKeystate;	///< Array f�r aktuellen Tastaturstatus
		SDL_Event m_Event; ///< Events werden hier gespeichert
		bool m_bEvents; ///< Sind Events aufgetreten?
		bool m_bFullScreen;	///< Fullscreen?
		Uint32 m_videoFlags;	///< Video-Flags
		const SDL_VideoInfo* m_pVideoInfo;	///< GraKa-Infos
		SDL_Surface* m_SDLSrfRes;	///< SDL Bildschirm
};

#endif
