#include "TestClient.hpp"

CTestClient::CTestClient(void)
{
	m_bGameRunning = false;
	
	m_pMutex = SDL_CreateMutex();
	m_nAuthToken = 0;	//Muss vor dem Registrieren 0 sein, da Initialisierung beim ServerClient -> sonst Abbruch
	m_pTestThread = NULL;
	init_sdl();
	init_net();

	Start();
	m_sPlayerStats.fFuel = 100.0;
	m_sPlayerStats.fMaxFuel = 100.0;
	m_sPlayerStats.fDamage = 0.0;
	m_sPlayerStats.fMaxDamage = 0.0;
	m_sPlayerStats.fAngleX = 0.0;
	m_sPlayerStats.fAngleY = 0.0;
	m_sPlayerStats.fAngleZ = 0.0;
	m_sPlayerStats.fSpeedX = 0.0;
	m_sPlayerStats.fSpeedZ = 0.0;
	m_sPlayerStats.fPosX = 0.0;
	m_sPlayerStats.fPosY = 0.0;
	m_sPlayerStats.fPosZ = 0.0;
	m_sPlayerStats.sPlayerColl.fPlayerHeight = 1.0;
	m_sPlayerStats.sPlayerColl.fPlayerWidth = 1.0;
	m_sPlayerStats.sPlayerColl.fPlayerLength = 1.0;
	for (u8 i = 0; i < 8; i++)
	{
		m_sPlayerStats.sPlayerColl.vTestPoint[i] = 0.0;
	}
}

CTestClient::~CTestClient(void)
{
	m_pTestThread->Terminate();
	FREEMEM(m_pTestThread);

	SDL_DestroyMutex(m_pMutex);

	SDLNet_Quit();
	SDL_Quit();
}

void CTestClient::init_sdl()
{
	if (SDL_Init(0) == -1) 
	{
	    cout << "SDL_Init: " << SDL_GetError() << endl;
	    exit (-1);
	}
	
	if (SDLNet_Init() == -1)
	{
		cout << "SDLNet_Init: " << SDLNet_GetError() << endl;
	    exit (-1);
	}
}

void CTestClient::init_net()
{
	IPaddress addr;
	if (SDLNet_Init () < 0)
	{
		printf ("ERR Net: %s\n", SDLNet_GetError ());
		exit (-1);
	}
	if (SDLNet_ResolveHost (&addr, "localhost", NET_DEFAULT_PORT) < 0)
	{
		printf ("ERR ResolveHost: %s\n", SDLNet_GetError ());
		SDLNet_Quit ();
		exit (-1);
	}
	m_soClient = SDLNet_TCP_Open (&addr);
	if (m_soClient == NULL)
	{
		printf ("ERR TCP_Open: %s\n", SDLNet_GetError ());
		SDLNet_Quit ();
		exit (-1);
	}
 }

bool CTestClient::Start()
{
	DEBUG_PRINTL("TestClient started");

	m_pTestThread = new CTestThread(this);

	// Neuen Thread erzeugen
	SDL_Thread* pThread = SDL_CreateThread(CTestThread::Start, (void*) m_pTestThread);
	if (pThread == NULL)
	{
		DEBUG_PRINTL("Thread could not be created");
		FREEMEM(m_pTestThread);
		
		return false;
	}

	// Thread-Pointer dem Client mitteilen
	m_pTestThread->SetThreadPointer(pThread);
	
	return true;
}


void CTestClient::AddMessage(CMessage* psMessage)
{
	SDL_LockMutex(m_pMutex);
	m_qMsgs.push(psMessage);
	SDL_UnlockMutex(m_pMutex);
}

void CTestClient::Commit()
{
	cout << "Committing " << m_qMsgs.size() << " Messages" << endl;

	SMessageHeader header;
	SDLNet_Write32(m_nAuthToken, &header.nAuthID);
	header.nNumMessages = m_qMsgs.size();
	SDLNet_Write32(header.nNumMessages, &header.nNumMessages);

	if(CMessage::SecureSend(m_soClient, (u8*) &header, sizeof(SMessageHeader)) == false)
	{		
		cout << "->Error Sending Header: " << SDLNet_GetError() << endl;
		exit (-1);		
	}

/*	if(CMessage::SecureRecv(m_soClient, (u8*) &header, sizeof(SMessageHeader)) == false)
	{
		cout << "->Error Receiving Header!" << endl;
		exit (-1);
	}*/

/*	int nRecvdToken = SDLNet_Read32(&header.nAuthID);

	if (m_nAuthToken != nRecvdToken)
	{
		m_nAuthToken = nRecvdToken;
		cout << "->Received new AuthToken: " << m_nAuthToken << endl;
	}*/

	int i = 1;
	CMessage* pMsg;
	while (!m_qMsgs.empty())
	{
		cout << "->Sending Message #" << i << endl;

		pMsg = m_qMsgs.front();
		u8* pSendBuffer = pMsg->Data();
		if (!pMsg->SecureSend(m_soClient, pSendBuffer, pMsg->GetSize()))
		{
			cerr << "->Error Sending Message!" << endl;
			exit(-1);
		}
		
		FREEMEM(pSendBuffer);	//Wichtig! Den Puffer brauchen wir nicht mehr
		m_qMsgs.pop();
		i++;
	}
}

void CTestClient::GenProgressMessage()
{
	SRequestGamePushProgress sRequest = { { 0, GAME_PUSH_PROGRESS }, m_sPlayerStats };	
	SDLNet_Write16(sizeof(SRequestGamePushProgress), &sRequest.sHeader.nMessageLength);

	u8* pBuffer = (u8*) &sRequest;
	CMessage* pMsg = new CMessage(sizeof(SRequestGamePushProgress), pBuffer);
		
	AddMessage(pMsg);
}

void CTestClient::Update()
{
	cout << "Checking for new messages" << endl;

	if (m_bGameRunning == true)
	{
		// Virtuelle Bewegung
		m_sPlayerStats.fPosX += 0.1;
		GenProgressMessage();
		Commit();
	}
	
	SMessageHeader header;

	if (CMessage::SecureRecv(m_soClient, (u8*) &header, sizeof(SMessageHeader)) == false)
	{
		cerr << "->Error Receiving Message!" << endl;
		exit (-1);
	}

	header.nNumMessages = SDLNet_Read32(&header.nNumMessages);
	cout << "->" << header.nNumMessages << " waiting in queue" << endl;

	SResponseHeader* pRespHeader;
	CMessage* pRespMsg;
	u8* pRespBody;
	SResponseClientLogin* pRespLogin;
	SResponseServerCreateGame* pCreateGame;
	SResponseMessageChat* pRespChat;
	SResponseGameJoin* pGameJoin;
	SResponseGameStart* pGameStart;
	SResponseGameGetPlayer* pGameGetPlayer;
	SResponseServerGetPlayer* pServerGetPlayer;
	SResponseGameGetPlayerInfo* pGameGetPlayerInfo;
	SResponseGameProgress* pGameProgress;
	SResponseServerGetGames* pServerGames;
	SResponseServerGetMaps* pServerMaps;
	SResponseGameMapConfig* pGameMap;
	SResponseGameGetMap* pGetMap;
	u16* pPlayerOrder;
	SPlayerInfo* pPlayerInfos;
	SGamePlayerInfo* pGamePlayerInfos;
	SGamePlayerStats* pPlayerStats;
	SGameInfo* pGameInfos;
	SMapInfo* pMapInfo;
	SResponseServerGetPlayer* pPlayers;
	SPlayerInfo* pPlayerInfo;
	u8* pData;
	FILE* fd;
	u16 nFileSize;

	for (unsigned int i = 0; i < header.nNumMessages; i++)
	{
		cout << "->Receiving Message #" << i << endl;

		//Header + Daten holen
		pRespMsg = new CMessage();

		if (!pRespMsg->RecvResponse(m_soClient))
		{
			cerr << "->Error receiving response message!" << endl;
			exit(-1);
		}

		pRespBody = pRespMsg->Data();
		pRespHeader = (SResponseHeader*) pRespBody;
		
		cout << "->Received Message Type " << (int) pRespHeader->eMessageType << endl;
		cout << "->With " << pRespHeader->nMessageLength << " Bytes" << endl;
		cout << "->Return Code " << (int) pRespHeader->eReturnCode << endl;

		//Je nach Message-Type eine Ausgabe machen
		switch (pRespHeader->eMessageType)
		{
			case CLIENT_LOGIN:
				cout << "->Client login response received" << endl;
				
				pRespLogin = (SResponseClientLogin*) pRespBody;
				pRespLogin->nAuthID = SDLNet_Read32(&pRespLogin->nAuthID);
				pRespLogin->nID = SDLNet_Read16(&pRespLogin->nID);
				cout << "->Login response authID: " << pRespLogin->nAuthID << " | Player-ID: " << pRespLogin->nID << endl;
				m_nAuthToken = pRespLogin->nAuthID;
			break;

			case CLIENT_LOGOUT:
				cout << "->Client logout response received" << endl;
			break;

			case SERVER_CREATE_GAME:
				cout << "->Server create game response received" << endl;

				pCreateGame = (SResponseServerCreateGame*) pRespBody;
				pCreateGame->nGameID = SDLNet_Read16(&pCreateGame->nGameID);
				cout << "->Create game response GameID: " << (int) pCreateGame->nGameID << endl;
			break;

			case GAME_JOIN:
				cout << "->Game join response received" << endl;

				pGameJoin = (SResponseGameJoin*) pRespBody;
				cout << "->Return Code: " << (int) pGameJoin->sHeader.eReturnCode << endl;
			break;

			case GAME_START:
				pGameStart = (SResponseGameStart*) pRespBody;
				if (pGameStart->sHeader.eReturnCode == CODE_OK)
				{
					cout << "->Game startet succesfully" << endl;
					m_bGameRunning = true;
				}
				else
				{
					cout << "->Failed to start game" << endl;
				}
			break;
			
			//case CLIENT_CHAT:
			case MESSAGE_CHAT:
				cout << "->Chat Message is following..." << endl;
				
				pRespChat = (SResponseMessageChat*) pRespBody;
				//char szMessage[MESSAGE_LENGTH];
				//memcpy(szMessage, pRespChat->szMessage, MESSAGE_LENGTH);
				cout << "->" << SDLNet_Read16(&pRespChat->nSender) << ": " << pRespChat->szMessage << endl;

			break;
			
			case GAME_GET_PLAYER:
				cout << "->Player info is following..." << endl;
				pGameGetPlayer = (SResponseGameGetPlayer*) pRespBody;
				pGameGetPlayer->nNumPlayer = SDLNet_Read16(&pGameGetPlayer->nNumPlayer);

				cout << "->Will print " << pGameGetPlayer->nNumPlayer << " records..." << endl;
				pPlayerInfos = (SPlayerInfo*) (pRespBody + sizeof(SResponseGameGetPlayer));
				for (u16 i = 0; i < pGameGetPlayer->nNumPlayer; i++)
				{
					cout << "ID: " << SDLNet_Read16(&(pPlayerInfos[i].nID)) << endl;
					cout << "Name: " << pPlayerInfos[i].szName << endl;
				}
			break;
			
			case SERVER_GET_PLAYER:
				cout << "->Player info is following..." << endl;
				pServerGetPlayer = (SResponseServerGetPlayer*) pRespBody;
				pServerGetPlayer->nNumPlayer = SDLNet_Read16(&pServerGetPlayer->nNumPlayer);

				cout << "->Will print " << pServerGetPlayer->nNumPlayer << " records..." << endl;
				pPlayerInfos = (SPlayerInfo*) (pRespBody + sizeof(SResponseGameGetPlayer));
				for (u16 i = 0; i < pServerGetPlayer->nNumPlayer; i++)
				{
					cout << "ID: " << SDLNet_Read16(&(pPlayerInfos[i].nID)) << endl;
					cout << "Name: " << pPlayerInfos[i].szName << endl;
				}
			break;
			
			case GAME_GET_PLAYERINFO:
				cout << "->Player ingame-info is following..." << endl;
				pGameGetPlayerInfo = (SResponseGameGetPlayerInfo*) pRespBody;
				pGameGetPlayerInfo->nNumPlayer = SDLNet_Read16(&pGameGetPlayerInfo->nNumPlayer);

				pPlayerOrder = (u16*) (pRespBody + sizeof(SResponseGameGetPlayerInfo));
				pGamePlayerInfos = (SGamePlayerInfo*) (pPlayerOrder + pGameGetPlayerInfo->nNumPlayer);
				
				cout << "->Will print " << pGameGetPlayerInfo->nNumPlayer << " records..." << endl;
				for (u16 i = 0; i < pGameGetPlayerInfo->nNumPlayer; i++)
				{
					cout << "State of Player: " << SDLNet_Read16(pPlayerOrder + i) << endl;
					cout << "Rounds won: " << (u16) pGamePlayerInfos[i].nRoundsWon << endl;
					cout << "Role in the game: " << (u16) pGamePlayerInfos[i].eRole << endl;
					cout << "State in the game: " << (u16) pGamePlayerInfos[i].eState << endl;
				}
			break;

			case GAME_PROGRESS:
				cout << "->Player traxi position is following..." << endl;
				pGameProgress = (SResponseGameProgress*) pRespBody;
				pGameProgress->nNumPlayer = SDLNet_Read16(&pGameProgress->nNumPlayer);
				
				pPlayerOrder = (u16*) (pRespBody + sizeof(SResponseGameProgress));
				pPlayerStats = (SGamePlayerStats*) (pPlayerOrder + pGameProgress->nNumPlayer);
				cout << "->Will print " << pGameProgress->nNumPlayer << " records..." << endl;
				for (u16 i = 0; i < pGameProgress->nNumPlayer; i++)
				{
					cout << "Player: " << SDLNet_Read16(pPlayerOrder + i);
					cout << " is currently at position (x,y,z): " << pPlayerStats[i].fPosX;
					cout << ", " << pPlayerStats[i].fPosX << ", " << pPlayerStats[i].fPosZ << endl;
				}
			break;
				
			case SERVER_GET_GAMES:
				cout << "->Printing all games on the server..." << endl;
				pServerGames = (SResponseServerGetGames*) pRespBody;
				pServerGames->nNumGames = SDLNet_Read16(&pServerGames->nNumGames);
				
				pGameInfos = (SGameInfo*) (pRespBody + sizeof(SResponseServerGetGames));
				
				cout << "->Will print " << pServerGames->nNumGames << " records..." << endl;
				for (u16 i = 0; i < pServerGames->nNumGames; i++)
				{
					cout << "Game: " << pGameInfos[i].szName << " with id " << SDLNet_Read16(&pGameInfos[i].nID);
					cout << " - " << (u16) pGameInfos[i].nNumPlayers << "/" << (u16) pGameInfos[i].nMaxPlayers << " Player";
					if (pGameInfos[i].eState == SERVERGAME_RUNNING)
					{
						cout << " - running";
					}
					cout << endl;
				}
			break;
			
			case SERVER_GET_MAPS:
				cout << "->Printing all maps on the server..." << endl;
				pServerMaps = (SResponseServerGetMaps*) pRespBody;
				pServerMaps->nNumMaps = SDLNet_Read16(&pServerMaps->nNumMaps);
				
				pMapInfo = (SMapInfo*) (pRespBody + sizeof(SResponseServerGetMaps));
				
				cout << "->Will print " << pServerMaps->nNumMaps << " records..." << endl;
				for (u16 i = 0; i < pServerMaps->nNumMaps; i++)
				{
					cout << "ID: " << (u16) pMapInfo[i].nID  << endl;
					cout << "Name: " << pMapInfo[i].szName  << endl;
					cout << "File: " << pMapInfo[i].szFile  << endl;
					cout << "Max Player: " << (u16) pMapInfo[i].nNumPlayer  << endl;
				}
			break;
			
			case GAME_MAP_CONFIG:
				pGameMap = (SResponseGameMapConfig*) pRespBody;
				if (pGameMap->sHeader.eReturnCode == CODE_OK)
				{
					cout << "->Map config succesfully" << endl;
				}
				else
				{
					cout << "->Failed to configure maps" << endl;
				}
				
			break;
			
			case GAME_GET_MAP:
				pGetMap = (SResponseGameGetMap*) pRespBody;
				if (pGetMap->sHeader.eReturnCode == CODE_OK)
				{
					pGetMap->nLength = SDLNet_Read16(&pGetMap->nLength);
					nFileSize = 0;
					
					fd = fopen("/tmp/test", "w");
					pData = pRespBody + sizeof(SResponseGameGetMap);
					//while (nFileSize < pGetMap->nLength)
					//{
						nFileSize += fwrite(pData + nFileSize, 1, pGetMap->nLength, fd);
					//}
					
					fclose(fd);
					
					cout << "->Map received succesfully" << endl;
				}
				
			break;
			
			default:
				cerr << "->Unknown response type" << endl;
			break;
		}

		FREEMEM(pRespMsg);	//Bringt nen Speicherzugriffsfehler... jetzt komischerweise nicht mehr!
	}
}

void CTestClient::ClientLogin(char* szName)
{
	SRequestClientLogin* pLogin = new SRequestClientLogin;
	pLogin->sHeader.eMessageType = CLIENT_LOGIN;

	if (!szName)
	{
		char szInput[PLAYER_NAME_LENGTH];
		cout << "Your name: ";
		fgets(szInput, PLAYER_NAME_LENGTH, stdin);
		fflush(stdin);

		szInput[strlen(szInput) - 1] = '\0';	//Zeilenumbruch entfernen
		memcpy(pLogin->szName, szInput, PLAYER_NAME_LENGTH);
	}
	else
	{
		memcpy(pLogin->szName, szName, PLAYER_NAME_LENGTH);
	}

	SDLNet_Write16(sizeof(SRequestClientLogin), &pLogin->sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) pLogin;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestClientLogin), pBuffer);
	FREEMEM(pLogin);	//CMessage kopiert den Puffer, daher ist das hier wichtig!

	AddMessage(pMsg);
	cout << "Added client login to message queue with size " << pMsg->GetSize() << endl;
	GetMaps();
}


void CTestClient::ClientLogout()
{	
	SRequestClientLogout* pLogout = new SRequestClientLogout;
	pLogout->sHeader.eMessageType = CLIENT_LOGOUT;
	SDLNet_Write16(sizeof(SRequestClientLogout), &pLogout->sHeader.nMessageLength);

	u8* pBuffer = (u8*) pLogout;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestClientLogout), pBuffer);
	FREEMEM(pLogout);	//CMessage kopiert den Puffer, daher ist das hier wichtig!

	AddMessage(pMsg);

	cout << "Added client logout to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::ClientChat()
{
	SRequestClientChat* pChat = new SRequestClientChat;
	pChat->sHeader.eMessageType = CLIENT_CHAT;

	char szMessage[MESSAGE_LENGTH];
	cout << "Your message: ";
	fgets(szMessage, MESSAGE_LENGTH, stdin); //<- Sicherer als scanf und liest auch Leerzeichen ein!
	fflush(stdin);

	szMessage[strlen(szMessage) - 1] = '\0';	//Zeilenumbruch entfernen

	memcpy(pChat->szMessage, szMessage, MESSAGE_LENGTH);

	SDLNet_Write16(sizeof(SRequestClientChat), &pChat->sHeader.nMessageLength);
	u8* pBuffer = (u8*) pChat;
	
	CMessage* pMsg = new CMessage(sizeof(SRequestClientChat), pBuffer);
	FREEMEM(pChat);

	AddMessage(pMsg);

	cout << "Added chat message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::FetchMessages()
{
	SRequestClientFetchMessages sRequest = { { 0, CLIENT_FETCH_MESSAGES } };
	SDLNet_Write16(sizeof(SRequestClientFetchMessages), &sRequest.sHeader.nMessageLength);

	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestClientFetchMessages), pBuffer);
	
	AddMessage(pMsg);
}

void CTestClient::CreateGame(char* szDefGameName, int nMaxPlayers, char* szDefPasswd, char* szDefMaps)
{
	SRequestServerCreateGame* pCreateGame = new SRequestServerCreateGame;
	pCreateGame->sHeader.eMessageType = SERVER_CREATE_GAME;

	char szGameName[GAME_NAME_LENGTH];

	if (!szDefGameName)
	{
		cout << "Game name: ";
		fgets(szGameName, GAME_NAME_LENGTH, stdin);
		fflush(stdin);
		szGameName[strlen(szGameName) - 1] = '\0';	//Zeilenumbruch entfernen
		memcpy(pCreateGame->szGameName, szGameName, GAME_NAME_LENGTH);
	}
	else
	{
		memcpy(pCreateGame->szGameName, szDefGameName, GAME_NAME_LENGTH);
	}

	//unsigned short nMaxPlayers = 0;
	while (nMaxPlayers < 2 || nMaxPlayers > 8)	//korrekte Anzahl bitte!
	{
		cout << "Max players: ";
		fgets(szGameName, 3, stdin);	//wir missbrauchen szGameName nochmal
		fflush(stdin);
		nMaxPlayers = atoi(szGameName);
	}
	pCreateGame->nMaxPlayer = (u8) nMaxPlayers;

	if (!szDefGameName)
	{
		cout << "Late join? (y/n) ";
		fgets(szGameName, 2, stdin);	//wir missbrauchen szGameName nochmal
		fflush(stdin);
		pCreateGame->bAllowLateJoin = (szGameName[0] == 'y');

		cout << "Visitors? (y/n) ";
		fgets(szGameName, 2, stdin);	//wir missbrauchen szGameName nochmal
		fflush(stdin);
		pCreateGame->bAllowVisitors = (szGameName[0] == 'y');
	}
	else
	{
		pCreateGame->bAllowLateJoin = true;
		pCreateGame->bAllowVisitors = true;
	}

	if (!szDefPasswd)
	{
		cout << "Password (leave blank for no pw): ";
		char szPasswd[GAME_PASSWD_LENGTH];
		fgets(szPasswd, GAME_PASSWD_LENGTH, stdin);
		fflush(stdin);
		szPasswd[strlen(szPasswd) - 1] = '\0';	//Zeilenumbruch entfernen
		memcpy(pCreateGame->szPassword, szPasswd, GAME_PASSWD_LENGTH);
	}
	else
	{
		memcpy(pCreateGame->szPassword, szDefPasswd, GAME_PASSWD_LENGTH);
	}

	SDLNet_Write16(sizeof(SRequestServerCreateGame), &pCreateGame->sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) pCreateGame;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestServerCreateGame), pBuffer);
	FREEMEM(pCreateGame);	//CMessage kopiert den Puffer, daher ist das hier wichtig!

	AddMessage(pMsg);

	char* szMaps;
	if (!szDefMaps)
	{
		cout << "Maps to play (separate by ,): ";
		szMaps = new char[20];
		char szMaps[20];
		fgets(szMaps, 20, stdin);
		fflush(stdin);
	}
	else
	{
		szMaps = new char[strlen(szDefMaps)];
		memcpy(szMaps, szDefMaps, strlen(szDefMaps));
	}
	
	char* szID = strtok(szMaps, ",");
	while (szID != NULL)
	{
		u8 nMapID = atoi(szID);
		AddMap(nMapID);
		szID = strtok(NULL, ",");
	}
	FREEMEM_ARRAY(szMaps);
		
	cout << "Added creategame to message queue with size " << pMsg->GetSize() << endl;
}


void CTestClient::JoinGame(int nGameID)
{
	SRequestGameJoin* pJoin = new SRequestGameJoin;
	pJoin->sHeader.eMessageType = GAME_JOIN;

	char szInput[GAME_PASSWD_LENGTH];

	//unsigned short nGameID = 0;
	if (nGameID == -1)
	{
		cout << "Game ID: ";
		fgets(szInput, 3, stdin);	//wir missbrauchen szGameName nochmal
		fflush(stdin);
		nGameID = atoi(szInput);
	}

	SDLNet_Write16(nGameID, &pJoin->nGameID);

	cout << "Game password: ";
	fgets(szInput, GAME_PASSWD_LENGTH, stdin); //<- Sicherer als scanf und liest auch Leerzeichen ein!
	fflush(stdin);

	szInput[strlen(szInput) - 1] = '\0';	//Zeilenumbruch entfernen

	memcpy(pJoin->szPassword, szInput, GAME_PASSWD_LENGTH);
	
	SDLNet_Write16(sizeof(SRequestGameJoin), &pJoin->sHeader.nMessageLength);

	u8* pBuffer = (u8*) pJoin;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestGameJoin), pBuffer);
	FREEMEM(pJoin);

	AddMessage(pMsg);

	cout << "Added join message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::LeaveGame()
{
	SRequestGameLeave sRequest = { { 0, GAME_LEAVE } };	
	SDLNet_Write16(sizeof(SRequestGameLeave), &sRequest.sHeader.nMessageLength);

	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestGameLeave), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added leave message to message queue with size " << pMsg->GetSize() << endl;
	m_bGameRunning = false;
}

void CTestClient::StartGame()
{
	SRequestGameStart* pStart = new SRequestGameStart;
	pStart->sHeader.eMessageType = GAME_START;
	
	SDLNet_Write16(sizeof(SRequestGameStart), &pStart->sHeader.nMessageLength);

	u8* pBuffer = (u8*) pStart;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestGameStart), pBuffer);
	FREEMEM(pStart);

	AddMessage(pMsg);

	cout << "Added start message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetPlayerInGame()
{
	SRequestGameGetPlayer* pGetPlayer = new SRequestGameGetPlayer;
	pGetPlayer->sHeader.eMessageType = GAME_GET_PLAYER;
	
	SDLNet_Write16(sizeof(SRequestGameGetPlayer), &pGetPlayer->sHeader.nMessageLength);

	u8* pBuffer = (u8*) pGetPlayer;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestGameGetPlayer), pBuffer);
	FREEMEM(pGetPlayer);

	AddMessage(pMsg);

	cout << "Added get player in game message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetPlayerOnServer()
{
	SRequestServerGetPlayer* pGetPlayer = new SRequestServerGetPlayer;
	pGetPlayer->sHeader.eMessageType = SERVER_GET_PLAYER;
	
	SDLNet_Write16(sizeof(SRequestServerGetPlayer), &pGetPlayer->sHeader.nMessageLength);

	u8* pBuffer = (u8*) pGetPlayer;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestServerGetPlayer), pBuffer);
	FREEMEM(pGetPlayer);

	AddMessage(pMsg);

	cout << "Added get player on server message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetPlayerInfo()
{
	SRequestGameGetPlayerInfo sRequest = { { 0, GAME_GET_PLAYERINFO } };	
	SDLNet_Write16(sizeof(SRequestGameGetPlayerInfo), &sRequest.sHeader.nMessageLength);

	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestGameGetPlayerInfo), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added game player info message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetGames(bool bAskValues, bool bOnlyFreeGames)
{
	SRequestServerGetGames sRequest = { { 0, SERVER_GET_GAMES }, bOnlyFreeGames, false, 0, 0 };
	SDLNet_Write16(sizeof(SRequestServerGetGames), &sRequest.sHeader.nMessageLength);
	
	char szBuffer[2];
	if (bAskValues == true)
	{
		cout << "Only free games? (y/n) ";
		fgets(szBuffer, 2, stdin);	//wir missbrauchen szGameName nochmal
		fflush(stdin);
		sRequest.bOnlyFreeGames = (szBuffer[0] == 'y') ? true : false;
	}
	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestServerGetGames), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added get server games message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetMaps()
{
	SRequestServerGetMaps sRequest = { { 0, SERVER_GET_MAPS } };
	SDLNet_Write16(sizeof(SRequestServerGetMaps), &sRequest.sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestServerGetMaps), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added get server maps message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::GetPlayer()
{
	SRequestServerGetPlayer sRequest = { { 0, SERVER_GET_PLAYER } };
	SDLNet_Write16(sizeof(SRequestServerGetPlayer), &sRequest.sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestServerGetPlayer), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added get server players message to message queue with size " << pMsg->GetSize() << endl;
}


void CTestClient::Chat(const char* szMessage)
{
	SRequestClientChat sRequest;
	sRequest.sHeader.eMessageType = CLIENT_CHAT;
	memset(&sRequest.szMessage, 0, MESSAGE_LENGTH);
	
	if (szMessage == NULL)
	{
		char szBuffer[MESSAGE_LENGTH];
		cout << "Enter message: ";
		fgets(szBuffer, MESSAGE_LENGTH, stdin);
		fflush(stdin);
		memcpy(&sRequest.szMessage, szBuffer, strlen(szBuffer));
	}
	else
	{
		memcpy(&sRequest.szMessage, szMessage, (strlen(szMessage) > MESSAGE_LENGTH) ? MESSAGE_LENGTH : strlen(szMessage));
	}
	
	SDLNet_Write16(sizeof(SRequestClientChat), &sRequest.sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) &sRequest;	//Fragt mich nicht, warum DAS n�tig ist...
	CMessage* pMsg = new CMessage(sizeof(SRequestClientChat), pBuffer);
	
	AddMessage(pMsg);

	cout << "Added chat message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::AddMap(u8 nMapID)
{
	SRequestGameMapConfig sRequest = { { 0, GAME_MAP_CONFIG }, REQUEST_ADD_MAP, 1, nMapID };
	SDLNet_Write16(sizeof(SRequestGameMapConfig), &sRequest.sHeader.nMessageLength);
	
	u8* pBuffer = (u8*) &sRequest;
	CMessage* pMsg = new CMessage(sizeof(SRequestGameMapConfig), pBuffer);
		
	AddMessage(pMsg);
	
	cout << "Added add map message to message queue with size " << pMsg->GetSize() << endl;
}

void CTestClient::RunTests(int nTestNum)
{
	//vordefinierte Testskripte:

	switch (nTestNum)
	{
		default:
			cout << "unknown test script." << endl;
		break;

		case 0:
			cout << "login and create game" << endl;
			ClientLogin("testuser");
			CreateGame("test game", 2, "\0", "0,1,2");
			Commit();
		break;

		case 1:
			cout << "login and join game and start" << endl;
			ClientLogin("testuser2");
			JoinGame(0);
			StartGame();
			Commit();
		break;
		
		case 2:
			cout << "login and create game" << endl;
			ClientLogin("testuser");
			CreateGame("test game", 2, "\0");
			GetPlayerInfo();
			Commit();
		break;
		
		case 3:
			cout << "get all server games (only free and then all)" << endl;
			ClientLogin("testuser");
			GetGames(false, true);
			GetGames(false, false);
			Commit();
		break;
			
		case 4:
			cout << "get all server maps" << endl;
			ClientLogin("testuser");
			GetMaps();
			Commit();
		break;
		
		case 5:
			cout << "Chat with server" << endl;
			ClientLogin("chat");
			Chat("Hallo Welt");
			JoinGame(0);
			Chat("Hallo InGame");
			Commit();
			
		break;
		
		case 6:
			cout << "BIG test" << endl;
			ClientLogin("bigtester");
			Commit();
			//sleep(2);
			Chat("Hallo Welt");
			CreateGame("test game", 2, "\0", "0,1,2");
			LeaveGame();
			Commit();
			JoinGame(0);
			Chat("Hallo player");
			LeaveGame();
			ClientLogout();
			Commit();
			
		break;

	}
}

int main(int argc, char** argv)
{
	CTestClient Client;

	char szInput[256];
	bool bExit = false;

	while (!bExit)
	{
		cout << "Bitte Kommandos eingeben: test, login, logout, chat, creategame, join" << endl;
		cout << "leave, getgames, getmaps, gameplayer, serverplayer, gameplayerinfo, start" << endl;
		cout << "fetch, chat, commit, exit" <<  endl;

		scanf("%s", szInput);
		fflush(stdin);
		
		if (strcmp(szInput, "test") == 0)
		{
			cout << "Which test?" << endl;
			scanf("%s", szInput);
			fflush(stdin);

			Client.RunTests(atoi(szInput));
		}
		else if (strcmp(szInput, "login") == 0)
		{
			Client.ClientLogin();
		}
		else if (strcmp(szInput, "logout") == 0)
		{
			Client.ClientLogout();
		}
		else if (strcmp(szInput, "chat") == 0)
		{
			Client.ClientChat();
		}
		else if (strcmp(szInput, "fetch") == 0)
		{
			Client.FetchMessages();
		}
		else if (strcmp(szInput, "creategame") == 0)
		{
			Client.CreateGame();
		}
		else if (strcmp(szInput, "getgames") == 0)
		{
			Client.GetGames();
		}
		else if (strcmp(szInput, "getplayer") == 0)
		{
			Client.GetPlayer();
		}
		else if (strcmp(szInput, "getmaps") == 0)
		{
			Client.GetMaps();
		}
		else if (strcmp(szInput, "serverplayer") == 0)
		{
			Client.GetPlayerOnServer();
		}
		else if (strcmp(szInput, "chat") == 0)
		{
			Client.Chat();
		}
		else if (strcmp(szInput, "gameplayer") == 0)
		{
			Client.GetPlayerInGame();
		}
		else if (strcmp(szInput, "gameplayerinfo") == 0)
		{
			Client.GetPlayerInfo();
		}
		else if (strcmp(szInput, "join") == 0)
		{
			Client.JoinGame();
		}
		
		else if (strcmp(szInput, "leave") == 0)
		{
			Client.LeaveGame();
		}

		else if (strcmp(szInput, "start") == 0)
		{
			Client.StartGame();
		}

		else if (strcmp(szInput, "commit") == 0)
		{
			Client.Commit();
		}
		else if (strcmp(szInput, "exit") == 0)
		{
			bExit = true;
		}
	}
		
	return 0;
}
