#ifndef TESTCLIENT_HPP
#define TESTCLIENT_HPP

#include "../globals.hpp"
#include "../net/NetworkTypes.hpp"
#include "PlatformFramework.hpp"
#include "../net/SocketFramework.hpp"
#include "../net/NetworkMessages.hpp"
#include "../net/Message.hpp"
#include "TestThread.hpp"

#include <string.h>
#include <cstdio>
#include <iostream>
#include <queue>

#define TO_NET_16(x)	SDLNet_Write16(x, &x);
#define FROM_NET_16(x)	x = SDLNet_Read16(&x);
#define TO_NET_32(x)	SDLNet_Write32(x, &x);
#define FROM_NET_32(x)	x = SDLNet_Read32(&x);

class CTestThread;

class CTestClient
{
public:
	CTestClient(void);
	~CTestClient(void);
	void Commit();
	void Update();
	void GenProgressMessage();
	void RunTests(int nTestNum);
	void ClientLogin(char* szName = NULL);
	void ClientLogout(void);
	void ClientChat(void);
	void GetGames(bool bAskValues = true, bool bOnlyFreeGames = false);
	void GetPlayer(void);
	void CreateGame(char* szGameName = NULL, int nMaxPlayers = 0, char* szPasswd = NULL, char* szDefMaps = NULL);
	void JoinGame(int nGameID = -1);	
	void StartGame();
	void LeaveGame();
	void GetPlayerInGame();
	void GetPlayerOnServer();
	void GetPlayerInfo();
	void GetMaps();
	void FetchMessages();
	void Chat(const char* szMessage = NULL);
	void AddMap(u8 nMapID);
	void AddMessage(CMessage* psMessage);
	
private:
	void init_sdl(void);
	void init_net(void);
	bool Start();

	TCPsocket m_soClient;
	u32 m_nAuthToken;
	//u32 m_nNumMessages;
	queue<CMessage*> m_qMsgs;
	SDL_mutex* m_pMutex;
	CTestThread* m_pTestThread;
	
	// Ist das Spiel gestartet?
	bool m_bGameRunning;
	
	// Player game position
	SGamePlayerStats m_sPlayerStats;
};

#endif ///TESTCLIENT_HPP///

