#include "TestThread.hpp"

CTestThread::CTestThread(CTestClient* pTestClient)
{
	m_pTestClient = pTestClient;
	m_bTerminate = false;
}


CTestThread::~CTestThread()
{
	
}


void CTestThread::SetThreadPointer(SDL_Thread* pThread)
{
	m_pThread = pThread;
}

SDL_Thread* CTestThread::GetThreadPointer()
{
	return m_pThread;
}

void CTestThread::Terminate()
{
	m_bTerminate = true;
}

int CTestThread::Start(void* pTestThread)
{
	DEBUG_PRINTL("TestThread started");
	CTestThread* pThread = (CTestThread*) pTestThread;
	
	// Ausfuehrung wird gestartet
	pThread->Run();	//Endlosschleife bis Terminate() aufgerufen wird

	//Thread soll sich ordentlich beenden
	SDL_WaitThread(pThread->GetThreadPointer(), NULL);

	FREEMEM(pThread);
	return 0;
}

void CTestThread::Run()
{
	while (!m_bTerminate)
	{
		//DEBUG_PRINTL("Updating...");
		m_pTestClient->Update();
		SDL_Delay(1000);
	}
}